/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IContentModelBiz;
import com.mingsoft.mdiy.biz.IContentModelFieldBiz;
import com.mingsoft.mdiy.biz.IFormBiz;
import com.mingsoft.mdiy.entity.ContentModelEntity;
import com.mingsoft.mdiy.entity.FormEntity;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/contentModel/"})
public class ContentModelAction
extends BaseAction {
    private static final String TABLE_NAME_PREFIX = "mdiy_";
    private static final String TABLE_NAME_SPLIT = "_";
    @Autowired
    private IContentModelBiz contentModelBiz;
    @Autowired
    IFormBiz formBiz;
    @Autowired
    private IContentModelFieldBiz fieldBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/mdiy/content_model/index");
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (contentModel.getCmId() > 0) {
            BaseEntity contentModelEntity = this.contentModelBiz.getEntity(contentModel.getCmId());
            model.addAttribute("contentModelEntity", (Object)contentModelEntity);
        }
        return this.view("/mdiy/content_model/form");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        contentModel.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List contentModelList = this.contentModelBiz.query((BaseEntity)contentModel);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(contentModelList, (int)BasicUtil.endPage((List)contentModelList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (contentModel.getCmId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("cm.id")}));
            return;
        }
        ContentModelEntity _contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(contentModel.getCmId());
        this.outJson(response, JSONObject.toJSON((Object)((Object)_contentModel)));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:del"})
    public void delete(@RequestBody List<ContentModelEntity> contentModels, HttpServletResponse response, HttpServletRequest request) {
        for (int i = 0; i < contentModels.size(); ++i) {
            if (contentModels.size() <= 0 || contentModels.get(i) == null) continue;
            ContentModelEntity cme = (ContentModelEntity)this.contentModelBiz.getEntity(contentModels.get(i).getCmId());
            if (cme != null) {
                this.contentModelBiz.dropTable(cme.getCmTableName());
            }
            this.contentModelBiz.deleteEntity(contentModels.get(i).getCmId());
        }
        this.outJson(response, true);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:save"})
    public void save(@ModelAttribute ContentModelEntity contentModel, HttpServletRequest request, HttpServletResponse response) {
        contentModel.setAppId(BasicUtil.getAppId());
        if (!StringUtil.checkLength((String)contentModel.getCmTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.tips.name"), "1", "30"}));
            return;
        }
        if (!StringUtil.checkLength((String)contentModel.getCmTableName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.table.name"), "1", "20"}));
            return;
        }
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        ContentModelEntity contentModelEntity = new ContentModelEntity();
        contentModelEntity.setCmTableName(TABLE_NAME_PREFIX + contentModel.getCmTableName() + TABLE_NAME_SPLIT + managerId);
        if (this.contentModelBiz.getEntity((BaseEntity)contentModelEntity) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("content.model")}));
            return;
        }
        contentModel.setCmTableName(TABLE_NAME_PREFIX + contentModel.getCmTableName() + TABLE_NAME_SPLIT + managerId);
        this.contentModelBiz.createTable(contentModel.getCmTableName(), null);
        this.contentModelBiz.saveEntity((BaseEntity)contentModel);
        int cmId = ((ContentModelEntity)((Object)this.contentModelBiz.getEntity((BaseEntity)contentModelEntity))).getCmId();
        this.outJson(response, null, true, String.valueOf(cmId));
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:update"})
    public void update(@ModelAttribute ContentModelEntity contentModel, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)contentModel.getCmTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.tips.name"), "1", "30"}));
            return;
        }
        this.contentModelBiz.updateEntity((BaseEntity)contentModel);
        this.outJson(response, null, true, null);
    }

    @RequestMapping(value={"/{cmTableName}/checkcmTableNameExist"})
    @ResponseBody
    public boolean checkcmTableNameExist(@PathVariable String cmTableName, HttpServletRequest request) {
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        cmTableName = TABLE_NAME_PREFIX + cmTableName + TABLE_NAME_SPLIT + managerId;
        ContentModelEntity contentModel = new ContentModelEntity();
        contentModel.setCmTableName(cmTableName);
        FormEntity formEntity = new FormEntity();
        formEntity.setFormTableName(cmTableName);
        return this.contentModelBiz.getEntity((BaseEntity)contentModel) != null || this.formBiz.getEntity((BaseEntity)formEntity) != null;
    }
}

