/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferGenerator_124;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.cache.statetransfer.StateTransferIntegrator_124;
import org.jboss.invocation.MarshalledValueInputStream;

public abstract class StateTransferFactory {
    public static StateTransferGenerator getStateTransferGenerator(TreeCache cache) {
        short version = cache.getStateTransferVersion();
        switch (version) {
            case 124: {
                return new StateTransferGenerator_124(cache);
            }
        }
        throw new IllegalStateException("Unknown state transfer version " + version);
    }

    public static StateTransferIntegrator getStateTransferIntegrator(byte[] state, Fqn targetFqn, TreeCache cache) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(state);
        bais.mark(1000);
        short version = 0;
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)bais);
        try {
            version = in.readShort();
            switch (version) {
                case 124: {
                    StateTransferIntegrator_124 stateTransferIntegrator_124 = new StateTransferIntegrator_124((ObjectInputStream)in, targetFqn, cache);
                    return stateTransferIntegrator_124;
                }
            }
            throw new IllegalStateException("Unknown state transfer version " + version);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException io) {}
        }
    }
}

