/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.marshall.MarshallingException;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.marshall.RegionNotFoundException;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;

public class TreeCacheMarshaller
implements RpcDispatcher.Marshaller {
    protected RegionManager manager_;
    protected boolean defaultInactive_;
    private ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    private Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$marshall$TreeCacheMarshaller == null ? (class$org$jboss$cache$marshall$TreeCacheMarshaller = TreeCacheMarshaller.class$("org.jboss.cache.marshall.TreeCacheMarshaller")) : class$org$jboss$cache$marshall$TreeCacheMarshaller));
    static /* synthetic */ Class class$org$jboss$cache$marshall$TreeCacheMarshaller;

    public TreeCacheMarshaller(RegionManager manager, boolean defaultInactive) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this.manager_ = manager;
        this.defaultInactive_ = defaultInactive;
    }

    public void registerClassLoader(String fqn, ClassLoader cl) throws RegionNameConflictException {
        Region existing = this.manager_.getRegion(fqn);
        if (existing == null) {
            this.manager_.createRegion(fqn, cl, this.defaultInactive_);
        } else {
            existing.setClassLoader(cl);
        }
    }

    public void unregisterClassLoader(String fqn) throws RegionNotFoundException {
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            region.setClassLoader(null);
        }
    }

    public ClassLoader getClassLoader(String fqn) throws RegionNotFoundException {
        ClassLoader result = null;
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            result = region.getClassLoader();
        }
        return result;
    }

    public void activate(String fqn) throws RegionNameConflictException {
        if (this.manager_.hasRegion(fqn)) {
            Region region = this.manager_.getRegion(fqn);
            if (!this.defaultInactive_ && region.getClassLoader() == null) {
                this.manager_.removeRegion(fqn);
            } else {
                region.activate();
            }
        } else if (this.defaultInactive_) {
            this.manager_.createRegion(fqn, null, false);
        } else {
            this.manager_.checkConflict(fqn);
        }
    }

    public void inactivate(String fqn) throws RegionNameConflictException {
        if (this.manager_.hasRegion(fqn)) {
            Region region = this.manager_.getRegion(fqn);
            if (this.defaultInactive_ && region.getClassLoader() == null) {
                this.manager_.removeRegion(fqn);
            } else {
                region.inactivate();
            }
        } else if (!this.defaultInactive_) {
            this.manager_.createRegion(fqn, null, true);
        } else {
            this.manager_.checkConflict(fqn);
        }
    }

    public boolean isInactive(String fqn) {
        boolean result = this.defaultInactive_;
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            result = region.isInactive();
        }
        return result;
    }

    public byte[] objectToByteBuffer(Object o) throws Exception {
        MethodCall call = (MethodCall)o;
        String fqn = null;
        if (call.getMethod().equals(TreeCache.replicateMethod)) {
            fqn = this.extractFqnFromMethodCall(call);
        } else if (call.getMethod().equals(TreeCache.replicateAllMethod)) {
            fqn = this.extractFqnFromListOfMethodCall(call);
        } else {
            throw new IllegalStateException("TreeCacheMarshaller.objectToByteBuffer(): MethodCall name is either not  replicate or replicateAll but : " + call.getName());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MarshalledValueOutputStream oos = new MarshalledValueOutputStream((OutputStream)bos);
        if (fqn == null) {
            fqn = "NULL";
        }
        oos.writeUTF(fqn);
        oos.writeObject(o);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromByteBuffer(byte[] bytes) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        MarshalledValueInputStream ois = new MarshalledValueInputStream((InputStream)is);
        String fqn = ois.readUTF();
        ClassLoader oldTcl = null;
        Region region = null;
        if (fqn != null && !fqn.equals("NULL")) {
            region = this.manager_.getRegion(fqn);
            if (region != null) {
                if (region.getStatus() == 1) {
                    if (this.log_.isTraceEnabled()) {
                        this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in the inactive default region"));
                    }
                    return new MethodCall(TreeCache.notifyCallOnInactiveMethod, new Object[]{fqn});
                }
                ClassLoader cl = region.getClassLoader();
                if (cl != null) {
                    oldTcl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    if (this.log_.isTraceEnabled()) {
                        this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " Will use customed class loader " + cl));
                    }
                }
            } else if (this.defaultInactive_) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in an inactive region"));
                }
                return new MethodCall(TreeCache.notifyCallOnInactiveMethod, new Object[]{fqn});
            }
        }
        Object obj = null;
        try {
            obj = ois.readObject();
            Object var9_8 = null;
            if (oldTcl != null) {
                Thread.currentThread().setContextClassLoader(oldTcl);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (oldTcl != null) {
                Thread.currentThread().setContextClassLoader(oldTcl);
            }
            throw throwable;
        }
        if (obj == null) {
            throw new MarshallingException("Read null object with fqn: " + fqn);
        }
        if (region != null && region.isQueueing()) {
            obj = new MethodCall(TreeCache.enqueueMethodCallMethod, new Object[]{region.getFqn(), obj});
        }
        return obj;
    }

    protected String extractFqnFromMethodCall(MethodCall call) {
        MethodCall c0 = (MethodCall)call.getArgs()[0];
        return this.extractFqn(c0);
    }

    protected String extractFqnFromListOfMethodCall(MethodCall call) {
        Object[] args = call.getArgs();
        MethodCall c0 = (MethodCall)((List)args[0]).get(0);
        return this.extractFqn(c0);
    }

    protected String extractFqn(MethodCall method_call) {
        if (method_call == null) {
            throw new NullPointerException("method call is null");
        }
        Method meth = method_call.getMethod();
        String fqnStr = null;
        if (meth.equals(TreeCache.prepareMethod)) {
            Object[] args = method_call.getArgs();
            List modifications = (List)args[1];
            fqnStr = this.extractFqn((MethodCall)modifications.get(0));
            boolean one_phase_commit = (Boolean)args[3];
            if (!one_phase_commit) {
                this.transactions.put(args[0], (Object)fqnStr);
            }
        } else if (TreeCache.isCrudMethod(meth)) {
            Object[] args = method_call.getArgs();
            Fqn fqn = (Fqn)args[1];
            fqnStr = fqn.toString();
        } else if (meth.equals(TreeCache.rollbackMethod) || meth.equals(TreeCache.commitMethod)) {
            Object[] args = method_call.getArgs();
            fqnStr = (String)this.transactions.remove(args[0]);
        } else if (meth.equals(TreeCache.getPartialStateMethod)) {
            Object[] args = method_call.getArgs();
            Fqn fqn = (Fqn)args[0];
            fqnStr = fqn.toString();
        } else {
            throw new IllegalArgumentException("TreeCacheMarshaller.extractFqn(): Unknow method call name: " + meth.getName());
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("extract(): received " + method_call + "extracted fqn: " + fqnStr));
        }
        return fqnStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

