/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;

public class TcpDelegatingCacheLoader
extends DelegatingCacheLoader {
    private Socket sock;
    private String host;
    private int port;
    ObjectInputStream in;
    ObjectOutputStream out;

    public TcpDelegatingCacheLoader() {
    }

    public TcpDelegatingCacheLoader(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setConfig(Properties props) {
        this.host = props.getProperty("host");
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = Integer.parseInt(props.getProperty("port"));
    }

    public void start() throws Exception {
        this.init();
    }

    public void stop() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() throws IOException {
        if (this.host == null) {
            this.host = "localhost";
        }
        this.sock = new Socket(this.host, this.port);
        this.out = new ObjectOutputStream(this.sock.getOutputStream());
        this.in = new ObjectInputStream(this.sock.getInputStream());
    }

    public void setCache(TreeCache cache) {
    }

    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        this.out.writeInt(1);
        this.out.writeObject(fqn);
        return (Set)this.in.readObject();
    }

    protected Object delegateGet(Fqn name, Object key) throws Exception {
        this.out.writeInt(2);
        this.out.writeObject(name);
        this.out.writeObject(key);
        return this.in.readObject();
    }

    protected Map delegateGet(Fqn name) throws Exception {
        this.out.writeInt(3);
        this.out.writeObject(name);
        return (Map)this.in.readObject();
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        this.out.writeInt(4);
        this.out.writeObject(name);
        return this.in.readBoolean();
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        this.out.writeInt(5);
        this.out.writeObject(name);
        this.out.writeObject(key);
        this.out.writeObject(value);
        return this.in.readObject();
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.out.writeInt(6);
        this.out.writeObject(name);
        this.out.writeObject(attributes);
        this.out.flush();
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        this.out.writeInt(7);
        this.out.writeObject(name);
        this.out.writeObject(key);
        return this.in.readObject();
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.out.writeInt(8);
        this.out.writeObject(name);
        this.out.flush();
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.out.writeInt(9);
        this.out.writeObject(name);
        this.out.flush();
    }

    public byte[] delegateLoadEntireState() throws Exception {
        this.out.writeInt(10);
        return (byte[])this.in.readObject();
    }

    public void delegateStoreEntireState(byte[] state) throws Exception {
        this.out.writeInt(11);
        this.out.writeObject(state);
        this.out.flush();
    }
}

