/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;

public class TcpCacheServer {
    ServerSocket srv_sock;
    InetAddress bind_addr = null;
    int port = 2099;
    TreeCache cache;
    String config;
    static Log log = LogFactory.getLog((Class)(class$org$jboss$cache$loader$tcp$TcpCacheServer == null ? (class$org$jboss$cache$loader$tcp$TcpCacheServer = TcpCacheServer.class$("org.jboss.cache.loader.tcp.TcpCacheServer")) : class$org$jboss$cache$loader$tcp$TcpCacheServer));
    static /* synthetic */ Class class$org$jboss$cache$loader$tcp$TcpCacheServer;

    public TcpCacheServer(String bind_addr, int port, String config) throws UnknownHostException {
        if (bind_addr != null) {
            this.bind_addr = InetAddress.getByName(bind_addr);
        }
        this.port = port;
        this.config = config;
    }

    public void start() throws Exception {
        this.cache = new TreeCache();
        PropertyConfigurator cfg = new PropertyConfigurator();
        cfg.configure((Object)this.cache, this.config);
        this.cache.createService();
        this.cache.startService();
        this.srv_sock = new ServerSocket(this.port, 10, this.bind_addr);
        System.out.println("TcpCacheServer listening on : " + this.srv_sock.getInetAddress() + ":" + this.srv_sock.getLocalPort());
        while (true) {
            Socket client_sock = this.srv_sock.accept();
            Connection conn = new Connection(client_sock, this.cache);
            conn.start();
        }
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        int port = 2099;
        String config = "cache-service.xml";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-config")) {
                config = args[++i];
                continue;
            }
            TcpCacheServer.help();
            return;
        }
        TcpCacheServer server = new TcpCacheServer(bind_addr, port, config);
        server.start();
    }

    private static void help() {
        System.out.println("TcpCacheServer [-bind_addr <address>] [-port <port>] [-help]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Connection
    implements Runnable {
        Socket sock = null;
        ObjectInputStream input = null;
        ObjectOutputStream output = null;
        TreeCache c;
        Thread t = null;

        public Connection(Socket sock, TreeCache cache) throws IOException {
            this.sock = sock;
            this.output = new ObjectOutputStream(sock.getOutputStream());
            this.input = new ObjectInputStream(sock.getInputStream());
            this.c = cache;
        }

        public void start() {
            this.t = new Thread((Runnable)this, "TcpCacheServer.Connection");
            this.t.setDaemon(true);
            this.t.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block21: while (true) {
                    int op = this.input.readInt();
                    switch (op) {
                        case 1: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Set children = this.c.getChildrenNames(fqn);
                            this.output.writeObject(children);
                            this.output.flush();
                            continue block21;
                        }
                        case 2: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.get(fqn, key);
                            this.output.writeObject(retval);
                            this.output.flush();
                            continue block21;
                        }
                        case 3: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            DataNode n = this.c.get(fqn);
                            Map map = n != null ? n.getData() : null;
                            this.output.writeObject(map);
                            this.output.flush();
                            continue block21;
                        }
                        case 4: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            boolean flag = this.c.exists(fqn);
                            this.output.writeBoolean(flag);
                            this.output.flush();
                            continue block21;
                        }
                        case 5: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object val = this.input.readObject();
                            Object retval = this.c.put(fqn, key, val);
                            this.output.writeObject(retval);
                            this.output.flush();
                            continue block21;
                        }
                        case 6: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Map map = (Map)this.input.readObject();
                            this.c.put(fqn, map);
                            continue block21;
                        }
                        case 7: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.remove(fqn, key);
                            this.output.writeObject(retval);
                            this.output.flush();
                            continue block21;
                        }
                        case 8: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.remove(fqn);
                            continue block21;
                        }
                        case 9: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.removeData(fqn);
                            continue block21;
                        }
                        case 10: {
                            byte[] state = this.c.getCacheLoader() != null ? this.c.getCacheLoader().loadEntireState() : null;
                            this.output.writeObject(state);
                            this.output.flush();
                            continue block21;
                        }
                        case 11: {
                            byte[] state = (byte[])this.input.readObject();
                            if (this.c.getCacheLoader() == null) continue block21;
                            this.c.getCacheLoader().storeEntireState(state);
                            continue block21;
                        }
                    }
                    log.error((Object)("Operation " + op + " unknown"));
                }
            }
            catch (Exception e) {
                log.warn((Object)"failed reading data, thread will terminate", (Throwable)e);
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    if (this.sock == null) return;
                    this.sock.close();
                    return;
                }
                catch (Throwable th) {
                    return;
                }
            }
        }
    }
}

