/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.rmi.Naming;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.loader.rmi.RemoteTreeCache;

public class RmiDelegatingCacheLoader
extends DelegatingCacheLoader {
    private String host;
    private String port;
    private String bindName;
    private TreeCache cache;
    private RemoteTreeCache remoteCache;
    private boolean programmaticInit;

    public RmiDelegatingCacheLoader() {
    }

    public RmiDelegatingCacheLoader(TreeCache cache, String host, int port, String bindName) {
        this.cache = cache;
        this.host = host;
        this.port = String.valueOf(port);
        this.bindName = bindName;
        this.tryToInitRemoteCache();
        this.programmaticInit = true;
    }

    public void setConfig(Properties props) {
        this.host = props.getProperty("host");
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = props.getProperty("port");
        if (this.port == null || this.port.length() == 0) {
            this.port = "1098";
        }
        this.port = props.getProperty("bindName");
        this.tryToInitRemoteCache();
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
        this.tryToInitRemoteCache();
    }

    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        return this.remoteCache != null ? this.remoteCache.getChildrenNames(fqn) : null;
    }

    protected Object delegateGet(Fqn name, Object key) throws Exception {
        return this.remoteCache != null ? this.remoteCache.get(name, key) : null;
    }

    protected Map delegateGet(Fqn name) throws Exception {
        DataNode n;
        DataNode dataNode = n = this.remoteCache != null ? this.remoteCache.get(name) : null;
        if (n == null) {
            return null;
        }
        Map m = n.getData();
        if (m != null && m.size() > 0) {
            return m;
        }
        return null;
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        return this.remoteCache != null ? this.remoteCache.exists(name) : false;
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.remoteCache != null ? this.remoteCache.put(name, key, value) : null;
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.put(name, attributes);
        }
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.remoteCache != null ? this.remoteCache.remove(name, key) : null;
    }

    protected void delegateRemove(Fqn name) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.remove(name);
        }
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.removeData(name);
        }
    }

    public byte[] delegateLoadEntireState() throws Exception {
        return this.remoteCache != null ? this.remoteCache.getState() : null;
    }

    public void delegateStoreEntireState(byte[] state) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.setState(state);
        }
    }

    private void tryToInitRemoteCache() {
        if (this.host == null || this.port == null || this.cache == null) {
            return;
        }
        if (this.bindName == null) {
            this.bindName = this.cache.getClusterName();
        }
        if (!this.programmaticInit && this.cache.isCoordinator()) {
            this.remoteCache = null;
            return;
        }
        String name = "//" + this.host + ":" + this.port + "/" + this.bindName;
        try {
            this.remoteCache = (RemoteTreeCache)Naming.lookup(name);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to lookup remote cache at '" + name + "'."), t);
        }
    }
}

