/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;

public class AsyncCacheLoader
implements CacheLoader {
    private CacheLoader delegateTo;
    private AsyncProcessorQueue taskQueue;

    public AsyncCacheLoader() {
    }

    public AsyncCacheLoader(CacheLoader cacheLoader) {
        this.delegateTo = cacheLoader;
    }

    public void setConfig(Properties url) {
        this.delegateTo.setConfig(url);
    }

    public void setCache(TreeCache c) {
        this.delegateTo.setCache(c);
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        return this.delegateTo.getChildrenNames(fqn);
    }

    public Object get(Fqn name, Object key) throws Exception {
        return this.delegateTo.get(name, key);
    }

    public Map get(Fqn name) throws Exception {
        return this.delegateTo.get(name);
    }

    public boolean exists(Fqn name) throws Exception {
        return this.delegateTo.exists(name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        final Fqn myName = name;
        final Object myKey = key;
        final Object myValue = value;
        Object oldValue = this.delegateTo.get(name, key);
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.put(myName, myKey, myValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
        return oldValue;
    }

    public void put(Fqn name, Map attributes) throws Exception {
        final Fqn myName = name;
        final Map myAttributes = attributes;
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.put(myName, myAttributes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
    }

    public void put(List modifications) throws Exception {
        final List myModifications = modifications;
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.put(myModifications);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
    }

    public Object remove(Fqn name, Object key) throws Exception {
        final Fqn myName = name;
        final Object myKey = key;
        Object value = this.delegateTo.get(name, key);
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.remove(myName, myKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
        return value;
    }

    public void remove(Fqn name) throws Exception {
        final Fqn myName = name;
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.remove(myName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
    }

    public void removeData(Fqn name) throws Exception {
        final Fqn myName = name;
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.removeData(myName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        this.delegateTo.prepare(tx, modifications, one_phase);
    }

    public void commit(Object tx) throws Exception {
        this.delegateTo.commit(tx);
    }

    public void rollback(Object tx) {
        this.delegateTo.rollback(tx);
    }

    public byte[] loadEntireState() throws Exception {
        return this.delegateTo.loadEntireState();
    }

    public void storeEntireState(byte[] state) throws Exception {
        final byte[] myState = state;
        Runnable async = new Runnable(){

            public void run() {
                try {
                    AsyncCacheLoader.this.delegateTo.storeEntireState(myState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.taskQueue.addTask(async);
    }

    public void create() throws Exception {
        this.delegateTo.create();
    }

    public void start() throws Exception {
        this.taskQueue = new AsyncProcessorQueue();
        this.taskQueue.start();
        this.delegateTo.start();
    }

    public void stop() {
        this.delegateTo.stop();
        this.taskQueue.stop();
        this.taskQueue = null;
    }

    public void destroy() {
        this.delegateTo.destroy();
    }

    private class AsyncProcessorQueue
    implements Runnable {
        private Thread t;
        private LinkedQueue queue = new LinkedQueue();
        private boolean running = true;

        private AsyncProcessorQueue() {
        }

        public void start() {
            this.running = true;
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "AsyncProcessorQueue thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            if (this.t != null) {
                this.running = false;
                this.t.interrupt();
            }
        }

        public void addTask(Runnable task) {
            try {
                this.queue.put((Object)task);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (this.running) {
                try {
                    Runnable task = (Runnable)this.queue.take();
                    if (task == null) continue;
                    task.run();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

