/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class OptimisticTxInterceptor
extends OptimisticInterceptor {
    private Map transactions = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$jboss$cache$GlobalTransaction;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodCall m) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invoke() called for method [" + m.getMethod().getName() + "] on target cache object " + this.cache));
            this.log.debug((Object)("local address is " + this.cache.getLocalAddress()));
        }
        GlobalTransaction gtx = null;
        Method meth = m.getMethod();
        Object result = null;
        try {
            Object[] args;
            if (meth.equals(TreeCache.optimisticPrepareMethod)) {
                Object[] args2 = m.getArgs();
                gtx = (GlobalTransaction)args2[0];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got gtx " + gtx));
                }
                if (gtx == null) throw new CacheException("optimisticPrepare cannot be called directly for local method");
                if (gtx.getAddress() == null) throw new CacheException("optimisticPrepare cannot be called directly for local method");
                if (gtx.getAddress().equals(this.cache.getLocalAddress())) throw new CacheException("optimisticPrepare cannot be called directly for local method");
                gtx.setRemote(true);
                return this.handleRemotePrepare(m);
            }
            if (!meth.equals(TreeCache.commitMethod)) {
                if (!meth.equals(TreeCache.rollbackMethod)) return this.handleLocalTx(m);
            }
            if ((gtx = (GlobalTransaction)(args = m.getArgs())[0]) == null) throw new CacheException(m + " cannot be called directly for local transaction");
            if (gtx.getAddress() == null) throw new CacheException(m + " cannot be called directly for local transaction");
            if (gtx.getAddress().equals(this.cache.getLocalAddress())) throw new CacheException(m + " cannot be called directly for local transaction");
            gtx.setRemote(true);
            return this.handleRemoteCommitRollback(m);
        }
        catch (Exception e) {
            this.log.info((Object)"There was a problem handling this request", (Throwable)e);
            throw e;
        }
    }

    private GlobalTransaction registerTransaction(Transaction tx) throws Exception {
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
        SynchronizationHandler myHandler = new SynchronizationHandler(gtx, tx, this.cache);
        return this.registerHandler(tx, gtx, myHandler);
    }

    private GlobalTransaction registerRemoteTransaction(GlobalTransaction gtx, Transaction tx) throws Exception {
        RemoteSynchronizationHandler myHandler = new RemoteSynchronizationHandler(gtx, tx, this.cache);
        return this.registerHandler(tx, gtx, myHandler);
    }

    private GlobalTransaction registerHandler(Transaction tx, GlobalTransaction gtx, SynchronizationHandler handler) throws Exception {
        if (!this.transactions.containsKey(tx)) {
            this.log.debug((Object)("registering handler for TX completion: SynchronizationHandler(" + handler + ")"));
            if (gtx == null) {
                throw new Exception("failed to get global transaction " + gtx);
            }
            OrderedSynchronizationHandler orderedHandler = OrderedSynchronizationHandler.getInstance(tx);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("registering for TX completion: SynchronizationHandler(" + handler + ")"));
            }
            orderedHandler.registerAtHead(handler);
            this.transactions.put(tx, tx);
            return gtx;
        }
        this.log.debug((Object)("already registered transaction " + tx));
        return gtx;
    }

    private Object handleLocalTx(MethodCall m) throws Throwable {
        Transaction tx = null;
        Object result = null;
        if (this.txManager != null && (tx = this.txManager.getTransaction()) == null) {
            try {
                this.log.debug((Object)(" creating transaction for thread " + Thread.currentThread()));
                this.txManager.begin();
                this.log.debug((Object)(" created transaction for thread " + Thread.currentThread()));
                tx = this.txManager.getTransaction();
                GlobalTransaction gtx = this.registerTransaction(tx);
                m = this.replaceGtx(m, gtx);
                result = super.invoke(m);
                this.log.debug((Object)(" commiting transaction for thread " + Thread.currentThread()));
                this.txManager.commit();
            }
            catch (Throwable t) {
                this.log.warn((Object)" Rolling back exception encountered ", t);
                try {
                    this.txManager.rollback();
                }
                catch (Throwable th) {
                    this.log.warn((Object)" Roll back failed encountered ", th);
                }
            }
            return result;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" local transaction exists - registering global tx if not present for " + Thread.currentThread()));
        }
        GlobalTransaction gtx = this.registerTransaction(tx);
        m = this.replaceGtx(m, gtx);
        result = super.invoke(m);
        return result;
    }

    private Object handleLocalPrepare(MethodCall m) throws Throwable {
        Object[] args = m.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        Transaction ltx = null;
        Object result = null;
        ltx = this.txTable.getLocalTransaction(gtx);
        if (this.txManager.getTransaction() == null || ltx == null || !ltx.equals(this.txManager.getTransaction())) {
            this.log.warn((Object)(" local transaction does not exist or does not match expected transaction  " + gtx));
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction  " + gtx);
        }
        this.log.debug((Object)(" running local prepare for " + gtx));
        result = super.invoke(m);
        this.log.debug((Object)(" finished local prepare for " + gtx));
        return result;
    }

    private MethodCall replaceGtx(MethodCall m, GlobalTransaction gtx) {
        Class<?>[] argClasses = m.getMethod().getParameterTypes();
        Object[] args = m.getArgs();
        for (int i = 0; i < argClasses.length; ++i) {
            if (!argClasses[i].equals(class$org$jboss$cache$GlobalTransaction == null ? OptimisticTxInterceptor.class$("org.jboss.cache.GlobalTransaction") : class$org$jboss$cache$GlobalTransaction)) continue;
            if (gtx.equals(args[i])) break;
            args[i] = gtx;
            m.setArgs(args);
            break;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleRemotePrepare(MethodCall m) throws Throwable {
        Object[] args = m.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        Transaction curr_tx = null;
        Transaction ltx = null;
        Object retval = null;
        this.log.debug((Object)(" Handling remote prepare " + gtx));
        ltx = this.txTable.getLocalTransaction(gtx);
        if (this.txManager.getTransaction() != null) {
            this.log.debug((Object)(" suspending current transaction " + gtx));
            curr_tx = this.txManager.suspend();
        }
        try {
            if (ltx == null) {
                ltx = this.createNewLocalTransaction(gtx);
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): started new local TX as result of remote PREPARE: local TX=" + ltx + ", global TX=" + gtx));
            } else if (!this.isValid(ltx)) {
                throw new CacheException("transaction " + ltx + " not in correct state to be prepared");
            }
            this.txManager.resume(ltx);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" resuming existing transaction " + ltx + ", global TX=" + gtx));
            }
            if (this.txTable.get(gtx) == null) {
                OptimisticTransactionEntry entry = new OptimisticTransactionEntry();
                entry.setTransaction(ltx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("PUTTING optimistic tx entry " + entry.getClass()));
                }
                this.txTable.put(gtx, entry);
            }
            this.registerRemoteTransaction(gtx, ltx);
            retval = super.invoke(m);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.txManager.suspend();
            if (curr_tx != null) {
                this.txManager.resume(curr_tx);
            }
            this.log.debug((Object)(" finished remote prepare " + gtx));
            throw throwable;
        }
        this.txManager.suspend();
        if (curr_tx != null) {
            this.txManager.resume(curr_tx);
        }
        this.log.debug((Object)(" finished remote prepare " + gtx));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object handleRemoteCommitRollback(MethodCall m) throws Throwable {
        Object[] args = m.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        Transaction ltx = null;
        Method meth = m.getMethod();
        if (!gtx.isRemote()) {
            throw new CacheException("Commit/Rollback must be remote - not handling local gtx");
        }
        ltx = this.txTable.getLocalTransaction(gtx);
        if (ltx == null) {
            throw new IllegalStateException(" found no local TX for global TX " + gtx);
        }
        this.log.debug((Object)(" received " + meth.getName() + ": local TX=" + ltx + ", global TX=" + gtx));
        Transaction curr_tx = null;
        try {
            if (!ltx.equals(this.txManager.getTransaction())) {
                curr_tx = this.txManager.suspend();
                this.txManager.resume(ltx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" executing " + meth.getName() + "() with local TX " + ltx + " under global tx " + gtx));
            }
            if (meth.equals(TreeCache.commitMethod)) {
                ltx.commit();
            } else {
                ltx.rollback();
            }
            Object var8_7 = null;
            if (curr_tx == null) return null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (curr_tx == null) throw throwable;
            this.txManager.suspend();
            this.txManager.resume(curr_tx);
            throw throwable;
        }
        this.txManager.suspend();
        this.txManager.resume(curr_tx);
        return null;
    }

    private Object handleCommitRollback(MethodCall m) throws Throwable {
        Object[] args = m.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        Transaction ltx = null;
        Method meth = m.getMethod();
        Object result = null;
        ltx = this.txTable.getLocalTransaction(gtx);
        Transaction tempTx = this.txManager.getTransaction();
        if (ltx != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" received " + meth.getName() + ": local TX=" + ltx + ", global TX=" + gtx));
            }
        } else {
            throw new IllegalStateException(" found no local TX for global TX " + gtx);
        }
        if (!ltx.equals(tempTx)) {
            throw new IllegalStateException(" local transaction " + ltx + " transaction does not match running tx" + tempTx);
        }
        result = super.invoke(m);
        this.log.debug((Object)(" finished commit method for " + gtx));
        return result;
    }

    private Transaction createNewLocalTransaction(GlobalTransaction gtx) throws Exception {
        if (this.txManager == null) {
            throw new Exception(" failed to create local transaction: TransactionManager is null");
        }
        this.txManager.begin();
        Transaction local_tx = this.txManager.getTransaction();
        this.txTable.put(local_tx, gtx);
        return local_tx;
    }

    protected void runCommitPhase(GlobalTransaction gtx) {
        try {
            MethodCall commit_method = new MethodCall(TreeCache.commitMethod, new Object[]{gtx});
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running commit for " + gtx));
            }
            this.handleCommitRollback(commit_method);
        }
        catch (Throwable e) {
            this.log.error((Object)" commit failed", e);
        }
    }

    protected void runRollbackPhase(GlobalTransaction gtx) {
        try {
            MethodCall rollback_method = new MethodCall(TreeCache.rollbackMethod, new Object[]{gtx});
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running rollback for " + gtx));
            }
            this.handleCommitRollback(rollback_method);
        }
        catch (Throwable e) {
            this.log.warn((Object)" rollback had a problem ", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RemoteSynchronizationHandler
    extends SynchronizationHandler {
        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            super(gtx, tx, cache);
        }

        public void beforeCompletion() {
            OptimisticTxInterceptor.this.log.debug((Object)"remote beforeCompletion called - no before completion step");
        }

        public void afterCompletion(int status) {
            OptimisticTxInterceptor.this.log.debug((Object)"calling afterCompletion in remote handler");
            super.afterCompletion(status);
            OptimisticTxInterceptor.this.log.debug((Object)"finished afterCompletion in remote handler");
        }

        public String toString() {
            return "OptimisticReplicationInterceptor:RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }

    class SynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        TreeCache cache = null;
        List modifications = null;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
        }

        public void beforeCompletion() {
            OptimisticTransactionEntry entry = (OptimisticTransactionEntry)OptimisticTxInterceptor.this.txTable.get(this.gtx);
            if (entry == null) {
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = entry.getModifications();
            if (this.modifications.size() == 0) {
                return;
            }
            try {
                switch (this.tx.getStatus()) {
                    case 0: 
                    case 7: {
                        Object result = null;
                        try {
                            MethodCall prepare_method = new MethodCall(TreeCache.optimisticPrepareMethod, new Object[]{this.gtx, this.modifications, null, (Address)this.cache.getLocalAddress(), Boolean.FALSE});
                            result = OptimisticTxInterceptor.this.handleLocalPrepare(prepare_method);
                            if (result instanceof Throwable) {
                                this.tx.setRollbackOnly();
                                throw (Throwable)result;
                            }
                            break;
                        }
                        catch (Throwable t) {
                            OptimisticTxInterceptor.this.log.warn((Object)"runPreparePhase() failed. Transaction is marked as rolled back", t);
                            this.tx.setRollbackOnly();
                            throw t;
                        }
                    }
                    default: {
                        throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unbale to start transaction");
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new NestedRuntimeException("setting tx rollback failed ", (Throwable)se);
                }
                throw new NestedRuntimeException("", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                OptimisticTxInterceptor.this.log.debug((Object)("calling aftercompletion for " + this.gtx));
                OptimisticTxInterceptor.this.transactions.remove(this.tx);
                switch (status) {
                    case 3: {
                        OptimisticTxInterceptor.this.log.debug((Object)" running commit phase ");
                        OptimisticTxInterceptor.this.runCommitPhase(this.gtx);
                        OptimisticTxInterceptor.this.log.debug((Object)" finished commit phase ");
                        break;
                    }
                    case 1: 
                    case 4: {
                        if (OptimisticTxInterceptor.this.log.isDebugEnabled()) {
                            OptimisticTxInterceptor.this.log.debug((Object)" running rollback phase");
                        }
                        OptimisticTxInterceptor.this.runRollbackPhase(this.gtx);
                        OptimisticTxInterceptor.this.log.debug((Object)" finished rollback phase");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status);
                    }
                }
                Object var3_2 = null;
                OptimisticTxInterceptor.this.txTable.remove(this.gtx);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                OptimisticTxInterceptor.this.txTable.remove(this.gtx);
                OptimisticTxInterceptor.this.txTable.remove(this.tx);
                throw throwable;
            }
            OptimisticTxInterceptor.this.txTable.remove(this.tx);
        }

        public String toString() {
            return "OptimisticReplicationInterceptor:SynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }
}

