/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionPolicy;

public class Region {
    public static final long WAIT_TIME = 10000L;
    private int maxNodes_ = 0;
    private long timeToLiveSeconds_ = 0L;
    private int maxAgeSeconds_ = 0;
    private String fqn_;
    private EvictionAlgorithm algorithm_;
    private EvictionPolicy policy_;
    protected BoundedBuffer nodeEventQueue_;
    protected Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$Region == null ? (class$org$jboss$cache$eviction$Region = Region.class$("org.jboss.cache.eviction.Region")) : class$org$jboss$cache$eviction$Region));
    protected short checkCapacityCount = 0;
    private static final int CAPACITY_WARN_THRESHOLD = 195900;
    static /* synthetic */ Class class$org$jboss$cache$eviction$Region;

    Region() {
        this.createQueue();
    }

    void createQueue() {
        this.nodeEventQueue_ = new BoundedBuffer(200000);
    }

    Region(String fqn, EvictionPolicy policy, EvictionAlgorithm algorithm) {
        this.fqn_ = fqn;
        this.policy_ = policy;
        this.algorithm_ = algorithm;
        this.createQueue();
    }

    public int getMaxNodes() {
        return this.maxNodes_;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes_ = maxNodes;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds_;
    }

    public void setTimeToLiveSeconds(long secs) {
        this.timeToLiveSeconds_ = secs;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds_;
    }

    public void setMaxAgeSeconds(int maxAge) {
        this.maxAgeSeconds_ = maxAge;
    }

    public EvictionAlgorithm getEvictionAlgorithm() {
        return this.algorithm_;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.policy_;
    }

    public String getFqn() {
        return this.fqn_;
    }

    public void setAddedNode(Fqn fqn) {
        this.putNodeEvent(fqn, EvictedEventNode.ADD_EVENT);
    }

    public void setRemovedNode(Fqn fqn) {
        this.putNodeEvent(fqn, EvictedEventNode.REMOVE_EVENT);
    }

    public void setVisitedNode(Fqn fqn) {
        this.putNodeEvent(fqn, EvictedEventNode.VISIT_EVENT);
    }

    protected void putNodeEvent(Fqn fqn, Integer event) {
        try {
            this.checkCapacityCount = (short)(this.checkCapacityCount + 1);
            if (this.checkCapacityCount > 100) {
                this.checkCapacityCount = 0;
                if (this.nodeEventQueue_.size() > 195900) {
                    this.log_.warn((Object)"putNodeEvent(): eviction node event queue size is at 98% threshold value of capacity: 200000 You will need to reduce the wakeUpIntervalSeconds parameter.");
                }
            }
            this.nodeEventQueue_.put((Object)new EvictedEventNode(fqn, event));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public EvictedEventNode takeLastEventNode() {
        try {
            return (EvictedEventNode)this.nodeEventQueue_.poll(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int nodeEventQueueSize() {
        return this.nodeEventQueue_.size();
    }

    public void resetEvictionQueues() {
        BoundedBuffer q1 = this.nodeEventQueue_;
        this.log_.info((Object)("reseteEvictionQueues(): node queue size: " + q1.size() + " region name: " + this.fqn_));
        this.createQueue();
        for (int i = 0; i < q1.size(); ++i) {
            try {
                q1.take();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Regions--- fqn: ").append(this.getFqn()).append(" maxNodes ").append(this.getMaxNodes());
        buf.append(" TimeToIdleSeconds ").append(this.getTimeToLiveSeconds());
        buf.append(" maxAgeSeconds ").append(this.getMaxAgeSeconds());
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

