/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.lock.TimeoutException;

public class LRUAlgorithm
implements EvictionAlgorithm {
    protected Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$LRUAlgorithm == null ? (class$org$jboss$cache$eviction$LRUAlgorithm = LRUAlgorithm.class$("org.jboss.cache.eviction.LRUAlgorithm")) : class$org$jboss$cache$eviction$LRUAlgorithm));
    protected Map nodeMap_ = new HashMap();
    protected NodeEntry head_ = null;
    protected NodeEntry tail_ = null;
    protected Region region_;
    private static final int CAPACITY = 50000;
    protected BoundedBuffer recycleQueue_ = new BoundedBuffer(50000);
    static /* synthetic */ Class class$org$jboss$cache$eviction$LRUAlgorithm;

    public void process(Region region) throws EvictionException {
        this.region_ = region;
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)new StringBuffer("processing the node events in region: ").append(this.region_).append(" current eviction queue size is ").append(this.evictionQueueSize()));
        }
        this.processQueues();
        this.prune();
    }

    public void resetEvictionQueue(Region region) {
    }

    private void processQueues() throws EvictionException {
        EvictedEventNode node;
        boolean loop = true;
        int count = 0;
        while (loop && (node = this.region_.takeLastEventNode()) != null) {
            Fqn fqn = node.getFqn();
            Integer event = node.getEvent();
            ++count;
            if (event.equals(EvictedEventNode.ADD_EVENT)) {
                this.processAddedNodes(fqn);
                continue;
            }
            if (event.equals(EvictedEventNode.REMOVE_EVENT)) {
                this.processRemovedNodes(fqn);
                continue;
            }
            if (event.equals(EvictedEventNode.VISIT_EVENT)) {
                this.processVisitedNodes(fqn);
                continue;
            }
            throw new RuntimeException("LRUAlgorithm.processQueues(): Illegal event type " + event);
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("processed " + count + " node events"));
        }
    }

    private void processAddedNodes(Fqn fqn) throws EvictionException {
        long stamp = System.currentTimeMillis();
        NodeEntry ne = new NodeEntry(fqn);
        ne.setModifiedTimeStamp(stamp);
        this.add(ne);
    }

    private void processRemovedNodes(Fqn fqn) throws EvictionException {
        this.removeFromQueue(fqn);
    }

    private void processVisitedNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne = (NodeEntry)this.nodeMap_.get(fqn);
        if (ne == null) {
            ne = new NodeEntry(fqn);
            this.add(ne);
        }
        long stamp = System.currentTimeMillis();
        ne.setModifiedTimeStamp(stamp);
        this.demote(fqn);
    }

    private void add(NodeEntry ne) throws EvictionException {
        if (this.nodeMap_.containsKey(ne.getFqn())) {
            this.demote(ne.getFqn());
            return;
        }
        if (this.head_ == null && this.tail_ == null) {
            this.head_ = ne;
            this.tail_ = ne;
            this.nodeMap_.put(ne.getFqn(), ne);
            return;
        }
        this.tail_.setNext(ne);
        ne.setPrevious(this.tail_);
        this.tail_ = ne;
        this.nodeMap_.put(ne.getFqn(), ne);
    }

    protected void demote(Fqn fqn) throws EvictionException {
        NodeEntry ne = (NodeEntry)this.nodeMap_.get(fqn);
        if (ne == null) {
            throw new EvictionException("LRUAlgorithm.demote(): internal error. Can't find fqn in nodeMap: " + fqn);
        }
        if (this.head_ == ne && this.tail_ == ne) {
            return;
        }
        if (this.tail_ == ne) {
            return;
        }
        if (this.head_ == ne) {
            this.head_ = this.head_.getNext();
            this.head_.setPrevious(null);
        } else {
            ne.getPrevious().setNext(ne.getNext());
            ne.getNext().setPrevious(ne.getPrevious());
        }
        this.tail_.setNext(ne);
        ne.setPrevious(this.tail_);
        this.tail_ = ne;
        ne.setNext(null);
    }

    private boolean evictCacheNode(Fqn fqn) {
        EvictionPolicy policy = this.region_.getEvictionPolicy();
        try {
            policy.evict(fqn);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                this.log_.warn((Object)"eviction timed out. Will retry later.");
                return false;
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void removeFromQueue(Fqn fqn) throws EvictionException {
        NodeEntry ne = (NodeEntry)this.nodeMap_.remove(fqn);
        if (ne == null) {
            this.log_.warn((Object)("DataNode not found with this fqn: " + fqn + " Could have been evicted earlier already"));
            throw new EvictionException("internal error. Can't find fqn in nodeMap. fqn: " + fqn);
        }
        if (this.head_ == ne && this.tail_ == ne) {
            this.tail_ = null;
            this.head_ = null;
            return;
        }
        if (this.head_ == ne) {
            this.head_ = this.head_.getNext();
            this.head_.setPrevious(null);
            ne.setNext(null);
            return;
        }
        if (this.tail_ == ne) {
            this.tail_ = this.tail_.getPrevious();
            this.tail_.setNext(null);
            ne.setPrevious(null);
            return;
        }
        ne.getPrevious().setNext(ne.getNext());
        ne.getNext().setPrevious(ne.getPrevious());
    }

    protected boolean shouldEvictNode(NodeEntry entry, Region region, long currentTime) {
        if (region.getTimeToLiveSeconds() == 0L && region.getMaxAgeSeconds() == 0) {
            return false;
        }
        if (region.getTimeToLiveSeconds() != 0L) {
            long idleTime = currentTime - entry.getModifiedTimeStamp();
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Node " + entry.getFqn().toString() + " has been idle for " + idleTime + "ms"));
            }
            if (idleTime >= region.getTimeToLiveSeconds() * 1000L) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("Node " + entry.getFqn().toString() + " should be evicted because of idle time"));
                }
                return true;
            }
        }
        if (region.getMaxAgeSeconds() != 0) {
            long objectLifeTime = currentTime - entry.getCreationTimeStamp();
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Node " + entry.getFqn().toString() + " has been alive for " + objectLifeTime + "ms"));
            }
            if (objectLifeTime >= (long)(region.getMaxAgeSeconds() * 1000)) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("Node " + entry.getFqn().toString() + " should be evicted because of max age"));
                }
                return true;
            }
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Node " + entry.getFqn().toString() + " should not be evicted"));
        }
        return false;
    }

    protected void prune() throws EvictionException {
        boolean loop = true;
        while (loop) {
            NodeEntry ne = null;
            try {
                ne = (NodeEntry)this.recycleQueue_.poll(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            if (ne == null) break;
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("emptying recycle bin. Evict node " + ne.getFqn()));
            }
            if (this.evictCacheNode(ne.getFqn())) continue;
            try {
                this.recycleQueue_.put((Object)ne);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            break;
        }
        while (this.region_.getMaxNodes() != 0 && this.region_.getMaxNodes() < this.nodeMap_.size()) {
            Fqn fqn = this.head_.getFqn();
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("over-capacity. Evict node " + fqn));
            }
            this.evict(fqn);
            if (this.head_ != null) continue;
            throw new EvictionException("internal error. head is null");
        }
        if (this.head_ == null) {
            return;
        }
        if (this.region_.getTimeToLiveSeconds() == 0L && this.region_.getMaxAgeSeconds() == 0) {
            return;
        }
        NodeEntry cursor = this.head_;
        long currentTime = System.currentTimeMillis();
        while (cursor != null) {
            Fqn fqn = cursor.getFqn();
            NodeEntry entry = cursor;
            cursor = cursor.getNext();
            if (!this.shouldEvictNode(entry, this.region_, currentTime)) continue;
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("over-aged. Evict node " + fqn));
            }
            this.evict(fqn);
        }
    }

    protected void evict(Fqn fqn) throws EvictionException {
        NodeEntry ne = (NodeEntry)this.nodeMap_.get(fqn);
        try {
            this.removeFromQueue(fqn);
        }
        catch (EvictionException e) {
            e.printStackTrace();
            return;
        }
        if (!this.evictCacheNode(fqn)) {
            try {
                this.recycleQueue_.put((Object)ne);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int evictionQueueSize() {
        return this.nodeMap_.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

