/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.NodeEntry;

public class AopLRUAlgorithm
extends LRUAlgorithm {
    static final long TOLERANCE = 10L;

    protected Set getAssociatedEvictNode(Fqn fqn) {
        return this.getChildrenNames(fqn);
    }

    protected boolean preAddedNodes(Fqn fqn) {
        return true;
    }

    private boolean isAopNode(Fqn fqn) {
        EvictionPolicy policy = this.region_.getEvictionPolicy();
        return policy.getCacheData(fqn, AOPInstance.KEY) == null;
    }

    private Set getChildrenNames(Fqn fqn) {
        EvictionPolicy policy = this.region_.getEvictionPolicy();
        return policy.getChildrenNames(fqn);
    }

    protected boolean preVisitedNodes(Fqn fqn, long stamp) {
        if (this.isAopNode(fqn)) {
            Set set = this.getChildrenNames(fqn);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                Fqn childFqn = new Fqn(child);
                if (!this.preVisitedNodes(childFqn, stamp)) {
                    return false;
                }
                try {
                    this.updateChildTimeStamp(childFqn, stamp);
                }
                catch (EvictionException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private void updateChildTimeStamp(Fqn childFqn, long stamp) throws EvictionException {
        NodeEntry ne = (NodeEntry)this.nodeMap_.get(childFqn);
        ne.setModifiedTimeStamp(stamp);
        this.demote(childFqn);
    }
}

