/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AopOperationNotSupportedException;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.util.NestedRuntimeException;

public class CachedSetImpl
implements Set {
    protected TreeCacheAop cache_;
    protected AbstractCollectionInterceptor interceptor_;

    public CachedSetImpl(TreeCacheAop cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected DataNode getNode() {
        try {
            return this.cache_.get(this.getFqn());
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    public int size() {
        DataNode node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public void clear() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        int ind = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            objs[ind++] = i.next();
        }
        return objs;
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int current = -1;
            protected int size_ = CachedSetImpl.this.size();

            public boolean hasNext() {
                if (CachedSetImpl.this.size() == 0) {
                    return false;
                }
                if (this.current > CachedSetImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + CachedSetImpl.this.size());
                }
                return this.current < CachedSetImpl.this.size() - 1;
            }

            public Object next() {
                if (this.current == CachedSetImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + CachedSetImpl.this.size());
                }
                try {
                    return CachedSetImpl.this.cache_.getObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), Integer.toString(++this.current)));
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }

            public void remove() {
                try {
                    int size = CachedSetImpl.this.size();
                    if (CachedSetImpl.this.size() == 0) {
                        return;
                    }
                    if (this.current == CachedSetImpl.this.size()) {
                        throw new IllegalStateException("CachedSetImpl.iterator.remove().  Cursor position " + this.current + " is greater than the size " + CachedSetImpl.this.size());
                    }
                    if (this.current < size - 1) {
                        Object last = CachedSetImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), Integer.toString(this.current)));
                        for (int i = this.current + 1; i < size; ++i) {
                            last = CachedSetImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), Integer.toString(i)));
                            CachedSetImpl.this.cache_.putObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), Integer.toString(i - 1)), last);
                        }
                    } else {
                        CachedSetImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), Integer.toString(this.current)));
                    }
                    --this.current;
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }
        };
    }

    public Object[] toArray(Object[] a) {
        throw new AopOperationNotSupportedException("CachedSetImpl: set.toArray() operation not supported");
    }

    public boolean add(Object o) {
        if (this.contains(o)) {
            return false;
        }
        try {
            this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(this.size())), o);
            return true;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public boolean contains(Object o) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object n = i.next();
            if ((o != null || n != null) && (o == null || !o.equals(n))) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object n = i.next();
            if ((o != null || n != null) && (o == null || !o.equals(n))) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedSetImpl: set.containsAll() operation not supported");
    }

    public boolean removeAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedSetImpl: set.retainAll() operation not supported");
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set list = (Set)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value != null) {
                if (this.contains(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[" + key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

