/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;

public class TreeNode
extends AbstractNode {
    private static final long serialVersionUID = 6274163944563898729L;
    final transient Object childrenMutex = new Object();
    transient boolean children_loaded = false;
    final transient ReentrantLock dataLock = new ReentrantLock();
    transient IdentityLock lock_ = null;
    static transient Log log = LogFactory.getLog((Class)(class$org$jboss$cache$TreeNode == null ? (class$org$jboss$cache$TreeNode = TreeNode.class$("org.jboss.cache.TreeNode")) : class$org$jboss$cache$TreeNode));
    transient TreeCache cache;
    static /* synthetic */ Class class$org$jboss$cache$TreeNode;

    public TreeNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode(Object child_name, Fqn fqn, TreeNode parent, Map data, TreeCache cache) {
        this.init(child_name, fqn, parent, cache);
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (data != null) {
                this.data().putAll(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode(Object child_name, Fqn fqn, TreeNode parent, Map data, boolean mapSafe, TreeCache cache) {
        this.init(child_name, fqn, parent, cache);
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (data != null) {
                if (mapSafe) {
                    this.data = data;
                } else {
                    this.data().putAll(data);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode(Object child_name, Fqn fqn, TreeNode parent, Object key, Object value, TreeCache cache) {
        this.init(child_name, fqn, parent, cache);
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            this.data().put(key, value);
        }
    }

    protected void init(Object child_name, Fqn fqn, TreeNode parent, TreeCache cache) {
        this.cache = cache;
        this.name = child_name;
        this.fqn = fqn;
        this.parent = parent;
        this.init();
    }

    protected void init() {
        this.lock_ = new IdentityLock(this.cache, this.fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map children() {
        Object object = this.childrenMutex;
        synchronized (object) {
            if (this.children == null) {
                this.children = new ConcurrentReaderHashMap();
            }
            return this.children;
        }
    }

    void setTreeCacheInstance(TreeCache cache) {
        this.cache = cache;
    }

    public void setRecursiveTreeCacheInstance(TreeCache cache) {
        this.cache = cache;
        if (this.children != null) {
            Iterator it = this.children.keySet().iterator();
            while (it.hasNext()) {
                DataNode nd = (DataNode)this.children.get(it.next());
                nd.setRecursiveTreeCacheInstance(cache);
            }
        }
    }

    public boolean getChildrenLoaded() {
        return this.children_loaded;
    }

    public void setChildrenLoaded(boolean flag) {
        this.children_loaded = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data == null ? null : this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data != null && this.data.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDataKeys() {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data != null ? this.data.keySet() : null;
        }
    }

    boolean isReadLocked() {
        return this.lock_ != null && this.lock_.isReadLocked();
    }

    boolean isWriteLocked() {
        return this.lock_ != null && this.lock_.isWriteLocked();
    }

    public boolean isLocked() {
        return this.isWriteLocked() || this.isReadLocked();
    }

    public IdentityLock getImmutableLock() {
        return this.lock_;
    }

    public IdentityLock getLock() {
        return this.lock_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getData() {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (this.data == null) {
                return null;
            }
            return new HashMap(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numAttributes() {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data != null ? this.data.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Map data, boolean erase) {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (erase && this.data != null) {
                this.data.clear();
            }
            if (data == null) {
                return;
            }
            this.data().putAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        DataNode child;
        if (child_name == null) {
            return null;
        }
        Object object = this.childrenMutex;
        synchronized (object) {
            child = (DataNode)this.children().get(child_name);
            if (child == null && createIfNotExists) {
                child = new TreeNode(child_name, new Fqn(this.fqn, child_name), this, null, this.cache);
                this.children.put(child_name, child);
                if (gtx != null) {
                    this.cache.addNode(gtx, child.getFqn());
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)new StringBuffer("created child: fqn=").append(this.getFqn()).append(", child_name=").append(child_name));
                }
                this.cache.notifyNodeCreated(child.getFqn());
            }
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createChild(Object child_name, Fqn fqn, Node parent) {
        DataNode child = null;
        if (child_name == null) {
            return null;
        }
        Object object = this.childrenMutex;
        synchronized (object) {
            child = (DataNode)this.children().get(child_name);
            if (child == null) {
                child = (DataNode)NodeFactory.getInstance().createNodeOfType(parent, child_name, fqn, parent, null, this.cache);
                this.children.put(child_name, child);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("created child: fqn=").append(fqn).append(", child_name=").append(child_name));
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createChild(Object child_name, Fqn fqn, Node parent, Object key, Object value) {
        DataNode child;
        if (child_name == null) {
            return null;
        }
        Object object = this.childrenMutex;
        synchronized (object) {
            child = (DataNode)this.children().get(child_name);
            if (child == null) {
                HashMap<Object, Object> childData = new HashMap<Object, Object>();
                childData.put(key, value);
                child = (DataNode)NodeFactory.getInstance().createNodeOfType(parent, child_name, fqn, parent, childData, this.cache);
                this.children.put(child_name, child);
            } else {
                child.put(key, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("createChild: fqn=").append(fqn).append(", child_name=").append(child_name));
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            return this.data != null ? this.data.remove(key) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (this.data != null) {
                this.data.clear();
                this.data = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDetails(StringBuffer sb, int indent) {
        HashMap tmp;
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            tmp = this.data != null ? new HashMap(this.data) : null;
        }
        this.printDetailsInMap(sb, indent, tmp);
    }

    public void printLockInfo(StringBuffer sb, int indent) {
        boolean locked = this.lock_ != null && this.lock_.isLocked();
        this.printIndent(sb, indent);
        sb.append("/").append(this.name);
        if (locked) {
            sb.append("\t(");
            this.lock_.toString(sb);
            sb.append(")");
        }
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((DataNode)it.next()).printLockInfo(sb, indent + 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append("\nname=" + this.name);
        }
        if (this.fqn != null) {
            sb.append("\nfqn=" + this.fqn);
        }
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            if (this.data != null) {
                sb.append("\ndata=" + this.data);
            }
        }
        if (this.lock_ != null) {
            sb.append("\n read locked=").append(this.isReadLocked());
            sb.append("\n write locked=").append(this.isWriteLocked());
        }
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DataNode n = (DataNode)NodeFactory.getInstance().createNodeOfType(this.parent, this.name, this.fqn != null ? (Fqn)this.fqn.clone() : null, this.parent != null ? (DataNode)this.parent.clone() : null, this.data, this.cache);
        n.setChildren(this.children == null ? null : (HashMap)((HashMap)this.children).clone());
        return n;
    }

    public boolean acquire(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        try {
            if (lock_type == 0) {
                return true;
            }
            if (lock_type == 1) {
                return this.acquireReadLock(caller, timeout);
            }
            return this.acquireWriteLock(caller, timeout);
        }
        catch (UpgradeException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("failure upgrading lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true)));
            }
            throw e;
        }
        catch (LockingException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("failure acquiring lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true)));
            }
            throw e;
        }
        catch (TimeoutException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("failure acquiring lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true)));
            }
            throw e;
        }
    }

    protected boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("acquiring RL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.lock_.acquireReadLock(caller, timeout);
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("acquired RL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    protected boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("acquiring WL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.lock_.acquireWriteLock(caller, timeout);
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("acquired WL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        HashSet<IdentityLock> retval = new HashSet<IdentityLock>();
        if (lock_type == 0) {
            return retval;
        }
        boolean acquired = this.acquire(caller, timeout, lock_type);
        if (acquired) {
            retval.add(this.getLock());
        }
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                retval.addAll(tmp.acquireAll(caller, timeout, lock_type));
            }
        }
        return retval;
    }

    public void release(Object caller) {
        this.lock_.release(caller);
    }

    public void releaseForce() {
        this.lock_.releaseForce();
    }

    public void releaseAll(Object owner) {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                tmp.releaseAll(owner);
            }
        }
        this.release(owner);
    }

    public void releaseAllForce() {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                tmp.releaseAllForce();
            }
        }
        this.releaseForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.fqn);
        out.writeObject(this.parent);
        out.writeObject(this.children);
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            out.writeObject(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readObject();
        this.fqn = (Fqn)in.readObject();
        this.parent = (DataNode)in.readObject();
        this.children = (Map)in.readObject();
        ReentrantLock reentrantLock = this.dataLock;
        synchronized (reentrantLock) {
            this.data = (Map)in.readObject();
        }
        this.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

