/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.BoundarySampler;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.InheritableServerClientAndLocalSpanState;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.local.LocalSpanCollector;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import zipkin.Endpoint;
import zipkin.collector.CollectorMetrics;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.brave.ApiTracerConfiguration;
import zipkin.storage.StorageComponent;

@Configuration
@ConditionalOnSelfTracing
@Import(value={ApiTracerConfiguration.class})
public class BraveConfiguration {
    @Bean
    @Scope
    Endpoint local(@Value(value="${server.port:9411}") int port) {
        Endpoint.Builder builder = Endpoint.builder().serviceName("zipkin-server").port(port == -1 ? 0 : port);
        try {
            byte[] address = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(i -> Collections.list(i.getInetAddresses()).stream()).filter(ip -> ip.isSiteLocalAddress()).findAny().get().getAddress();
            if (address.length == 4) {
                builder.ipv4(ByteBuffer.wrap(address).getInt());
            } else if (address.length == 16) {
                builder.ipv6(address);
            }
        }
        catch (Exception ignored) {
            builder.ipv4(2130706433);
        }
        return builder.build();
    }

    @Bean
    LocalSpanCollector spanCollector(@Lazy StorageComponent storage, @Value(value="${zipkin.self-tracing.flush-interval:1}") int flushInterval, final CollectorMetrics metrics) {
        LocalSpanCollector.Config config = LocalSpanCollector.Config.builder().flushInterval(flushInterval).build();
        return LocalSpanCollector.create((StorageComponent)storage, (LocalSpanCollector.Config)config, (SpanCollectorMetricsHandler)new SpanCollectorMetricsHandler(){
            CollectorMetrics local;
            {
                this.local = metrics.forTransport("local");
            }

            public void incrementAcceptedSpans(int i) {
                this.local.incrementSpans(i);
            }

            public void incrementDroppedSpans(int i) {
                this.local.incrementSpansDropped(i);
            }
        });
    }

    @Bean
    ServerClientAndLocalSpanState braveState(@Qualifier(value="local") Endpoint local) {
        com.twitter.zipkin.gen.Endpoint braveEndpoint = com.twitter.zipkin.gen.Endpoint.builder().ipv4(local.ipv4).ipv6(local.ipv6).port(local.port).serviceName(local.serviceName).build();
        return new InheritableServerClientAndLocalSpanState(braveEndpoint);
    }

    @Bean
    Brave brave(ServerClientAndLocalSpanState braveState, LocalSpanCollector spanCollector, @Value(value="${zipkin.self-tracing.sample-rate:1.0}") float rate) {
        return new Brave.Builder(braveState).traceSampler((double)rate < 0.01 ? BoundarySampler.create((float)rate) : Sampler.create((float)rate)).spanCollector((SpanCollector)spanCollector).build();
    }
}

