/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.okhttp;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.LocalTracer;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.http.BraveHttpHeaders;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.okhttp.OkHttpParser;
import com.twitter.zipkin.gen.Endpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

@Deprecated
public final class BraveTracingInterceptor
implements Interceptor {
    final LocalTracer localTracer;
    final ClientTracer clientTracer;
    final OkHttpParser parser;
    final String serverName;

    public static BraveTracingInterceptor create(Brave brave) {
        return BraveTracingInterceptor.builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    BraveTracingInterceptor(Builder builder) {
        this.localTracer = builder.brave.localTracer();
        this.clientTracer = builder.brave.clientTracer();
        this.parser = builder.parser;
        this.serverName = builder.serverName;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Connection connection = chain.connection();
        boolean applicationRequest = connection == null;
        Request request = chain.request();
        SpanId spanId = applicationRequest ? this.localTracer.startNewSpan("okhttp", this.parser.applicationSpanName(request)) : this.clientTracer.startNewSpan(this.parser.networkSpanName(request));
        if (spanId == null) {
            return applicationRequest ? chain.proceed(request) : chain.proceed(request.newBuilder().header(BraveHttpHeaders.Sampled.getName(), "0").build());
        }
        if (applicationRequest) {
            return this.traceApplicationRequest(chain, request);
        }
        Request tracedRequest = BraveTracingInterceptor.addTraceHeaders(request, spanId).build();
        return this.traceNetworkRequest(chain, tracedRequest);
    }

    static Request.Builder addTraceHeaders(Request request, SpanId spanId) {
        Request.Builder tracedRequest = request.newBuilder();
        tracedRequest.header(BraveHttpHeaders.TraceId.getName(), spanId.traceIdString());
        tracedRequest.header(BraveHttpHeaders.SpanId.getName(), IdConversion.convertToString((long)spanId.spanId));
        if (spanId.nullableParentId() != null) {
            tracedRequest.header(BraveHttpHeaders.ParentSpanId.getName(), IdConversion.convertToString((long)spanId.parentId));
        }
        tracedRequest.header(BraveHttpHeaders.Sampled.getName(), "1");
        return tracedRequest;
    }

    Response traceApplicationRequest(Interceptor.Chain chain, Request request) throws IOException {
        try {
            Response response = chain.proceed(request);
            return response;
        }
        catch (IOException | Error | RuntimeException e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            }
            this.localTracer.submitBinaryAnnotation("error", message);
            throw e;
        }
        finally {
            this.localTracer.finishSpan();
        }
    }

    Response traceNetworkRequest(Interceptor.Chain chain, Request request) throws IOException {
        this.appendToSpan(this.parser.networkRequestTags(request));
        try {
            this.clientTracer.setClientSent(this.serverAddress(chain.connection()));
            Response response = chain.proceed(request);
            this.appendToSpan(this.parser.networkResponseTags(response));
            Response response2 = response;
            return response2;
        }
        catch (IOException | Error | RuntimeException e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            }
            this.clientTracer.submitBinaryAnnotation("error", message);
            throw e;
        }
        finally {
            this.clientTracer.setClientReceived();
        }
    }

    void appendToSpan(List<KeyValueAnnotation> annotations) {
        int length = annotations.size();
        for (int i = 0; i < length; ++i) {
            KeyValueAnnotation tag = annotations.get(i);
            this.clientTracer.submitBinaryAnnotation(tag.getKey(), tag.getValue());
        }
    }

    Endpoint serverAddress(Connection connection) {
        InetSocketAddress sa = connection.route().socketAddress();
        Endpoint.Builder builder = Endpoint.builder().serviceName(this.serverName).port(sa.getPort());
        byte[] address = sa.getAddress().getAddress();
        if (address.length == 4) {
            builder.ipv4(ByteBuffer.wrap(address).getInt());
        } else if (address.length == 16) {
            builder.ipv6(address);
        }
        return builder.build();
    }

    public static final class Builder {
        final Brave brave;
        String serverName = "";
        OkHttpParser parser = new OkHttpParser();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder serverName(String serverName) {
            this.serverName = (String)Util.checkNotNull((Object)serverName, (String)"serverName", (Object[])new Object[0]);
            return this;
        }

        public Builder parser(OkHttpParser parser) {
            this.parser = (OkHttpParser)Util.checkNotNull((Object)parser, (String)"parser", (Object[])new Object[0]);
            return this;
        }

        public BraveTracingInterceptor build() {
            return new BraveTracingInterceptor(this);
        }
    }
}

