/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.Tracer;
import brave.jms.JmsTracing;
import brave.jms.PropertyFilter;
import brave.jms.TracingCompletionListener;
import brave.jms.TracingProducer;
import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSProducer;
import javax.jms.Message;

final class TracingJMSProducer
extends TracingProducer<JMSProducer, JMSProducer>
implements JMSProducer {
    static final Propagation.Getter<JMSProducer, String> GETTER = new Propagation.Getter<JMSProducer, String>(){

        public String get(JMSProducer carrier, String key) {
            return carrier.getStringProperty(key);
        }

        public String toString() {
            return "JMSProducer::getStringProperty";
        }
    };
    final TraceContext.Extractor<JMSProducer> extractor;

    TracingJMSProducer(JMSProducer delegate, JmsTracing jmsTracing) {
        super(delegate, jmsTracing);
        this.extractor = jmsTracing.tracing.propagation().extractor(GETTER);
    }

    @Override
    void addB3SingleHeader(JMSProducer message, TraceContext context) {
        message.setProperty("b3", B3SingleFormat.writeB3SingleFormatWithoutParentId((TraceContext)context));
    }

    @Override
    void clearPropagationHeaders(JMSProducer message) {
        PropertyFilter.JMS_PRODUCER.filterProperties(message, this.jmsTracing.propagationKeys);
    }

    @Override
    TraceContextOrSamplingFlags extractAndClearMessage(JMSProducer message) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)message);
        PropertyFilter.JMS_PRODUCER.filterProperties(message, this.jmsTracing.propagationKeys);
        return extracted;
    }

    @Override
    Destination destination(JMSProducer producer) {
        return null;
    }

    public JMSProducer send(Destination destination, Message message) {
        this.send(Send.MESSAGE, destination, message);
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        this.send(Send.STRING, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        this.send(Send.MAP, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        this.send(Send.BYTES, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        this.send(Send.SERIALIZABLE, destination, body);
        return this;
    }

    void send(Send send, Destination destination, Object message) {
        Span span = this.createAndStartProducerSpan(destination, this);
        CompletionListener oldCompletionListener = this.getAsync();
        if (oldCompletionListener != null) {
            ((JMSProducer)this.delegate).setAsync(TracingCompletionListener.create(oldCompletionListener, span, this.current));
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            send.apply((JMSProducer)this.delegate, destination, message);
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            span.finish();
            throw e;
        }
        finally {
            ws.close();
            if (oldCompletionListener != null) {
                ((JMSProducer)this.delegate).setAsync(oldCompletionListener);
            } else {
                span.finish();
            }
        }
    }

    public JMSProducer setDisableMessageID(boolean value) {
        ((JMSProducer)this.delegate).setDisableMessageID(value);
        return this;
    }

    public boolean getDisableMessageID() {
        return ((JMSProducer)this.delegate).getDisableMessageID();
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        ((JMSProducer)this.delegate).setDisableMessageTimestamp(value);
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return ((JMSProducer)this.delegate).getDisableMessageTimestamp();
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        ((JMSProducer)this.delegate).setDeliveryMode(deliveryMode);
        return this;
    }

    public int getDeliveryMode() {
        return ((JMSProducer)this.delegate).getDeliveryMode();
    }

    public JMSProducer setPriority(int priority) {
        ((JMSProducer)this.delegate).setPriority(priority);
        return this;
    }

    public int getPriority() {
        return ((JMSProducer)this.delegate).getPriority();
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        ((JMSProducer)this.delegate).setTimeToLive(timeToLive);
        return this;
    }

    public long getTimeToLive() {
        return ((JMSProducer)this.delegate).getTimeToLive();
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        ((JMSProducer)this.delegate).setDeliveryDelay(deliveryDelay);
        return this;
    }

    public long getDeliveryDelay() {
        return ((JMSProducer)this.delegate).getDeliveryDelay();
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        ((JMSProducer)this.delegate).setAsync(completionListener);
        return this;
    }

    public CompletionListener getAsync() {
        return ((JMSProducer)this.delegate).getAsync();
    }

    public JMSProducer setProperty(String name, boolean value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        ((JMSProducer)this.delegate).setProperty(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        ((JMSProducer)this.delegate).clearProperties();
        return this;
    }

    public boolean propertyExists(String name) {
        return ((JMSProducer)this.delegate).propertyExists(name);
    }

    public boolean getBooleanProperty(String name) {
        return ((JMSProducer)this.delegate).getBooleanProperty(name);
    }

    public byte getByteProperty(String name) {
        return ((JMSProducer)this.delegate).getByteProperty(name);
    }

    public short getShortProperty(String name) {
        return ((JMSProducer)this.delegate).getShortProperty(name);
    }

    public int getIntProperty(String name) {
        return ((JMSProducer)this.delegate).getIntProperty(name);
    }

    public long getLongProperty(String name) {
        return ((JMSProducer)this.delegate).getLongProperty(name);
    }

    public float getFloatProperty(String name) {
        return ((JMSProducer)this.delegate).getFloatProperty(name);
    }

    public double getDoubleProperty(String name) {
        return ((JMSProducer)this.delegate).getDoubleProperty(name);
    }

    public String getStringProperty(String name) {
        return ((JMSProducer)this.delegate).getStringProperty(name);
    }

    public Object getObjectProperty(String name) {
        return ((JMSProducer)this.delegate).getObjectProperty(name);
    }

    public Set<String> getPropertyNames() {
        return ((JMSProducer)this.delegate).getPropertyNames();
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        ((JMSProducer)this.delegate).setJMSCorrelationIDAsBytes(correlationID);
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return ((JMSProducer)this.delegate).getJMSCorrelationIDAsBytes();
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        ((JMSProducer)this.delegate).setJMSCorrelationID(correlationID);
        return this;
    }

    public String getJMSCorrelationID() {
        return ((JMSProducer)this.delegate).getJMSCorrelationID();
    }

    public JMSProducer setJMSType(String type) {
        ((JMSProducer)this.delegate).setJMSType(type);
        return this;
    }

    public String getJMSType() {
        return ((JMSProducer)this.delegate).getJMSType();
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        ((JMSProducer)this.delegate).setJMSReplyTo(replyTo);
        return this;
    }

    public Destination getJMSReplyTo() {
        return ((JMSProducer)this.delegate).getJMSReplyTo();
    }

    static enum Send {
        MESSAGE{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Message)message);
            }
        }
        ,
        STRING{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (String)message);
            }
        }
        ,
        MAP{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Map)message);
            }
        }
        ,
        BYTES{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (byte[])message);
            }
        }
        ,
        SERIALIZABLE{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Serializable)message);
            }
        };


        abstract void apply(JMSProducer var1, Destination var2, Object var3);
    }
}

