/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.spec;

import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.msgpack.spec.MsgpackReaderException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackToken {
    public static final MsgPackToken NIL = new MsgPackToken();
    protected static final int MAX_MAP_ELEMENTS = 0x3FFFFFFF;
    protected MsgPackType type = MsgPackType.NIL;
    protected int totalLength;
    protected UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
    protected boolean booleanValue;
    protected int size;
    protected long integerValue;
    protected double floatValue;

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public int getSize() {
        return this.size;
    }

    public MsgPackType getType() {
        return this.type;
    }

    public DirectBuffer getValueBuffer() {
        return this.valueBuffer;
    }

    public void setValue(DirectBuffer buffer, int offset, int length) {
        if (length == 0) {
            this.valueBuffer.wrap(0L, 0);
        } else if (offset + length <= buffer.capacity()) {
            this.valueBuffer.wrap(buffer, offset, length);
        } else {
            int result = offset + length;
            throw new MsgpackReaderException(String.format("Reading %d bytes past buffer capacity(%d) in range [%d:%d]", result - buffer.capacity(), buffer.capacity(), offset, result));
        }
    }

    public void setValue(double value) {
        this.floatValue = value;
    }

    public void setValue(long value) {
        this.integerValue = value;
    }

    public void setValue(boolean value) {
        this.booleanValue = value;
    }

    public void setMapHeader(int size) {
        this.size = size;
    }

    public void setArrayHeader(int size) {
        this.size = size;
    }

    public void setType(MsgPackType type) {
        this.type = type;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public long getIntegerValue() {
        return this.integerValue;
    }

    public double getFloatValue() {
        return this.floatValue;
    }
}

