/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.zeebe.exporter.proto.Schema;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.ErrorRecordValue;
import io.zeebe.protocol.record.value.IncidentRecordValue;
import io.zeebe.protocol.record.value.JobBatchRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.record.value.MessageRecordValue;
import io.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.zeebe.protocol.record.value.TimerRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.zeebe.protocol.record.value.VariableRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceSubscriptionRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import io.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class RecordTransformer {
    private static final EnumMap<ValueType, Function<Record, GeneratedMessageV3>> TRANSFORMERS = new EnumMap(ValueType.class);

    private RecordTransformer() {
    }

    public static GeneratedMessageV3 toProtobufMessage(Record record) {
        ValueType valueType = record.getValueType();
        Function<Record, GeneratedMessageV3> toRecordFunc = TRANSFORMERS.get(valueType);
        return toRecordFunc != null ? toRecordFunc.apply(record) : Empty.getDefaultInstance();
    }

    public static Schema.RecordId toRecordId(Record record) {
        return Schema.RecordId.newBuilder().setPartitionId(record.getPartitionId()).setPosition(record.getPosition()).build();
    }

    public static Schema.RecordMetadata toMetadata(Record record) {
        Schema.RecordMetadata.Builder builder = Schema.RecordMetadata.newBuilder().setIntent(record.getIntent().name()).setValueType(Schema.RecordMetadata.ValueType.valueOf(record.getValueType().name())).setKey(record.getKey()).setRecordType(Schema.RecordMetadata.RecordType.valueOf(record.getRecordType().name())).setSourceRecordPosition(record.getSourceRecordPosition()).setPosition(record.getPosition()).setTimestamp(record.getTimestamp()).setPartitionId(record.getPartitionId());
        if (record.getRejectionType() != null) {
            builder.setRejectionType(record.getRejectionType().name());
            builder.setRejectionReason(record.getRejectionReason());
        }
        return builder.build();
    }

    public static Schema.DeploymentRecord toDeploymentRecord(Record<DeploymentRecordValue> record) {
        Schema.DeploymentRecord.Builder builder = Schema.DeploymentRecord.newBuilder().setMetadata(RecordTransformer.toMetadata(record));
        for (DeploymentResource resource : ((DeploymentRecordValue)record.getValue()).getResources()) {
            builder.addResources(RecordTransformer.toDeploymentRecordResource(resource));
        }
        for (DeployedWorkflow workflow : ((DeploymentRecordValue)record.getValue()).getDeployedWorkflows()) {
            builder.addDeployedWorkflows(RecordTransformer.toDeploymentRecordWorkflow(workflow));
        }
        return builder.build();
    }

    public static Schema.DeploymentRecord.Resource toDeploymentRecordResource(DeploymentResource resource) {
        return Schema.DeploymentRecord.Resource.newBuilder().setResource(ByteString.copyFrom((byte[])resource.getResource())).setResourceName(resource.getResourceName()).setResourceType(resource.getResourceType().name()).build();
    }

    public static Schema.DeploymentRecord.Workflow toDeploymentRecordWorkflow(DeployedWorkflow workflow) {
        return Schema.DeploymentRecord.Workflow.newBuilder().setBpmnProcessId(workflow.getBpmnProcessId()).setResourceName(workflow.getResourceName()).setVersion(workflow.getVersion()).setWorkflowKey(workflow.getWorkflowKey()).build();
    }

    public static Schema.IncidentRecord toIncidentRecord(Record<IncidentRecordValue> record) {
        IncidentRecordValue value = (IncidentRecordValue)record.getValue();
        return Schema.IncidentRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setErrorMessage(value.getErrorMessage()).setErrorType(value.getErrorType().name()).setJobKey(value.getJobKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setVariableScopeKey(value.getVariableScopeKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.JobRecord toJobRecord(Record<JobRecordValue> record) {
        Schema.JobRecord.Builder builder = RecordTransformer.toJobRecord((JobRecordValue)record.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.JobRecord.Builder toJobRecord(JobRecordValue value) {
        return Schema.JobRecord.newBuilder().setDeadline(value.getDeadline()).setErrorMessage(value.getErrorMessage()).setRetries(value.getRetries()).setType(value.getType()).setWorker(value.getWorker()).setVariables(RecordTransformer.toStruct(value.getVariables())).setCustomHeaders(RecordTransformer.toStruct(value.getCustomHeaders())).setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setWorkflowDefinitionVersion(value.getWorkflowDefinitionVersion()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey());
    }

    public static Schema.JobBatchRecord toJobBatchRecord(Record<JobBatchRecordValue> record) {
        JobBatchRecordValue value = (JobBatchRecordValue)record.getValue();
        Schema.JobBatchRecord.Builder builder = Schema.JobBatchRecord.newBuilder();
        if (!value.getJobs().isEmpty()) {
            for (JobRecordValue job : value.getJobs()) {
                builder.addJobs(RecordTransformer.toJobRecord(job));
            }
        }
        if (!value.getJobKeys().isEmpty()) {
            builder.addAllJobKeys(value.getJobKeys());
        }
        return builder.setMaxJobsToActivate(value.getMaxJobsToActivate()).setTimeout(value.getTimeout()).setType(value.getType()).setWorker(value.getWorker()).setTruncated(value.isTruncated()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.MessageRecord toMessageRecord(Record<MessageRecordValue> record) {
        MessageRecordValue value = (MessageRecordValue)record.getValue();
        return Schema.MessageRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setMessageId(value.getMessageId()).setName(value.getName()).setTimeToLive(value.getTimeToLive()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.MessageSubscriptionRecord toMessageSubscriptionRecord(Record<MessageSubscriptionRecordValue> record) {
        MessageSubscriptionRecordValue value = (MessageSubscriptionRecordValue)record.getValue();
        return Schema.MessageSubscriptionRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setElementInstanceKey(value.getElementInstanceKey()).setMessageName(value.getMessageName()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.MessageStartEventSubscriptionRecord toMessageStartEventSubscriptionRecord(Record<MessageStartEventSubscriptionRecordValue> record) {
        MessageStartEventSubscriptionRecordValue value = (MessageStartEventSubscriptionRecordValue)record.getValue();
        Schema.MessageStartEventSubscriptionRecord.Builder builder = Schema.MessageStartEventSubscriptionRecord.newBuilder();
        builder.setWorkflowKey(value.getWorkflowKey()).setMessageName(value.getMessageName()).setStartEventId(value.getStartEventId());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.VariableRecord toVariableRecord(Record<VariableRecordValue> record) {
        VariableRecordValue value = (VariableRecordValue)record.getValue();
        Schema.VariableRecord.Builder builder = Schema.VariableRecord.newBuilder();
        builder.setScopeKey(value.getScopeKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setName(value.getName()).setValue(value.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.TimerRecord toTimerRecord(Record<TimerRecordValue> record) {
        TimerRecordValue value = (TimerRecordValue)record.getValue();
        return Schema.TimerRecord.newBuilder().setDueDate(value.getDueDate()).setRepetitions(value.getRepetitions()).setElementInstanceKey(value.getElementInstanceKey()).setTargetFlowNodeId(value.getTargetElementId()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.WorkflowInstanceRecord toWorkflowInstanceRecord(Record<WorkflowInstanceRecordValue> record) {
        WorkflowInstanceRecordValue value = (WorkflowInstanceRecordValue)record.getValue();
        return Schema.WorkflowInstanceRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setFlowScopeKey(value.getFlowScopeKey()).setVersion(value.getVersion()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setWorkflowKey(value.getWorkflowKey()).setBpmnElementType(Schema.WorkflowInstanceRecord.BpmnElementType.valueOf(value.getBpmnElementType().name())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.WorkflowInstanceSubscriptionRecord toWorkflowInstanceSubscriptionRecord(Record<WorkflowInstanceSubscriptionRecordValue> record) {
        WorkflowInstanceSubscriptionRecordValue value = (WorkflowInstanceSubscriptionRecordValue)record.getValue();
        return Schema.WorkflowInstanceSubscriptionRecord.newBuilder().setElementInstanceKey(value.getElementInstanceKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setMessageName(value.getMessageName()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.WorkflowInstanceCreationRecord toWorkflowInstanceCreationRecord(Record<WorkflowInstanceCreationRecordValue> record) {
        WorkflowInstanceCreationRecordValue value = (WorkflowInstanceCreationRecordValue)record.getValue();
        return Schema.WorkflowInstanceCreationRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setWorkflowKey(value.getWorkflowKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.VariableDocumentRecord toVariableDocumentRecord(Record<VariableDocumentRecordValue> record) {
        VariableDocumentRecordValue value = (VariableDocumentRecordValue)record.getValue();
        return Schema.VariableDocumentRecord.newBuilder().setScopeKey(value.getScopeKey()).setUpdateSemantics(Schema.VariableDocumentRecord.UpdateSemantics.valueOf(value.getUpdateSemantics().name())).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Schema.ErrorRecord toErrorRecord(Record<ErrorRecordValue> record) {
        ErrorRecordValue value = (ErrorRecordValue)record.getValue();
        return Schema.ErrorRecord.newBuilder().setExceptionMessage(value.getExceptionMessage()).setStacktrace(value.getStacktrace()).setErrorEventPosition(value.getErrorEventPosition()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    public static Struct toStruct(Map<?, ?> map) {
        Struct.Builder builder = Struct.newBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.putFields(entry.getKey().toString(), RecordTransformer.toValue(entry.getValue()));
        }
        return builder.build();
    }

    public static Value toValue(Object object) {
        Value.Builder builder = Value.newBuilder();
        if (object == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (object instanceof Number) {
            builder.setNumberValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            builder.setBoolValue(((Boolean)object).booleanValue());
        } else if (object instanceof List) {
            List list = (List)object;
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : list) {
                listBuilder.addValues(RecordTransformer.toValue(item));
            }
            builder.setListValue(listBuilder.build());
        } else if (object instanceof Map) {
            builder.setStructValue(RecordTransformer.toStruct((Map)object));
        } else if (object instanceof String) {
            builder.setStringValue((String)object);
        } else {
            throw new IllegalArgumentException(String.format("Unexpected struct value of type %s, should be one of: null, Number, Boolean, List, Map, String", object.getClass().getCanonicalName()));
        }
        return builder.build();
    }

    static {
        TRANSFORMERS.put(ValueType.DEPLOYMENT, RecordTransformer::toDeploymentRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE, RecordTransformer::toWorkflowInstanceRecord);
        TRANSFORMERS.put(ValueType.JOB_BATCH, RecordTransformer::toJobBatchRecord);
        TRANSFORMERS.put(ValueType.JOB, RecordTransformer::toJobRecord);
        TRANSFORMERS.put(ValueType.INCIDENT, RecordTransformer::toIncidentRecord);
        TRANSFORMERS.put(ValueType.MESSAGE, RecordTransformer::toMessageRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_SUBSCRIPTION, RecordTransformer::toMessageSubscriptionRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, RecordTransformer::toWorkflowInstanceSubscriptionRecord);
        TRANSFORMERS.put(ValueType.TIMER, RecordTransformer::toTimerRecord);
        TRANSFORMERS.put(ValueType.VARIABLE, RecordTransformer::toVariableRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, RecordTransformer::toMessageStartEventSubscriptionRecord);
        TRANSFORMERS.put(ValueType.WORKFLOW_INSTANCE_CREATION, RecordTransformer::toWorkflowInstanceCreationRecord);
        TRANSFORMERS.put(ValueType.VARIABLE_DOCUMENT, RecordTransformer::toVariableDocumentRecord);
        TRANSFORMERS.put(ValueType.ERROR, RecordTransformer::toErrorRecord);
    }
}

