/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm;

import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.TransactionManager;
import io.seata.core.protocol.transaction.AbstractTransactionRequest;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import io.seata.core.rpc.netty.TmRpcClient;
import java.util.concurrent.TimeoutException;

public class DefaultTransactionManager
implements TransactionManager {
    public static TransactionManager get() {
        return SingletonHolder.INSTANCE;
    }

    public static void set(TransactionManager mock) {
        SingletonHolder.INSTANCE = mock;
    }

    private DefaultTransactionManager() {
    }

    public String begin(String applicationId, String transactionServiceGroup, String name, int timeout) throws TransactionException {
        GlobalBeginRequest request = new GlobalBeginRequest();
        request.setTransactionName(name);
        request.setTimeout(timeout);
        GlobalBeginResponse response = (GlobalBeginResponse)this.syncCall((AbstractTransactionRequest)request);
        return response.getXid();
    }

    public GlobalStatus commit(String xid) throws TransactionException {
        GlobalCommitRequest globalCommit = new GlobalCommitRequest();
        globalCommit.setXid(xid);
        GlobalCommitResponse response = (GlobalCommitResponse)this.syncCall((AbstractTransactionRequest)globalCommit);
        return response.getGlobalStatus();
    }

    public GlobalStatus rollback(String xid) throws TransactionException {
        GlobalRollbackRequest globalRollback = new GlobalRollbackRequest();
        globalRollback.setXid(xid);
        GlobalRollbackResponse response = (GlobalRollbackResponse)this.syncCall((AbstractTransactionRequest)globalRollback);
        return response.getGlobalStatus();
    }

    public GlobalStatus getStatus(String xid) throws TransactionException {
        GlobalStatusRequest queryGlobalStatus = new GlobalStatusRequest();
        queryGlobalStatus.setXid(xid);
        GlobalStatusResponse response = (GlobalStatusResponse)this.syncCall((AbstractTransactionRequest)queryGlobalStatus);
        return response.getGlobalStatus();
    }

    private AbstractTransactionResponse syncCall(AbstractTransactionRequest request) throws TransactionException {
        try {
            return (AbstractTransactionResponse)TmRpcClient.getInstance().sendMsgWithResponse((Object)request);
        }
        catch (TimeoutException toe) {
            throw new TransactionException(TransactionExceptionCode.IO, (Throwable)toe);
        }
    }

    private static class SingletonHolder {
        private static TransactionManager INSTANCE = new DefaultTransactionManager();

        private SingletonHolder() {
        }
    }
}

