/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortFluent;

public class NetworkPolicyPortFluentImpl<A extends NetworkPolicyPortFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyPortFluent<A> {
    private IntOrStringBuilder port;
    private String protocol;

    public NetworkPolicyPortFluentImpl() {
    }

    public NetworkPolicyPortFluentImpl(NetworkPolicyPort instance) {
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String strVal) {
        return this.withPort(new IntOrString(strVal));
    }

    @Override
    public A withNewPort(Integer intVal) {
        return this.withPort(new IntOrString(intVal));
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    @Override
    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPortFluentImpl that = (NetworkPolicyPortFluentImpl)o;
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null);
    }

    public class PortNestedImpl<N>
    extends IntOrStringFluentImpl<NetworkPolicyPortFluent.PortNested<N>>
    implements NetworkPolicyPortFluent.PortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPortFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

