package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NamedRoleFluentImpl<A extends NamedRoleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedRoleFluent<A>{

    private String name;
    private RoleBuilder role;

    public NamedRoleFluentImpl(){
    }
    public NamedRoleFluentImpl(NamedRole instance){
            this.withName(instance.getName()); 
            this.withRole(instance.getRole()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    
/**
 * This method has been deprecated, please use method buildRole instead.
 * @return The buildable object.
 */
@Deprecated public Role getRole(){
            return this.role!=null?this.role.build():null;
    }

    public Role buildRole(){
            return this.role!=null?this.role.build():null;
    }

    public A withRole(Role role){
            _visitables.remove(this.role);
            if (role!=null){ this.role= new RoleBuilder(role); _visitables.add(this.role);} return (A) this;
    }

    public Boolean hasRole(){
            return this.role != null;
    }

    public NamedRoleFluent.RoleNested<A> withNewRole(){
            return new RoleNestedImpl();
    }

    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item){
            return new RoleNestedImpl(item);
    }

    public NamedRoleFluent.RoleNested<A> editRole(){
            return withNewRoleLike(getRole());
    }

    public NamedRoleFluent.RoleNested<A> editOrNewRole(){
            return withNewRoleLike(getRole() != null ? getRole(): new RoleBuilder().build());
    }

    public NamedRoleFluent.RoleNested<A> editOrNewRoleLike(Role item){
            return withNewRoleLike(getRole() != null ? getRole(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedRoleFluentImpl that = (NamedRoleFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (role != null ? !role.equals(that.role) :that.role != null) return false;
            return true;
    }


    public class RoleNestedImpl<N> extends RoleFluentImpl<NamedRoleFluent.RoleNested<N>> implements NamedRoleFluent.RoleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
    
            RoleNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
            RoleNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) NamedRoleFluentImpl.this.withRole(builder.build());
    }
    public N endRole(){
            return and();
    }

}


}
