package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NamedClusterRoleBindingFluentImpl<A extends NamedClusterRoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedClusterRoleBindingFluent<A>{

    private String name;
    private ClusterRoleBindingBuilder roleBinding;

    public NamedClusterRoleBindingFluentImpl(){
    }
    public NamedClusterRoleBindingFluentImpl(NamedClusterRoleBinding instance){
            this.withName(instance.getName()); 
            this.withRoleBinding(instance.getRoleBinding()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    
/**
 * This method has been deprecated, please use method buildRoleBinding instead.
 * @return The buildable object.
 */
@Deprecated public ClusterRoleBinding getRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public ClusterRoleBinding buildRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public A withRoleBinding(ClusterRoleBinding roleBinding){
            _visitables.remove(this.roleBinding);
            if (roleBinding!=null){ this.roleBinding= new ClusterRoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (A) this;
    }

    public Boolean hasRoleBinding(){
            return this.roleBinding != null;
    }

    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding(){
            return new RoleBindingNestedImpl();
    }

    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(ClusterRoleBinding item){
            return new RoleBindingNestedImpl(item);
    }

    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding());
    }

    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding() != null ? getRoleBinding(): new ClusterRoleBindingBuilder().build());
    }

    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(ClusterRoleBinding item){
            return withNewRoleBindingLike(getRoleBinding() != null ? getRoleBinding(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedClusterRoleBindingFluentImpl that = (NamedClusterRoleBindingFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
            return true;
    }


    public class RoleBindingNestedImpl<N> extends ClusterRoleBindingFluentImpl<NamedClusterRoleBindingFluent.RoleBindingNested<N>> implements NamedClusterRoleBindingFluent.RoleBindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            RoleBindingNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            RoleBindingNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) NamedClusterRoleBindingFluentImpl.this.withRoleBinding(builder.build());
    }
    public N endRoleBinding(){
            return and();
    }

}


}
