package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class KubernetesRoleListBuilder extends KubernetesRoleListFluentImpl<KubernetesRoleListBuilder> implements VisitableBuilder<KubernetesRoleList,KubernetesRoleListBuilder>{

    KubernetesRoleListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesRoleListBuilder(){
            this(true);
    }
    public KubernetesRoleListBuilder(Boolean validationEnabled){
            this(new KubernetesRoleList(), validationEnabled);
    }
    public KubernetesRoleListBuilder(KubernetesRoleListFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRoleListBuilder(KubernetesRoleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRoleList(), validationEnabled);
    }
    public KubernetesRoleListBuilder(KubernetesRoleListFluent<?> fluent,KubernetesRoleList instance){
            this(fluent, instance, true);
    }
    public KubernetesRoleListBuilder(KubernetesRoleListFluent<?> fluent,KubernetesRoleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleListBuilder(KubernetesRoleList instance){
            this(instance,true);
    }
    public KubernetesRoleListBuilder(KubernetesRoleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleListBuilder(Validator validator){
            this(new KubernetesRoleList(), true);
    }
    public KubernetesRoleListBuilder(KubernetesRoleListFluent<?> fluent,KubernetesRoleList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public KubernetesRoleListBuilder(KubernetesRoleList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public KubernetesRoleList build(){
            KubernetesRoleList buildable = new KubernetesRoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRoleListBuilder that = (KubernetesRoleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
