package io.fabric8.kubernetes.api.model.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface TokenReviewStatusFluent<A extends TokenReviewStatusFluent<A>> extends Fluent<A>{


    public Boolean isAuthenticated();
    public A withAuthenticated(Boolean authenticated);
    public Boolean hasAuthenticated();
    public A withNewAuthenticated(String arg1);
    public A withNewAuthenticated(boolean arg1);
    public String getError();
    public A withError(String error);
    public Boolean hasError();
    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public UserInfo getUser();
    public UserInfo buildUser();
    public A withUser(UserInfo user);
    public Boolean hasUser();
    public TokenReviewStatusFluent.UserNested<A> withNewUser();
    public TokenReviewStatusFluent.UserNested<A> withNewUserLike(UserInfo item);
    public TokenReviewStatusFluent.UserNested<A> editUser();
    public TokenReviewStatusFluent.UserNested<A> editOrNewUser();
    public TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(UserInfo item);

    public interface UserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserInfoFluent<TokenReviewStatusFluent.UserNested<N>>{

        
    public N and();    public N endUser();
}


}
