/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import java.util.regex.Pattern;

public final class ClassPatternRule {
    private final Pattern pattern;
    public final String printout;

    public ClassPatternRule(String glob, String printout) {
        if (glob == null || printout == null) {
            throw new NullPointerException();
        }
        this.pattern = AsmUtils.glob2Pattern(glob);
        assert (this.pattern.flags() == 0) : "the pattern should have no flags (must be case-sensitive,...)";
        this.printout = printout;
    }

    public boolean matches(String className) {
        return this.pattern.matcher(className).matches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pattern.pattern().hashCode();
        result = 31 * result + this.printout.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassPatternRule other = (ClassPatternRule)obj;
        if (!this.pattern.pattern().equals(other.pattern.pattern())) {
            return false;
        }
        return this.printout.equals(other.printout);
    }

    public String toString() {
        return "ClassPatternRule [pattern=" + this.pattern + ", printout=" + this.printout + "]";
    }
}

