/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.plexus.util.DirectoryScanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckMojo
extends AbstractMojo {
    @Parameter(required=false)
    private File[] signaturesFiles;
    @Parameter(required=false)
    private String signatures;
    @Parameter(required=false)
    private String[] bundledSignatures;
    @Parameter(required=false, defaultValue="false")
    private boolean internalRuntimeForbidden;
    @Parameter(required=false, defaultValue="false")
    private boolean failOnUnsupportedJava;
    @Parameter(required=false, defaultValue="true")
    private boolean failOnMissingClasses;
    @Parameter(required=false, defaultValue="true")
    private boolean failOnUnresolvableSignatures;
    @Parameter(required=false, defaultValue="${maven.compiler.target}")
    private String targetVersion;
    @Parameter(required=false)
    private String[] includes;
    @Parameter(required=false)
    private String[] excludes;
    @Parameter(required=false)
    private String[] suppressAnnotations;
    @Parameter(required=false, property="forbiddenapis.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.packaging}", readonly=true, required=true)
    private String packaging;

    protected abstract List<String> getClassPathElements();

    protected abstract File getClassesDirectory();

    protected String getTargetVersion() {
        return this.targetVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader classLoader;
        Object[] urls;
        final Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping forbidden-apis checks.");
            return;
        }
        if ("pom".equals(this.packaging)) {
            log.info((CharSequence)("Skipping execution for packaging \"" + this.packaging + "\""));
            return;
        }
        if (this.includes == null) {
            this.includes = new String[]{"**/*.class"};
        }
        try {
            List<String> cp = this.getClassPathElements();
            urls = new URL[cp.size()];
            int i = 0;
            for (String cpElement : cp) {
                urls[i++] = new File(cpElement).toURI().toURL();
            }
            assert (i == urls.length);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Compile Classpath: " + Arrays.toString(urls)));
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to build classpath: " + e);
        }
        URLClassLoader urlLoader = null;
        if (urls.length > 0) {
            urlLoader = URLClassLoader.newInstance((URL[])urls, ClassLoader.getSystemClassLoader());
            classLoader = urlLoader;
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader loader = classLoader;
        try {
            Checker checker = new Checker(loader, this.internalRuntimeForbidden, this.failOnMissingClasses, this.failOnUnresolvableSignatures){

                protected void logError(String msg) {
                    log.error((CharSequence)msg);
                }

                protected void logWarn(String msg) {
                    log.warn((CharSequence)msg);
                }

                protected void logInfo(String msg) {
                    log.info((CharSequence)msg);
                }
            };
            if (!checker.isSupportedJDK) {
                String msg = String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by the forbiddenapis MOJO. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"));
                if (this.failOnUnsupportedJava) {
                    throw new MojoExecutionException(msg);
                }
                log.warn((CharSequence)msg);
                return;
            }
            if (this.suppressAnnotations != null) {
                for (String a : this.suppressAnnotations) {
                    checker.addSuppressAnnotation(a);
                }
            }
            log.info((CharSequence)"Scanning for classes to check...");
            File classesDirectory = this.getClassesDirectory();
            if (!classesDirectory.exists()) {
                log.warn((CharSequence)("Classes directory does not exist, forbiddenapis check skipped: " + classesDirectory));
                return;
            }
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(classesDirectory);
            ds.setCaseSensitive(true);
            ds.setIncludes(this.includes);
            ds.setExcludes(this.excludes);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                log.warn((CharSequence)String.format(Locale.ENGLISH, "No classes found in '%s' (includes=%s, excludes=%s), forbiddenapis check skipped.", classesDirectory.toString(), Arrays.toString(this.includes), Arrays.toString(this.excludes)));
                return;
            }
            try {
                String sig;
                String string = sig = this.signatures != null ? this.signatures.trim() : null;
                if (sig != null && sig.length() != 0) {
                    log.info((CharSequence)"Reading inline API signatures...");
                    checker.parseSignaturesString(sig);
                }
                if (this.bundledSignatures != null) {
                    String targetVersion = this.getTargetVersion();
                    if ("".equals(targetVersion)) {
                        targetVersion = null;
                    }
                    if (targetVersion == null) {
                        log.warn((CharSequence)"The 'targetVersion' parameter or '${maven.compiler.target}' property is missing. Trying to read bundled JDK signatures without compiler target. You have to explicitely specify the version in the resource name.");
                    }
                    for (String bs : this.bundledSignatures) {
                        log.info((CharSequence)("Reading bundled API signatures: " + bs));
                        checker.parseBundledSignatures(bs, targetVersion);
                    }
                }
                if (this.signaturesFiles != null) {
                    for (File f : this.signaturesFiles) {
                        log.info((CharSequence)("Reading API signatures: " + f));
                        checker.parseSignaturesFile(new FileInputStream(f));
                    }
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("IO problem while reading files with API signatures: " + ioe);
            }
            catch (ParseException pe) {
                throw new MojoExecutionException("Parsing signatures failed: " + pe.getMessage());
            }
            if (checker.hasNoSignatures()) {
                if (this.failOnUnresolvableSignatures) {
                    throw new MojoExecutionException("No API signatures found; use parameters 'signatures', 'bundledSignatures', and/or 'signaturesFiles' to define those!");
                }
                log.info((CharSequence)"Skipping execution because no API signatures are available.");
                return;
            }
            log.info((CharSequence)"Loading classes to check...");
            try {
                for (String f : files) {
                    checker.addClassToCheck(new FileInputStream(new File(classesDirectory, f)));
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to load one of the given class files: " + ioe);
            }
            log.info((CharSequence)"Scanning for API signatures and dependencies...");
            try {
                checker.run();
                return;
            }
            catch (ForbiddenApiException fae) {
                throw new MojoFailureException(fae.getMessage());
            }
        }
        finally {
            if (urlLoader instanceof Closeable) {
                try {
                    ((Closeable)urlLoader).close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

