/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public abstract class NodeIdResolver {
    public abstract String getNodeId(InetSocketAddress var1);

    public static Builder node(String id, InetSocketAddress address) {
        return new Builder().node(id, address);
    }

    public static class MapBasedResolver
    extends NodeIdResolver {
        private final Map<InetSocketAddress, String> _address2Ids;

        public MapBasedResolver(Map<InetSocketAddress, String> address2Ids) {
            this._address2Ids = address2Ids;
        }

        @Override
        public String getNodeId(InetSocketAddress inetAddress) {
            return this._address2Ids.get(inetAddress);
        }
    }

    public static class Builder {
        private final Map<InetSocketAddress, String> _address2Ids = new HashMap<InetSocketAddress, String>();

        public Builder node(String id, InetSocketAddress address) {
            String previous = this._address2Ids.put(address, id);
            if (previous != null) {
                throw new IllegalArgumentException("There's already an address bound to id " + previous);
            }
            return this;
        }

        public NodeIdResolver build() {
            return new MapBasedResolver(this._address2Ids);
        }
    }
}

