/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Loader;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavaSerializationTranscoder
implements SessionAttributesTranscoder {
    private static final Log LOG = LogFactory.getLog(JavaSerializationTranscoder.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    protected static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private final MemcachedSessionService.SessionManager _manager;

    public JavaSerializationTranscoder() {
        this(null);
    }

    public JavaSerializationTranscoder(MemcachedSessionService.SessionManager manager) {
        this._manager = manager;
    }

    @Override
    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        if (attributes == null) {
            throw new NullPointerException("Can't serialize null");
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            this.writeAttributes(session, attributes, oos);
            byte[] byArray = bos.toByteArray();
            this.closeSilently(bos);
            this.closeSilently(oos);
            return byArray;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                this.closeSilently(bos);
                this.closeSilently(oos);
                throw throwable;
            }
        }
    }

    private void writeAttributes(MemcachedBackupSession session, Map<String, Object> attributes, ObjectOutputStream oos) throws IOException {
        String[] keys = attributes.keySet().toArray(EMPTY_ARRAY);
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList<Object> saveValues = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            Object value = attributes.get(keys[i]);
            if (value == null || session.exclude(keys[i])) continue;
            if (value instanceof Serializable) {
                saveNames.add(keys[i]);
                saveValues.add(value);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ignoring attribute '" + keys[i] + "' as it does not implement Serializable"));
        }
        int n = saveNames.size();
        oos.writeObject(n);
        for (int i = 0; i < n; ++i) {
            oos.writeObject(saveNames.get(i));
            try {
                oos.writeObject(saveValues.get(i));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("  storing attribute '" + (String)saveNames.get(i) + "' with value '" + saveValues.get(i) + "'"));
                continue;
            }
            catch (NotSerializableException e) {
                LOG.warn((Object)this._manager.getString("standardSession.notSerializable", saveNames.get(i), session.getIdInternal()), (Throwable)e);
                oos.writeObject(NOT_SERIALIZED);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("  storing attribute '" + (String)saveNames.get(i) + "' with value NOT_SERIALIZED"));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> deserializeAttributes(byte[] in) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(in);
            ois = this.createObjectInputStream(bis);
            ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
            int n = (Integer)ois.readObject();
            int i = 0;
            while (true) {
                if (i >= n) {
                    ConcurrentHashMap<String, Object> concurrentHashMap = attributes;
                    this.closeSilently(bis);
                    this.closeSilently(ois);
                    return concurrentHashMap;
                }
                String name = (String)ois.readObject();
                Object value = ois.readObject();
                if (!(value instanceof String) || !value.equals(NOT_SERIALIZED)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("  loading attribute '" + name + "' with value '" + value + "'"));
                    }
                    attributes.put(name, value);
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            try {
                LOG.warn((Object)("Caught CNFE decoding " + in.length + " bytes of data"), (Throwable)e);
                throw new RuntimeException("Caught CNFE decoding data", e);
                catch (IOException e2) {
                    LOG.warn((Object)("Caught IOException decoding " + in.length + " bytes of data"), (Throwable)e2);
                    throw new RuntimeException("Caught IOException decoding data", e2);
                }
            }
            catch (Throwable throwable) {
                this.closeSilently(bis);
                this.closeSilently(ois);
                throw throwable;
            }
        }
    }

    private ObjectInputStream createObjectInputStream(ByteArrayInputStream bis) throws IOException {
        Loader loader = null;
        ClassLoader classLoader = null;
        if (this._manager != null && this._manager.getContainer() != null) {
            loader = this._manager.getContainer().getLoader();
        }
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        ObjectInputStream ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream(bis);
        return ois;
    }

    private void closeSilently(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeSilently(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

