/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.VoiceSend;
import com.yunpian.sdk.model.VoiceStatus;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class VoiceApi
extends YunpianApi {
    public static final String NAME = "voice";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.voice.host", "https://voice.yunpian.com"));
    }

    public Result<VoiceSend> send(Map<String, String> param) {
        Result<VoiceSend> r = new Result<VoiceSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "code");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<VoiceSend> h = new YunpianApiResult.MapResultHandler<VoiceSend>(){

            @Override
            public VoiceSend data(Map<String, String> rsp) {
                switch (VoiceApi.this.version()) {
                    case "v1": {
                        return JsonUtil.fromJson(rsp.get("result"), VoiceSend.class);
                    }
                    case "v2": {
                        return VoiceApi.this.map2VoiceResult(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, VoiceApi.this.version());
            }
        };
        try {
            return this.path("send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<VoiceSend> tpl_notify(Map<String, String> param) {
        Result<VoiceSend> r = new Result<VoiceSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "tpl_id", "tpl_value");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<VoiceSend> h = new YunpianApiResult.MapResultHandler<VoiceSend>(){

            @Override
            public VoiceSend data(Map<String, String> rsp) {
                switch (VoiceApi.this.version()) {
                    case "v2": {
                        return VoiceApi.this.map2VoiceResult(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, VoiceApi.this.version());
            }
        };
        try {
            return this.path("tpl_notify.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<VoiceStatus>> pull_status(Map<String, String> param) {
        Result<List<VoiceStatus>> r = new Result<List<VoiceStatus>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<VoiceStatus> h = new YunpianApiResult.SimpleListResultHandler<VoiceStatus>(){

            @Override
            public List<VoiceStatus> data(List<VoiceStatus> rsp) {
                switch (VoiceApi.this.version()) {
                    case "v1": {
                        if (this.rspMap != null) {
                            String flow = (String)this.rspMap.get("voice_status");
                            return (List)JsonUtil.fromJson(flow, new TypeToken<ArrayList<VoiceStatus>>(){}.getType());
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<VoiceStatus> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, VoiceApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<VoiceStatus>>(){}.getType();
            }
        };
        try {
            return this.path("pull_status.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    protected VoiceSend map2VoiceResult(Map<String, String> rsp) {
        if (rsp == null || rsp.isEmpty()) {
            return null;
        }
        try {
            VoiceSend voice = new VoiceSend();
            voice.setCount(rsp.get("count"));
            voice.setFee(Double.parseDouble(rsp.get("fee")));
            voice.setSid(rsp.get("sid"));
            return voice;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
            return null;
        }
    }
}

