/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.constant.Code;
import com.yunpian.sdk.model.CallBill;
import com.yunpian.sdk.model.CallBind;
import com.yunpian.sdk.model.CallRecord;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class CallApi
extends YunpianApi {
    public static final String NAME = "call";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.call.host", "https://call.yunpian.com"));
    }

    public Result<CallBind> bind(Map<String, String> param) {
        Result<CallBind> r = new Result<CallBind>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "from", "duration");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<CallBind> h = new YunpianApiResult.MapResultHandler<CallBind>(){

            @Override
            public CallBind data(Map<String, String> rsp) {
                switch (CallApi.this.version()) {
                    case "v2": {
                        return CallApi.this.map2CallBind(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, CallApi.this.version());
            }
        };
        try {
            return this.path("bind.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Void> unbind(Map<String, String> param) {
        Result<Void> r = new Result<Void>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "from");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Void> h = new YunpianApiResult.MapResultHandler<Void>(){

            @Override
            public Void data(Map<String, String> rsp) {
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, CallApi.this.version());
            }
        };
        try {
            return this.path("unbind.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<CallBill>> pull(Map<String, String> param) {
        Result<List<CallBill>> r = new Result<List<CallBill>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<CallBill> h = new YunpianApiResult.SimpleListResultHandler<CallBill>(){

            @Override
            public List<CallBill> data(List<CallBill> rsp) {
                switch (CallApi.this.version()) {
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<CallBill> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, CallApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<CallBill>>(){}.getType();
            }
        };
        try {
            return this.path("pull.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<CallRecord>> record(Map<String, String> param) {
        Result<List<CallRecord>> r = new Result<List<CallRecord>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "message_id", "start_time", "end_time");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<List<CallRecord>> h = new YunpianApiResult.MapResultHandler<List<CallRecord>>(){

            @Override
            public List<CallRecord> data(Map<String, String> rsp) {
                switch (CallApi.this.version()) {
                    case "v2": {
                        return (List)JsonUtil.fromJson(rsp.get("data"), new TypeToken<List<CallRecord>>(){}.getType());
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, CallApi.this.version());
            }
        };
        try {
            return this.path("record.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Void> get_record(Map<String, String> param, String file) {
        Result<Void> r = new Result<Void>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "message_id", "record_id");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        FileOutputStream fos = null;
        try {
            HttpResponse rsp = this.path("get_record.json").client().post(this.uri(), data).get();
            if (ContentType.APPLICATION_JSON.getMimeType().equals(ContentType.getOrDefault((HttpEntity)rsp.getEntity()).getMimeType())) {
                Map<String, String> rspMap = JsonUtil.fromJsonToMap(EntityUtils.toString((HttpEntity)rsp.getEntity(), (String)this.charset()));
                int code = YunpianApi.code(rspMap, this.version());
                r.setCode(code).setMsg(rspMap.containsKey("msg") ? rspMap.get("msg") : Code.getErrorMsg(code));
            } else {
                File f = new File(file);
                if (f.exists()) {
                    r.setMsg(file + " rewrited");
                } else {
                    f.getParentFile().mkdirs();
                    r.setMsg(file + " created");
                }
                fos = new FileOutputStream(f);
                fos.write(EntityUtils.toByteArray((HttpEntity)rsp.getEntity()));
                fos.flush();
            }
        }
        catch (Exception e) {
            r.setCode(-50);
            r.setThrowable(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        return r;
    }

    protected CallBind map2CallBind(Map<String, String> rsp) {
        if (rsp == null) {
            return null;
        }
        CallBind bind = new CallBind();
        bind.setMessage_id(rsp.get("message_id"));
        bind.setAnonymous_number(rsp.get("anonymous_number"));
        return bind;
    }
}

