/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.License;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.DatasetGroups;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Environment;
import com.supermap.data.ErrorInfo;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PackageType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.ProductType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.ToolkitNative;
import com.supermap.data.Workspace;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.imageio.stream.FileImageOutputStream;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.Region;

public class Toolkit {
    private static final String MEMORY_LICENSE_DATA = "MEMORY_LICENSE_DATA";
    private static final String LICENSE_ISERVER_PRODUCTS = "LICENSE_ISERVER_PRODUCTS";
    private static boolean g_mappingRuntimeMode;
    private static boolean g_spaceRuntimeMode;
    private static boolean g_layoutRuntimeMode;
    private static int m_nPorduction;
    private static ArrayList<com.supermap.ProductType> g_iServerProducts;
    private static ArrayList<com.supermap.ProductType> g_specifiedProducts;
    public static final double DBL_MAX_VALUE = Double.MAX_VALUE;
    public static final double DBL_MIN_VALUE = -1.7976931348623157E308;
    public static final float FLT_MAX_VALUE = Float.MAX_VALUE;
    public static final float FLT_MIN_VALUE = -3.4028235E38f;

    protected Toolkit() {
    }

    public static void freeMemory() {
        ToolkitNative.jni_FreeMemory();
    }

    public static boolean isZero(double value) {
        boolean bl = value >= Environment.getMinEqualZeroPrecision() && value <= Environment.getMaxEqualZeroPrecision();
        return bl;
    }

    public static boolean isZero(double value, double precision) {
        boolean bl = value >= -Math.abs(precision) && value <= Math.abs(precision);
        return bl;
    }

    public static boolean isZero(double value, double minPrecision, double maxPrecision) {
        boolean bl = value >= minPrecision && value <= maxPrecision;
        return bl;
    }

    public static boolean drawToPNG(Geometry geometry, Resources resources, String fileName, Dimension size) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ToolkitNative.jni_DrawGeometryToPNG(geometry.getHandle(), l2, fileName, size.width, size.height);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        return bl;
    }

    public static boolean draw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        Region region = sunGraphics2D.clipRegion;
        int n = sunGraphics2D.transX;
        int n2 = sunGraphics2D.transY;
        int n3 = region.getHiX() - n;
        int n4 = region.getHiY() - n2;
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage(n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        graphics.drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    protected static boolean internalDraw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        boolean bl = false;
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        Region region = sunGraphics2D.clipRegion;
        int n = sunGraphics2D.transX;
        int n2 = sunGraphics2D.transY;
        int n3 = region.getHiX() - n;
        int n4 = region.getHiY() - n2;
        try {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)geometry.getStyle().getMarkerSize().getWidth() + n3 * 4, (int)geometry.getStyle().getMarkerSize().getHeight() + n4 * 4);
                geometry.offset(-rectangle2D.getLeft() + (double)(n3 * 2), -rectangle2D.getBottom() + (double)(n4 * 2));
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + n3 * 2, (int)rectangle2D.getHeight() + n4 * 2);
                geometry.offset(-rectangle2D.getLeft() + (double)(n3 / 2), -rectangle2D.getBottom() + (double)(n4 / 2));
            } else {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
                geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        BufferedImage bufferedImage = new BufferedImage(internalBufferImage.getWidth(), internalBufferImage.getHeight(), 2);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n5 = bufferedImage.getRGB(i, j);
                if (n5 != -16711423) continue;
                bufferedImage.setRGB(i, j, 65793);
            }
        }
        if (bl) {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n3 * 2, (int)rectangle2D.getBottom() - n4 * 2, null);
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n3 / 2, (int)rectangle2D.getBottom() - n4 / 2, null);
            } else {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
        }
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    public static boolean compactDatasource(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource.m_senderMethodName = "compactDatasource";
        datasource.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(datasource);
        boolean bl = ToolkitNative.jni_CompactDatasource(l, datasource.m_selfEventHandle);
        datasource.clearSelfEventHandle();
        if (datasource.getDatasets().getCount() > 0) {
            datasource.getDatasets().reset();
        }
        return bl;
    }

    public static boolean degraRaster(DatasourceConnectionInfo connectionInfo, String strDtName) {
        if (connectionInfo == null || connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return ToolkitNative.jni_DegraUDBRaster(connectionInfo.getHandle(), strDtName);
    }

    public static EncodeType[] getEncodeType(DatasetType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        ArrayList<EncodeType> arrayList = new ArrayList<EncodeType>();
        switch (type.value()) {
            case 3: 
            case 4: 
            case 5: 
            case 205: {
                arrayList.add(EncodeType.BYTE);
                arrayList.add(EncodeType.INT16);
                arrayList.add(EncodeType.INT24);
                arrayList.add(EncodeType.INT32);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 35: 
            case 149: 
            case 153: {
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 81: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.DCT);
                arrayList.add(EncodeType.PNG);
                arrayList.add(EncodeType.COMPOUND);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 83: 
            case 89: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.SGL);
                arrayList.add(EncodeType.NONE);
                break;
            }
            default: {
                arrayList.add(EncodeType.NONE);
            }
        }
        EncodeType[] encodeTypeArray = new EncodeType[arrayList.size()];
        return arrayList.toArray(encodeTypeArray);
    }

    public static ErrorInfo[] getLastErrors(int count) {
        int n;
        if (count < 0) {
            count = 0;
        }
        int n2 = count < (n = ToolkitNative.jni_GetErrorCount()) ? count : n;
        ErrorInfo[] errorInfoArray = new ErrorInfo[n2];
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        ToolkitNative.jni_GetErrorInfos(nArray, stringArray, stringArray2, n, count);
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static void clearErrors() {
        ToolkitNative.jni_ClearErrors();
    }

    public static ErrorInfo[] getAllErrors() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        ErrorInfo[] errorInfoArray = new ErrorInfo[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static String[] getWarnings() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        String[] stringArray3 = new String[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = new String(stringArray2[i]);
        }
        return stringArray3;
    }

    public static String getLastError() {
        return ToolkitNative.jni_GetLastError();
    }

    public static boolean extractCacheFile(String sourceFileName, String targetFolderName) {
        return Toolkit.extractCacheFile(sourceFileName, targetFolderName, "");
    }

    public static boolean extractCacheFile(String sourceFileName, String targetFolderName, String password) {
        if (password == null) {
            password = "";
        }
        boolean bl = false;
        if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
            sourceFileName = sourceFileName.replaceAll("\\\\", "/");
            targetFolderName = targetFolderName.replaceAll("\\\\", "/");
        }
        bl = ToolkitNative.jni_ExtractCacheFile(sourceFileName, targetFolderName, password);
        return bl;
    }

    public static byte[] extractCacheFile2(String sourceFileName, String password) {
        if (password == null) {
            password = "";
        }
        boolean bl = false;
        if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
            sourceFileName = sourceFileName.replaceAll("\\\\", "/");
        }
        byte[] byArray = ToolkitNative.jni_ExtractCacheFile2(sourceFileName, password);
        return byArray;
    }

    public static byte[] extractCacheFiles(String[] sourceFileName, String password) {
        if (password == null) {
            password = "";
        }
        boolean bl = false;
        byte[] byArray = ToolkitNative.jni_ExtractCacheFiles(sourceFileName, password);
        return byArray;
    }

    public static boolean compress(String[] fileNames, String targetFileName, String password, PackageType type) {
        boolean bl = false;
        if (fileNames != null && targetFileName != null) {
            if (password == null) {
                password = "";
            }
            if (type.equals(PackageType.pkg7ZIP)) {
                if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
                    targetFileName = targetFileName.replaceAll("\\\\", "/");
                }
                bl = ToolkitNative.jni_Compress7Zip(fileNames, targetFileName, password);
            }
        }
        return bl;
    }

    public static boolean unCompress(String srcFileName, String targetFolder, String password) {
        boolean bl = false;
        if (srcFileName != null && targetFolder != null) {
            if (password == null) {
                password = "";
            }
            bl = ToolkitNative.jni_UnCompress7Zip(srcFileName, targetFolder, password);
        }
        return bl;
    }

    protected static void setHandleBooleanValue(long handle, boolean value) {
        ToolkitNative.jni_SetBooleanHandle(handle, value);
    }

    protected static boolean getHandleBooleanValue(long handle) {
        return ToolkitNative.jni_GetBooleanHandle(handle);
    }

    protected static void setHandleDoubleValue(long handle, double value) {
        ToolkitNative.jni_SetHandleDoubleValue(handle, value);
    }

    protected static double getHandleDoubleValue(long handle) {
        return ToolkitNative.jni_GetHandleDoubleValue(handle);
    }

    protected static void setHandleIntValue(long handle, int value) {
        ToolkitNative.jni_SetHandleIntValue(handle, value);
    }

    protected static int getHandleIntValue(long handle) {
        return ToolkitNative.jni_GetHandleIntValue(handle);
    }

    protected static String joinString(String[] arr, String connectString) {
        if (arr == null || arr.length == 0 || connectString == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arr.length - 1; ++i) {
            stringBuffer.append(arr[i] + connectString);
        }
        stringBuffer.append(arr[arr.length - 1]);
        return stringBuffer.toString();
    }

    protected static String[] splitString(String value, String splitString) {
        if (value == null || value.trim().equals("") || splitString == null) {
            return new String[0];
        }
        return value.split(splitString);
    }

    static Date parseUGCTime(String ugcTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            return simpleDateFormat.parse(ugcTime);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static String toUGCTime(Date time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(time);
    }

    static boolean isValidEncodeType(boolean isVector, EncodeType encodeType) {
        boolean bl = true;
        if (isVector) {
            if (encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.PNG) || encodeType.equals(EncodeType.COMPOUND)) {
                bl = false;
            }
        } else if (encodeType.equals(EncodeType.BYTE) || encodeType.equals(EncodeType.INT16) || encodeType.equals(EncodeType.INT24) || encodeType.equals(EncodeType.INT32)) {
            bl = false;
        }
        return bl;
    }

    protected static Dataset toManageDataset(Workspace workspace, long datasetHandle) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || datasetHandle == 0L) {
            return null;
        }
        long l = DatasetNative.jni_GetDatasource(datasetHandle);
        String string = null;
        if (l != 0L) {
            string = DatasourceNative.jni_GetAlias(l);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        Dataset dataset = null;
        if (datasource != null) {
            dataset = Toolkit.toManageDataset(datasource, datasetHandle);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return dataset;
    }

    private static Dataset toManageDataset(Datasource datasource, long datasetHandle) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || datasetHandle == 0L) {
            return null;
        }
        String string = DatasetNative.jni_GetName(datasetHandle);
        boolean bl = false;
        long l = 0L;
        boolean bl2 = DatasetNative.jni_GetIsVector(datasetHandle);
        if (bl2) {
            l = DatasetVectorNative.jni_GetParentDataset(datasetHandle);
        }
        String string2 = null;
        if (l != 0L) {
            string2 = DatasetNative.jni_GetName(l);
            bl = true;
        }
        Dataset dataset = null;
        dataset = string2 == null ? datasource.getDatasets().get(string) : datasource.getDatasets().get(string2);
        if (bl && dataset != null) {
            if (dataset.getType() == DatasetType.MOSAIC) {
                if (string.endsWith("_F")) {
                    dataset = ((DatasetMosaic)dataset).getFootprintDataset();
                } else if (string.endsWith("_B")) {
                    dataset = ((DatasetMosaic)dataset).getBoundaryDataset();
                } else if (string.endsWith("_C")) {
                    dataset = ((DatasetMosaic)dataset).getClipDataset();
                }
            } else {
                dataset = ((DatasetVector)dataset).getChildDataset();
            }
        }
        return dataset;
    }

    protected static DatasetGroup toManageDatasetGroup(Workspace workspace, long datasetGroupHandle) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || datasetGroupHandle == 0L) {
            return null;
        }
        long l = DatasetGroupNative.jni_GetDatasource(datasetGroupHandle);
        String string = null;
        if (l != 0L) {
            string = DatasourceNative.jni_GetAlias(l);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        DatasetGroup datasetGroup = null;
        if (datasource != null) {
            datasetGroup = Toolkit.toManageDatasetGroup(datasource, datasetGroupHandle);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return datasetGroup;
    }

    protected static DatasetGroup toManageDatasetGroup(Datasource datasource, long datasetGroupHandle) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || datasetGroupHandle == 0L) {
            return null;
        }
        DatasetGroup datasetGroup = datasource.getRootGroup();
        DatasetGroup datasetGroup2 = Toolkit.findDatasetGroup(datasetGroup, datasetGroupHandle);
        return datasetGroup2;
    }

    private static DatasetGroup findDatasetGroup(DatasetGroup rootGroup, long groupHandle) {
        if (rootGroup == null) {
            return null;
        }
        DatasetGroup datasetGroup = null;
        DatasetGroups datasetGroups = rootGroup.getChildGroups();
        int n = datasetGroups.getCount();
        for (int i = 0; i < n; ++i) {
            DatasetGroup datasetGroup2 = datasetGroups.get(i);
            if (datasetGroup2 == null) continue;
            if (datasetGroup2.getHandle() == groupHandle) {
                return datasetGroup2;
            }
            datasetGroup = Toolkit.findDatasetGroup(datasetGroup2, groupHandle);
            if (datasetGroup == null) continue;
            return datasetGroup;
        }
        return datasetGroup;
    }

    protected static boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    private static void get() {
        String string = System.getenv(MEMORY_LICENSE_DATA);
        if (string != null && !string.isEmpty()) {
            License.setSpecifyLicenseXML(string);
        } else {
            string = System.getProperty(MEMORY_LICENSE_DATA);
            if (string != null && !string.isEmpty()) {
                License.setSpecifyLicenseXML(string);
            }
        }
    }

    private static void getiServerProducts() {
        try {
            String string = System.getenv(LICENSE_ISERVER_PRODUCTS);
            if (string != null && !string.isEmpty()) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    if (string2 == null || string2.isEmpty()) continue;
                    g_iServerProducts.add(com.supermap.ProductType.newInstance(Integer.valueOf(string2.trim())));
                }
            } else {
                string = System.getProperty(LICENSE_ISERVER_PRODUCTS);
                if (string != null && !string.isEmpty()) {
                    String[] stringArray;
                    for (String string3 : stringArray = string.split(",")) {
                        g_iServerProducts.add(com.supermap.ProductType.newInstance(Integer.valueOf(string3.trim())));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static License verifyLicense(ArrayList<com.supermap.ProductType> products) {
        com.supermap.ProductType productType;
        int n = -1;
        Toolkit.get();
        License license = new License();
        String string = "connect types is: ";
        Object object = products.iterator();
        while (object.hasNext() && (n = license.connect(productType = object.next())) != 0) {
            string = string + productType.getUGCValue();
            string = string + " , ";
        }
        if (n != 0) {
            object = License.getErrorMessage(n);
            throw new IllegalStateException(string + (String)object);
        }
        return license;
    }

    protected static void updateStatus() {
        ToolkitNative.jni_updateTrialStatus(Toolkit.getMappingRuntimeLicenseMode(), Toolkit.getLayoutRuntimeLicenseMode(), Toolkit.getSpaceRuntimeLicenseMode());
    }

    protected static ArrayList<com.supermap.ProductType> managerProducts(ArrayList<com.supermap.ProductType> pros) {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        if (g_iServerProducts.isEmpty()) {
            Toolkit.getiServerProducts();
        }
        if (g_iServerProducts.isEmpty()) {
            pros.add(0, com.supermap.ProductType.ISERVER_SERVICES);
            pros.add(0, com.supermap.ProductType.ISERVER_STANDARD);
            pros.add(0, com.supermap.ProductType.ISERVER_PROFESSIONAL);
            pros.add(0, com.supermap.ProductType.ISERVER_ENTERPRISE);
        } else {
            for (com.supermap.ProductType productType : g_iServerProducts) {
                arrayList.add(productType);
            }
        }
        pros.add(0, com.supermap.ProductType.IDESKTOPNET_ADVANCED_GRAPHICS);
        pros.add(0, com.supermap.ProductType.IDESKTOPNET_ENTERPRISE);
        pros.add(0, com.supermap.ProductType.IDESKTOPNET_ADVANCE);
        pros.add(0, com.supermap.ProductType.IDESKTOPJAVA_STANDARD);
        pros.add(0, com.supermap.ProductType.IDESKTOPJAVA_ENTERPRISE);
        pros.add(0, com.supermap.ProductType.IDESKTOPJAVA_ADVANCE);
        pros.add(0, com.supermap.ProductType.IOBJECTS_PYTHON_DEVELOP);
        pros.add(0, com.supermap.ProductType.IOBJECTS_PYTHON_RUNTIME);
        if (!g_specifiedProducts.isEmpty()) {
            for (int i = pros.size() - 1; i >= 0; --i) {
                if (g_specifiedProducts.contains(pros.get(i))) continue;
                pros.remove(i);
            }
        }
        for (com.supermap.ProductType productType : pros) {
            arrayList.add(productType);
        }
        return arrayList;
    }

    @Deprecated
    public static void SetiServerProducts(ArrayList<ProductType> pros) {
        g_iServerProducts.clear();
        for (ProductType productType : pros) {
            g_iServerProducts.add(com.supermap.ProductType.newInstance(productType.getUGCValue()));
        }
    }

    @Deprecated
    public static ArrayList<ProductType> GetiServerProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        for (com.supermap.ProductType productType : g_iServerProducts) {
            arrayList.add(ProductType.newInstance(productType.getUGCValue()));
        }
        return arrayList;
    }

    @Deprecated
    public static void SetSpecifiedProducts(ArrayList<ProductType> pros) {
        g_specifiedProducts.clear();
        for (ProductType productType : pros) {
            g_specifiedProducts.add(com.supermap.ProductType.newInstance(productType.getUGCValue()));
        }
    }

    @Deprecated
    public static ArrayList<ProductType> GetSpecifiedProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        for (com.supermap.ProductType productType : g_specifiedProducts) {
            arrayList.add(ProductType.newInstance(productType.getUGCValue()));
        }
        return arrayList;
    }

    @Deprecated
    public static ArrayList<ProductType> getTrialProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.newInstance(65400));
        arrayList.add(ProductType.newInstance(65401));
        arrayList.add(ProductType.newInstance(65402));
        arrayList.add(ProductType.newInstance(65403));
        arrayList.add(ProductType.newInstance(65404));
        arrayList.add(ProductType.newInstance(65405));
        arrayList.add(ProductType.newInstance(65406));
        arrayList.add(ProductType.newInstance(65407));
        arrayList.add(ProductType.newInstance(65408));
        arrayList.add(ProductType.newInstance(65409));
        arrayList.add(ProductType.newInstance(65410));
        arrayList.add(ProductType.newInstance(65411));
        return arrayList;
    }

    public static void SetiServerProductTypes(ArrayList<com.supermap.ProductType> pros) {
        g_iServerProducts.clear();
        for (com.supermap.ProductType productType : pros) {
            g_iServerProducts.add(productType);
        }
    }

    public static ArrayList<com.supermap.ProductType> GetiServerProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        for (com.supermap.ProductType productType : g_iServerProducts) {
            arrayList.add(productType);
        }
        return arrayList;
    }

    public static void SetSpecifiedProductTypes(ArrayList<com.supermap.ProductType> pros) {
        g_specifiedProducts.clear();
        for (com.supermap.ProductType productType : pros) {
            g_specifiedProducts.add(productType);
        }
    }

    public static ArrayList<com.supermap.ProductType> GetSpecifiedProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        for (com.supermap.ProductType productType : g_specifiedProducts) {
            arrayList.add(productType);
        }
        return arrayList;
    }

    public static ArrayList<com.supermap.ProductType> getTrialProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.newInstance(65400));
        arrayList.add(com.supermap.ProductType.newInstance(65401));
        arrayList.add(com.supermap.ProductType.newInstance(65402));
        arrayList.add(com.supermap.ProductType.newInstance(65403));
        arrayList.add(com.supermap.ProductType.newInstance(65404));
        arrayList.add(com.supermap.ProductType.newInstance(65405));
        arrayList.add(com.supermap.ProductType.newInstance(65406));
        arrayList.add(com.supermap.ProductType.newInstance(65407));
        arrayList.add(com.supermap.ProductType.newInstance(65408));
        arrayList.add(com.supermap.ProductType.newInstance(65409));
        arrayList.add(com.supermap.ProductType.newInstance(65410));
        arrayList.add(com.supermap.ProductType.newInstance(65411));
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getAddressMatchingProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_ADDRESS_MATCHING_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_ADDRESS_MATCHING_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getDataProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_BASIC);
        arrayList.add(com.supermap.ProductType.IOBJECTS_CORE_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_CORE_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getLayoutProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_LAYOUT_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_LAYOUT_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getNetworkAnalystProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_FACILITYNETWORK);
        arrayList.add(com.supermap.ProductType.IOBJECTS_NETWORK_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_NETWORK_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getTrafficAnalystProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_TRAFFICANALYST);
        arrayList.add(com.supermap.ProductType.IOBJECTS_TRAFFIC_ANALYST_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_TRAFFIC_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getSpaceProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPACE_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPACE_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getSpace3DEffectProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_REALSPACEEFFECT);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_EFFECT_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_EFFECT_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getSpatialAnalystProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_SPATIALANALYST);
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_SPATIALSTATISTICSANALYST);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPATIAL_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPATIAL_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getTopologyProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_TOPOLOGY);
        arrayList.add(com.supermap.ProductType.IOBJECTS_TOPOLOGY_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_TOPOLOGY_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getConversionProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_SDX_RUNTIME);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SDX_DEVELOP);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getChartProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.ISERVER_CHART);
        arrayList.add(com.supermap.ProductType.IOBJECTS_CHART_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_CHART_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceSpatialAnalystProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_REALSPACESPATIALANALYST);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceThreeDDesignerProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_3DDESIGNER);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_BUILDER3D_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_BUILDER3D_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceNetworkAnalystProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_REALSPACENETWORKANALYST);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMEVectorProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_VECTOR);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMEEsriProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_ESRI);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMERasterProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_RASTER);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMEOtherProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_OTHER);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getPlot3DProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.ISERVER_PLOT3D);
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_PLOT3D);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PLOT3D_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PLOT3D_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getSituationEvolution3DProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.ISERVER_SITUATIONEVOLUTION3D);
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_SITUATIONEVOLUTION3D);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION3D_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION3D_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getPlot2DProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.ISERVER_PLOT2D);
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_PLOT2D);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PLOT2D_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PLOT2D_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getSituationEvolution2DProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.ISERVER_SITUATIONEVOLUTION2D);
        arrayList.add(com.supermap.ProductType.IDESKTOPJAVA_SITUATIONEVOLUTION2D);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION2D_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION2D_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getJSProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.MOBJECTS_CORE);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_STANDARD);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_PROFESSIONAL);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_ENTERPRISE);
        arrayList.add(com.supermap.ProductType.MSERVER_PROFESSIONAL);
        arrayList.add(com.supermap.ProductType.MSERVER_ENTERPRISE);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyPictureToTempFile(String picturePath, String targetPath, String ... pictrueNames) {
        for (String string : pictrueNames) {
            String string2 = picturePath + string;
            URL uRL = Toolkit.class.getResource(string2);
            if (uRL == null) {
                System.out.println("null");
            }
            String string3 = System.getProperty("os.name");
            String string4 = "";
            string4 = "Windows".indexOf(string3) != -1 ? targetPath + string : targetPath + "/" + string;
            File file = new File(string4);
            InputStream inputStream = null;
            FileImageOutputStream fileImageOutputStream = null;
            if (string4 == null) continue;
            try {
                inputStream = uRL.openStream();
                fileImageOutputStream = new FileImageOutputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("File Not Found!");
                iOException.printStackTrace();
            }
            try {
                int n = 0;
                while ((n = inputStream.read()) != -1) {
                    fileImageOutputStream.write(n);
                }
            }
            catch (IOException iOException) {
                System.out.println("IO write Error");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileImageOutputStream != null) {
                        fileImageOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileToTempFile(String srcPath, String targetPath, String ... fileNames) {
        for (String string : fileNames) {
            String string2 = srcPath + string;
            URL uRL = Class.class.getResource(string2);
            String string3 = targetPath + string;
            File file = new File(string3);
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            if (string3 == null) continue;
            try {
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("File Not Found!");
                iOException.printStackTrace();
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            try {
                String string4 = null;
                while ((string4 = lineNumberReader.readLine()) != null) {
                    fileOutputStream.write(string4.getBytes());
                }
            }
            catch (Exception exception) {
                System.out.println("IO write Error");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error");
                }
            }
        }
    }

    protected static void setMappingRuntimeLicenseMode(boolean licenseMode) {
        g_mappingRuntimeMode = licenseMode;
    }

    protected static boolean getMappingRuntimeLicenseMode() {
        return g_mappingRuntimeMode;
    }

    protected static void setSpaceRuntimeLicenseMode(boolean licenseMode) {
        g_spaceRuntimeMode = licenseMode;
    }

    protected static boolean getSpaceRuntimeLicenseMode() {
        return g_spaceRuntimeMode;
    }

    protected static void setLayoutRuntimeLicenseMode(boolean liceseMode) {
        g_layoutRuntimeMode = liceseMode;
    }

    protected static boolean getLayoutRuntimeLicenseMode() {
        return g_layoutRuntimeMode;
    }

    protected static int getChartLicenseState() {
        return ToolkitNative.jni_getChartLicenseState();
    }

    protected static void setChartLicenseState(int value) {
        ToolkitNative.jni_setChartLicenseState(value);
    }

    protected static int CheckChartLicenseState() {
        License license = new License();
        ToolkitNative.jni_setDrawChartLayer(false);
        int n = -1;
        if (license.connect(com.supermap.ProductType.IOBJECTS_CHART_DEVELOP) == 0 || license.connect(com.supermap.ProductType.IOBJECTS_CHART_RUNTIME) == 0) {
            n = 2;
        } else {
            ArrayList<com.supermap.ProductType> arrayList = Toolkit.getTrialProductTypes();
            int n2 = -1;
            for (com.supermap.ProductType productType : arrayList) {
                n2 = license.connect(productType);
                if (n2 != 0) continue;
                n = 0;
                ToolkitNative.jni_setDrawChartLayer(true);
                break;
            }
        }
        if (license.connect(com.supermap.ProductType.ISERVER_CHART) == 0) {
            n = 0;
            if (m_nPorduction == 0) {
                ToolkitNative.jni_setDrawChartLayer(true);
            }
        }
        license.disconnect();
        license.dispose();
        if (n != -1 && m_nPorduction == 2) {
            ToolkitNative.jni_setDrawChartLayer(true);
        }
        ToolkitNative.jni_setChartLicenseState(n);
        return n;
    }

    protected static void setCurrentProduction(int nType) {
        m_nPorduction = nType;
    }

    protected static int getCurrentProduction() {
        return m_nPorduction;
    }

    public static boolean isEscape(int action, boolean isCursorInMapcontrol) {
        return ToolkitNative.jni_IsEscape(action, isCursorInMapcontrol);
    }

    static void dumpExceptionCallBack(String msg) {
        if (msg != null && !msg.trim().equals("")) {
            throw new RuntimeException(msg);
        }
    }

    public static String ConvertDateTimeToString(Date dateValue, EngineType engineType) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(dateValue);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return ToolkitNative.jni_ConvertDateTimeToString(n, n2, n3, n4, n5, n6, engineType.getUGCValue());
    }

    public static Date ConvertStringToDate(String strDateTime) {
        String string;
        Date date = null;
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        if (pattern.matcher(string = strDateTime).matches()) {
            String string2 = System.getProperty("os.name").toLowerCase();
            if (string2.equals("aix")) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        date = simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException2) {}
                }
            } else {
                try {
                    date = DateFormat.getDateInstance().parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public static boolean CombineBand(String strName, Datasource datasource, Dataset RedDR, Dataset GreenDR, Dataset BlueDR) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (RedDR == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleDisposable.getHandle(RedDR);
        if (l2 == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (GreenDR == null) {
            String string = InternalResource.loadString("GreenDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandleDisposable.getHandle(GreenDR);
        if (l3 == 0L) {
            String string = InternalResource.loadString("GreenDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (BlueDR == null) {
            String string = InternalResource.loadString("BlueDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l4 = InternalHandleDisposable.getHandle(BlueDR);
        if (l4 == 0L) {
            String string = InternalResource.loadString("BlueDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l5 = ToolkitNative.jni_CombineBand(strName, l, l2, l3, l4);
        if (l5 != 0L) {
            DatasetImage datasetImage = new DatasetImage(l5, datasource);
            if (datasetImage != null) {
                datasource.getDatasets().add(datasetImage);
            }
            return true;
        }
        return false;
    }

    public static String[] GetMongoDBNames(String strServer, String strAdminUser, String strAdminPwd) {
        String[] stringArray = null;
        stringArray = ToolkitNative.jni_GetMongoDBNames(strServer, strAdminUser, strAdminPwd);
        if (stringArray == null) {
            String string = InternalResource.loadString("GetMongoDBNames", "Invalid_ArgumentValue", "data_resources");
            throw new RuntimeException(string);
        }
        return stringArray;
    }

    public static String[] GetUserTable(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        stringArray = ToolkitNative.jni_GetUserTable(l);
        if (stringArray == null) {
            String string = InternalResource.loadString("GetUserTable", "Invalid_ArgumentValue", "data_resources");
            throw new RuntimeException(string);
        }
        return stringArray;
    }

    @Deprecated
    public static Geometry WKTToGemetry(String strWKT) {
        long l = ToolkitNative.jni_WKTToUGGemetry(strWKT);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry WKTToGeometry(String strWKT) {
        long l = ToolkitNative.jni_WKTToUGGemetry(strWKT);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static String GemetryToWKT(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToWKT(geometry.getHandle());
        return string;
    }

    public static String GeometryToWKT(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToWKT(geometry.getHandle());
        return string;
    }

    @Deprecated
    public static Geometry GeoJsonToGemetry(String strGeoJson) {
        long l = ToolkitNative.jni_GeoJsonToUGGeometry(strGeoJson);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry GeoJsonToGeometry(String strGeoJson) {
        long l = ToolkitNative.jni_GeoJsonToUGGeometry(strGeoJson);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static String GemetryToGeoJson(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToGeoJson(geometry.getHandle());
        return string;
    }

    public static String GeometryToGeoJson(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToGeoJson(geometry.getHandle());
        return string;
    }

    @Deprecated
    public static Geometry WKBToGemetry(byte[] value) {
        long l = ToolkitNative.jni_WKBToUGGemetry(value);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry WKBToGeometry(byte[] value) {
        long l = ToolkitNative.jni_WKBToUGGemetry(value);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static byte[] GemetryToWKB(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = ToolkitNative.jni_UGGeometryToWKB(geometry.getHandle());
        return byArray;
    }

    public static byte[] GeometryToWKB(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = ToolkitNative.jni_UGGeometryToWKB(geometry.getHandle());
        return byArray;
    }

    public static void SetIsUseCloudLicense(boolean value) {
        ToolkitNative.jni_SetIsUseCloudLicense(value);
    }

    public static void SetCloudLicenseText(String value) {
        ToolkitNative.jni_SetCloudLicenseText(value);
    }

    public static String FormatWKT(String wkt) {
        return ToolkitNative.jni_FormatWKT(wkt);
    }

    public static PrjCoordSys FromWKT(String str) {
        long l = ToolkitNative.jni_FromWKT(str);
        if (l == 0L) {
            return null;
        }
        return PrjCoordSys.createInstance(l, false);
    }

    public static String ToWKT(PrjCoordSys prjCoordSys) {
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("PrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("PrjCoordSys", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_ToWKT(prjCoordSys.getHandle());
    }

    public static boolean IdxTileSplitCell(DatasetVector datasetVector, int totalCount) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_IdxTileSplitCell(l, totalCount);
    }

    public static boolean isValidFieldName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return ToolkitNative.jni_IsValidFieldName(fieldName);
    }

    public static boolean Grid2Image(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dt.m_bTypeChanged = true;
        return ToolkitNative.jni_Grid2Image(l);
    }

    public static boolean Image2Grid(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dt.m_bTypeChanged = true;
        return ToolkitNative.jni_Image2Grid(l);
    }

    public static String GetCachePath(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_GetCachePath(l);
    }

    public static boolean geoMode3DsToKMZ(ArrayList<GeoModel3D> listGeo, String kmlFullPath) {
        boolean bl = false;
        if (listGeo == null) {
            String string = InternalResource.loadString("listGeo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (kmlFullPath == null || kmlFullPath.isEmpty()) {
            String string = InternalResource.loadString("kmlFullPath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(kmlFullPath);
        if (!file.isFile()) {
            String string = InternalResource.loadString("kmlFullPath", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[listGeo.size()];
        for (int i = 0; i < listGeo.size(); ++i) {
            lArray[i] = InternalHandle.getHandle(listGeo.get(i));
        }
        bl = ToolkitNative.jni_GeoMode3DsToKMZ(lArray, kmlFullPath);
        return bl;
    }

    public static boolean convertDatasetCAD2Model(DatasetVector datasetVectorCAD, Datasource datasourceDes, String name) {
        if (datasetVectorCAD == null) {
            String string = InternalResource.loadString("datasetVectorCAD", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(datasetVectorCAD);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVectorCAD", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasourceDes == null) {
            String string = InternalResource.loadString("datasourceDes", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(datasourceDes);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasourceDes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        long l3 = ToolkitNative.jni_ConvertDatasetCAD2Model(l, l2, name);
        if (l3 != 0L) {
            datasourceDes.getDatasets().add(new DatasetVector(l3, datasourceDes));
            bl = true;
        }
        return bl;
    }

    public static byte[] encodeStream(byte[] stream, String password) {
        if (password == null || password.trim().length() == 0) {
            String string = InternalResource.loadString("password", "Global_StringIsNullOrEmpty", "data_resources");
            throw new NullPointerException(string);
        }
        return ToolkitNative.jni_AddRandomStream(stream, password);
    }

    public static byte[] decodeStream(byte[] stream, String password) {
        if (password == null || password.trim().length() == 0) {
            String string = InternalResource.loadString("password", "Global_StringIsNullOrEmpty", "data_resources");
            throw new NullPointerException(string);
        }
        return ToolkitNative.jni_AddRandomStream(stream, password);
    }

    public static void setDtNameAsTableName(boolean value) {
        ToolkitNative.jni_SetDtNameAsTableName(value);
    }

    public static boolean getDtNameAsTableName() {
        return ToolkitNative.jni_GetDtNameAsTableName();
    }

    public static void setDSAutoVacuum(boolean value) {
        ToolkitNative.jni_SetDSAutoVacuum(value);
    }

    public static boolean getDSAutoVacuum() {
        return ToolkitNative.jni_GetDSAutoVacuum();
    }

    public static void setCalcAreaLength(boolean value) {
        ToolkitNative.jni_SetCalcAreaLength(value);
    }

    public static boolean getCalcAreaLength() {
        return ToolkitNative.jni_GetCalcAreaLength();
    }

    public static boolean vectorReSample(Dataset dataset, QueryParameter queryParameter, Datasource datasource, String[] datasetNames, double[] resolutions, boolean value) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = dataset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = queryParameter.getHandle();
        if (l2 == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            datasource = dataset.getDatasource();
        }
        long l3 = datasource.getHandle();
        return ToolkitNative.jni_VectorReSample(l, l2, l3, datasetNames, resolutions, value);
    }

    static {
        Environment.LoadWrapJ();
        g_mappingRuntimeMode = true;
        g_spaceRuntimeMode = true;
        g_layoutRuntimeMode = true;
        m_nPorduction = 2;
        g_iServerProducts = new ArrayList();
        g_specifiedProducts = new ArrayList();
        License.setUGOBasePath(Environment.getUGOBasePath());
    }
}

