/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoText;
import com.supermap.data.GeoTextNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.TextPartNative;

public class TextPart
extends InternalHandleDisposable {
    private Point2D m_anchorPoint = null;
    private GeoText m_geoText = null;

    public TextPart() {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public TextPart(TextPart part) {
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (part.m_geoText != null) {
            int n = part.m_geoText.getTextPartsList().indexOf(part);
            if (n == -1) {
                String string = InternalResource.loadString("TextPart(TextPart part)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            l = GeoTextNative.jni_GetSubHandle(part.m_geoText.getHandle(), n);
        } else {
            l = part.getHandle();
        }
        long l2 = TextPartNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setAnchorPoint(part.getAnchorPoint());
        part.makeSureNativeObjectLive();
    }

    public TextPart(String text, Point2D anchorPoint) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset(anchorPoint, 0.0, text);
    }

    public TextPart(String text, Point2D anchorPoint, double rotation) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset(anchorPoint, rotation, text);
    }

    public TextPart(String text, double x, double y, double rotation) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        Point2D point2D = new Point2D(x, y);
        this.reset(point2D, rotation, text);
    }

    TextPart(GeoText geoText, int index) {
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_GetSubHandle(geoText.getHandle(), index);
        this.setHandle(l, false);
        this.m_geoText = geoText;
        geoText.makeSureNativeObjectLive();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TextPartNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            return GeoTextNative.jni_GetSubRotation(this.m_geoText.getHandle(), n);
        }
        return TextPartNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double rotation) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double rotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            GeoTextNative.jni_SetSubRotation(this.m_geoText.getHandle(), rotation, n);
        } else {
            TextPartNative.jni_SetRotation(this.getHandle(), rotation);
        }
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            return GeoTextNative.jni_GetSubText(this.m_geoText.getHandle(), n);
        }
        return TextPartNative.jni_GetText(this.getHandle());
    }

    public void setText(String text) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setText(String text)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (text == null) {
            text = "";
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            GeoTextNative.jni_SetSubText(this.m_geoText.getHandle(), text, n);
        } else {
            TextPartNative.jni_SetText(this.getHandle(), text);
        }
    }

    public Point2D getAnchorPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return new Point2D(dArray[0], dArray[1]);
        }
        return this.m_anchorPoint;
    }

    public void setAnchorPoint(Point2D anchorPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnchorPoint(Point2D anchorPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this.m_geoText.getHandle(), anchorPoint.getX(), anchorPoint.getY(), n);
        } else {
            this.m_anchorPoint = anchorPoint.clone();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return dArray[0];
        }
        return this.m_anchorPoint.getX();
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return dArray[1];
        }
        return this.m_anchorPoint.getY();
    }

    public void setX(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this.m_geoText.getHandle(), x, this.getY(), n);
        } else {
            this.m_anchorPoint.setX(x);
        }
    }

    public void setY(double y) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this.m_geoText.getHandle(), this.getX(), y, n);
        } else {
            this.m_anchorPoint.setY(y);
        }
    }

    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = this.getX() + dx;
        double d2 = this.getY() + dy;
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this.m_geoText.getHandle(), d, d2, n);
        } else {
            this.m_anchorPoint.setX(d);
            this.m_anchorPoint.setY(d2);
        }
    }

    public TextPart clone() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null && (n = this.m_geoText.getTextPartsList().indexOf(this)) == -1) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TextPart(this);
    }

    void reset() {
        this.reset(new Point2D(0.0, 0.0), 0.0, "");
    }

    void reset(Point2D anchorPoint, double rotation, String text) {
        this.setAnchorPoint(anchorPoint);
        this.setRotation(rotation);
        this.setText(text);
    }
}

