/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolGroupNative;
import com.supermap.data.SymbolGroups;
import com.supermap.data.SymbolLibrary;
import java.util.ArrayList;

public class SymbolGroup
extends InternalHandleDisposable {
    private SymbolLibrary m_symbolLibrary;
    private SymbolGroup m_parentSymbolGroup;
    private SymbolGroups m_symbolGroups;
    private ArrayList m_symbols;

    SymbolGroup(SymbolLibrary symbolLibrary, long handle) {
        this.m_symbolLibrary = symbolLibrary;
        this.setHandle(handle, false);
        this.m_symbols = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolLibrary);
    }

    SymbolGroup(long handle, SymbolGroup symbolGroup) {
        this.m_symbolLibrary = symbolGroup.getLib();
        this.setHandle(handle, false);
        this.setParent(symbolGroup);
        this.m_symbols = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolGroup);
    }

    public SymbolGroup getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parentSymbolGroup;
    }

    public SymbolGroups getChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildGroups()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_symbolGroups == null) {
            this.m_symbolGroups = new SymbolGroups(this);
        }
        return this.m_symbolGroups;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getParent() != null && this.getParent().getChildGroups().contains(name)) {
            String string = InternalResource.loadString("value", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroupNative.jni_SetName(this.getHandle(), name);
    }

    public Symbol get(int index) {
        Symbol symbol = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= 0 && index < this.m_symbols.size()) {
            symbol = (Symbol)this.m_symbols.get(index);
        }
        return symbol;
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_symbolLibrary;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_IndexOf(this.getHandle(), id);
    }

    protected boolean moveTo(int index, SymbolGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (group == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(group);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = SymbolGroupNative.jni_moveTo(this.getHandle(), index, l);
        if (bl) {
            group.getSymbols().add(this.get(index));
            this.get(index).setGroup(group);
            this.getSymbols().remove(index);
        }
        group.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
    }

    @Override
    protected void clearHandle() {
        this.m_symbolLibrary = null;
        this.m_symbolLibrary = null;
        this.m_parentSymbolGroup = null;
        if (this.m_symbolGroups != null) {
            this.m_symbolGroups.clearHandle();
            this.m_symbolGroups = null;
        }
        if (this.m_symbols != null) {
            for (int i = 0; i < this.m_symbols.size(); ++i) {
                ((Symbol)this.m_symbols.get(i)).clearHandle();
            }
            this.m_symbols.clear();
            this.m_symbols = null;
        }
        this.setHandle(0L);
    }

    void setParent(SymbolGroup symbolGroup) {
        this.m_parentSymbolGroup = symbolGroup;
    }

    void reset() {
        int n;
        for (n = 0; n < this.m_symbols.size(); ++n) {
            ((Symbol)this.m_symbols.get(n)).clearHandle();
        }
        this.m_symbols.clear();
        n = this.getCount();
        if (n > 0) {
            long[] lArray = new long[n];
            SymbolGroupNative.jni_GetSymbols(this.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                Symbol symbol = Symbol.createInstance(lArray[i]);
                if (symbol == null) continue;
                symbol.setIsDisposable(false);
                symbol.setLibrary(this.m_symbolLibrary);
                symbol.setGroup(this);
                this.m_symbols.add(symbol);
            }
        }
        if (this.m_symbolGroups != null) {
            this.m_symbolGroups.reset();
        }
    }

    ArrayList getSymbols() {
        return this.m_symbols;
    }

    SymbolLibrary getLib() {
        return this.m_symbolLibrary;
    }

    boolean remove(int id) {
        int n = this.indexOf(id);
        if (n != -1) {
            this.getSymbols().remove(n);
            return SymbolGroupNative.jni_RemoveByID(this.getHandle(), id);
        }
        int n2 = 0;
        if (n2 < this.m_symbolGroups.getCount()) {
            return this.m_symbolGroups.get(n2).remove(id);
        }
        return false;
    }

    SymbolGroup findGroup(int id) {
        SymbolGroup symbolGroup = null;
        if (this.indexOf(id) != -1) {
            return this;
        }
        for (int i = 0; i < this.getChildGroups().getCount(); ++i) {
            symbolGroup = this.getChildGroups().get(i).findGroup(id);
            if (symbolGroup == null) continue;
            return symbolGroup;
        }
        return symbolGroup;
    }

    Symbol findSymbol(int id) {
        int n;
        Symbol symbol = null;
        for (n = 0; n < this.getCount(); ++n) {
            symbol = this.get(n);
            if (symbol == null || symbol.getID() != id) continue;
            return symbol;
        }
        for (n = 0; n < this.getChildGroups().getCount(); ++n) {
            symbol = this.getChildGroups().get(n).findSymbol(id);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    Symbol findSymbol(String name) {
        int n;
        Symbol symbol = null;
        for (n = 0; n < this.getCount(); ++n) {
            symbol = this.get(n);
            if (symbol == null || !symbol.getName().equals(name)) continue;
            return symbol;
        }
        for (n = 0; n < this.getChildGroups().getCount(); ++n) {
            symbol = this.getChildGroups().get(n).findSymbol(name);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }
}

