/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolFillNative;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SymbolFill
extends Symbol {
    SymbolFill(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            SymbolLibrary symbolLibrary = this.getLibrary();
            long l2 = 0L;
            if (symbolLibrary != null) {
                l2 = symbolLibrary.getHandle();
            }
            if (bl = SymbolFillNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry.getHandle(), l2)) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
            symbolLibrary.makeSureNativeObjectLive();
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = new GeoRegion(points);
        Rectangle2D rectangle2D = geoRegion.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoRegion.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
        Point2Ds point2Ds = geoRegion.getPart(0);
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        SymbolLibrary symbolLibrary = this.getLibrary();
        long l = 0L;
        if (symbolLibrary != null) {
            l = symbolLibrary.getHandle();
        }
        if (bl = style == null ? SymbolFillNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, 0L, l) : SymbolFillNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, style.getHandle(), l)) {
            graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
        }
        symbolLibrary.makeSureNativeObjectLive();
        internalBufferImage.makeSureNativeObjectLive();
        style.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Point2Ds points, GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), points, style);
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        return bl;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.FILL;
    }

    public boolean saveTilingImage(String filename, SymbolFillLibrary library, int index, Color front, Color back) {
        if (this.getHandle() == 0L || library == null || library.getHandle() == 0L) {
            String string = InternalResource.loadString("saveTilingImage()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillNative.jni_SaveTilingImage(this.getHandle(), filename, library.getHandle(), index, front.getRGB(), back.getRGB());
    }
}

