/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3DNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;

public abstract class Geometry3D
extends Geometry {
    private GeoStyle3D m_style3D = null;
    private boolean m_setStyle = false;
    private BoundingBox m_boundingBox = null;

    protected Geometry3D() {
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetPosition(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public void setPosition(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPosition(Point3D point)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point.getZ();
        Geometry3DNative.jni_SetPosition(this.getHandle(), d, d2, d3);
    }

    public GeoStyle3D getStyle3D() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_style3D == null && (l = Geometry3DNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_style3D = GeoStyle3D.createInstance(l);
        }
        return this.m_style3D;
    }

    public void setStyle3D(GeoStyle3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_style3D != null) {
                this.m_style3D.clearHandle();
                this.m_style3D = null;
            }
            Geometry3DNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle3D geoStyle3D = value.clone();
            Geometry3DNative.jni_SetStyle(this.getHandle(), geoStyle3D.getHandle());
        }
        this.m_setStyle = true;
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public double getRotationX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[0];
    }

    public void setRotationX(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationX(this.getHandle(), x);
    }

    public double getRotationY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[1];
    }

    public void setRotationY(double y) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationY(this.getHandle(), y);
    }

    public double getRotationZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[2];
    }

    public void setRotationZ(double z) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationZ(double z)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationZ(this.getHandle(), z);
    }

    public double getScaleX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[0];
    }

    public void setScaleX(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (x <= 0.0) {
            String string = InternalResource.loadString("x", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleX(this.getHandle(), x);
    }

    public double getScaleY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[1];
    }

    public void setScaleY(double y) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (y <= 0.0) {
            String string = InternalResource.loadString("y", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleY(this.getHandle(), y);
    }

    public double getScaleZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[2];
    }

    public void setScaleZ(double z) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleZ(double z)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (z <= 0.0) {
            String string = InternalResource.loadString("z", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleZ(this.getHandle(), z);
    }

    public BoundingBox getBoundingBox() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundingBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_boundingBox == null && (l = Geometry3DNative.jni_GetBoundingBox(this.getHandle())) != 0L) {
            this.m_boundingBox = new BoundingBox(l);
        }
        BoundingBox boundingBox = new BoundingBox(this.m_boundingBox);
        Rectangle2D rectangle2D = this.getBounds();
        boundingBox.setLower(new Point3D(rectangle2D.getLeft(), rectangle2D.getBottom(), boundingBox.getLower().getZ()));
        boundingBox.setUpper(new Point3D(rectangle2D.getRight(), rectangle2D.getTop(), boundingBox.getUpper().getZ()));
        return boundingBox;
    }

    public Point3D getInnerPoint3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetInnerPoint3D(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return Geometry3DNative.jni_GetVolume(this.getHandle());
    }

    public void offset(double dx, double dy, double dz) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy, double dz)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_Offset(this.getHandle(), dx, dy, dz);
    }

    @Deprecated
    public GeoModel getGeoModel(int slices, int stacks) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoModel(int slices, int stacks)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (slices <= 0 || stacks <= 0) {
            String string = InternalResource.loadString("getGeoModel(int slices, int stacks)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = Geometry3DNative.jni_GetGeoModel(this.getHandle(), slices, stacks);
        GeoModel geoModel = null;
        if (l != 0L) {
            geoModel = new GeoModel(l);
        }
        return geoModel;
    }

    public GeoModel3D convertToGeoModel3D(boolean bLonLat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToGeoModel3D(boolean bLonLat)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = Geometry3DNative.jni_ConvertToGeoModel3D(this.getHandle(), bLonLat, 0);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)Geometry.internalCreateInstance(l);
            if (this.m_style3D != null && this.m_style3D.getHandle() != 0L) {
                geoModel3D.setStyle3D(this.m_style3D);
            }
        }
        return geoModel3D;
    }

    public GeoModel3D convertToGeoModel3D(boolean bLonLat, int nResolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToGeoModel3D(boolean bLonLat)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = Geometry3DNative.jni_ConvertToGeoModel3D(this.getHandle(), bLonLat, nResolution);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)Geometry.internalCreateInstance(l);
            if (this.m_style3D != null && this.m_style3D.getHandle() != 0L) {
                geoModel3D.setStyle3D(this.m_style3D);
            }
        }
        return geoModel3D;
    }
}

