/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.util.ArrayList;

public class GeoRegion3D
extends Geometry3D {
    private ArrayList<Point3Ds> m_geoRegion3DParts;

    public GeoRegion3D() {
        super.setHandle(GeoRegion3DNative.jni_New(), true);
        this.m_geoRegion3DParts = new ArrayList();
    }

    public GeoRegion3D(Point3Ds points) {
        this();
        this.addPart(points);
    }

    public GeoRegion3D(GeoRegion3D region3D) {
        if (region3D == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (region3D.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegion3DNative.jni_Clone(region3D.getHandle());
        super.setHandle(l, true);
        this.m_geoRegion3DParts = new ArrayList();
        for (int i = 0; i < region3D.getPartsList().size(); ++i) {
            Point3Ds point3Ds = region3D.getPartsList().get(i);
            this.m_geoRegion3DParts.add(point3Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(region3D);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegion3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPerimeter(this.getHandle());
    }

    public int addPart(Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds = new Point3Ds(this.getPartFromUGC(n2));
        Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
        this.m_geoRegion3DParts.add(point3Ds2);
        return n2;
    }

    public GeoLine3D convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine3D geoLine3D = new GeoLine3D();
        for (int i = 0; i < this.getPartCount(); ++i) {
            geoLine3D.addPart(this.getPart(i));
        }
        geoLine3D.setIsDisposable(true);
        return geoLine3D;
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegion3DNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.m_geoRegion3DParts.remove(index);
        }
        return bl;
    }

    public Point3Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_geoRegion3DParts.get(index);
    }

    public boolean insertPart(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        if (index == this.getPartCount()) {
            int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
            Point3Ds point3Ds = new Point3Ds(this.getPartFromUGC(n2));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.m_geoRegion3DParts.add(index, point3Ds2);
            return n2 != -1;
        }
        boolean bl = GeoRegion3DNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2, dArray3);
        Point3Ds point3Ds = new Point3Ds(this.getPartFromUGC(index));
        Point3Ds point3Ds3 = new Point3Ds(point3Ds, this);
        this.m_geoRegion3DParts.add(index, point3Ds3);
        return bl;
    }

    @Override
    public void offset(double dx, double dy, double dz) {
        super.offset(dx, dy, dz);
        this.refrashPartsList();
    }

    public boolean setPart(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), index, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds = this.m_geoRegion3DParts.get(index);
            Point3Ds point3Ds2 = new Point3Ds(this.getPartFromUGC(index));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this.m_geoRegion3DParts.set(index, point3Ds3);
            point3Ds.setUserType(Point3Ds.UserType.NONE);
        }
        return bl;
    }

    boolean setPartJustToUGC(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), index, dArray, dArray2, dArray3);
        return bl;
    }

    public int indexOf(Point3Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_geoRegion3DParts.indexOf(part);
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_geoRegion3DParts != null) {
            this.m_geoRegion3DParts.clear();
            this.m_geoRegion3DParts = null;
        }
        this.setHandle(0L);
    }

    ArrayList<Point3Ds> getPartsList() {
        return this.m_geoRegion3DParts;
    }

    private Point3D[] getPartFromUGC(int index) {
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = GeoRegion3DNative.jni_GetPartPointCount(this.getHandle(), index);
        if (n > 2) {
            Point3D[] point3DArray = new Point3D[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            GeoRegion3DNative.jni_GetPart(this.getHandle(), index, dArray, dArray2, dArray3);
            for (int i = 0; i < n; ++i) {
                point3DArray[i] = new Point3D(dArray[i], dArray2[i], dArray3[i]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoRegion3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion3DNative.jni_Clear(this.getHandle());
        this.m_geoRegion3DParts.clear();
    }

    GeoRegion3D(long handle) {
        this.setHandle(handle, false);
        this.m_geoRegion3DParts = new ArrayList();
        this.refrashPartsList();
    }

    void refrashPartsList() {
        int n = this.getPartCount();
        this.m_geoRegion3DParts.clear();
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = new Point3Ds(this.getPartFromUGC(i));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.m_geoRegion3DParts.add(point3Ds2);
        }
    }
}

