/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoParametricRegionNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoParametricRegion
extends Geometry {
    private ArrayList<Geometry> m_geoPartsList;

    public GeoParametricRegion() {
        long l = GeoParametricRegionNative.jni_New();
        this.setHandle(l, true);
        this.m_geoPartsList = new ArrayList();
    }

    GeoParametricRegion(long handle) {
        if (0L != handle) {
            this.setHandle(handle, false);
            this.m_geoPartsList = new ArrayList();
            GeoParametricRegion.refreshFromUGC1(this);
        }
    }

    public GeoParametricRegion(GeoParametricRegion geoParametricRegion) {
        if (geoParametricRegion == null) {
            String string = InternalResource.loadString("GeoParametricRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParametricRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParametricRegion", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoParametricRegionNative.jni_Clone(l);
        this.m_geoPartsList = new ArrayList();
        this.setHandle(l2, true);
        GeoParametricRegion.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricRegion);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionNative.jni_getPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionNative.jni_getArea(this.getHandle());
    }

    public int add(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoParametricRegionNative.jni_add(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.m_geoPartsList.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.m_geoPartsList.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionNative.jni_getCount(this.getHandle());
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_geoPartsList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_geoPartsList.get(index);
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.m_geoPartsList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricRegionNative.jni_set(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this.m_geoPartsList.get(index);
            geometry3.clearHandle();
            this.m_geoPartsList.remove(index);
            this.m_geoPartsList.add(index, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    @Override
    public GeoParametricRegion clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoParametricRegion(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParametricRegionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricRegionNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this.m_geoPartsList.size(); ++i) {
            this.m_geoPartsList.get(i).setIsDisposable(true);
            this.m_geoPartsList.get(i).setHandle(0L);
            this.m_geoPartsList.get(i).clearHandle();
        }
        this.m_geoPartsList.clear();
    }

    static void refreshFromUGC1(GeoParametricRegion geoCompound) {
        int n = geoCompound.getCount();
        long[] lArray = new long[n];
        GeoParametricRegionNative.jni_AllGeometrys(geoCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoCompound.m_geoPartsList.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    void refrashPartsList() {
        for (int i = 0; i < this.m_geoPartsList.size(); ++i) {
            Geometry geometry;
            if (this.m_geoPartsList.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this.m_geoPartsList.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this.m_geoPartsList.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this.m_geoPartsList.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoParametricRegion creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoParametricRegion(handle);
    }
}

