/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoMapGridLineType;
import com.supermap.data.GeoMapGridNative;
import com.supermap.data.GeoMapGridType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.HorizontalTextPositionType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextStyle;
import com.supermap.data.VerticalTextPositionType;

public class GeoMapGrid
extends Geometry {
    private GeoStyle m_gridLineStyle;
    private GeoStyle m_borderLineStyle;
    private GeoStyle m_majorLineStyle;
    private GeoStyle m_minorLineStyle;
    private TextStyle m_gridLineTextStyle;

    public GeoMapGrid() {
        long l = GeoMapGridNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMapGrid(GeoMapGrid geoMapGrid) {
        if (geoMapGrid == null) {
            String string = InternalResource.loadString("GeoMapGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoMapGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapGridNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapGrid);
    }

    GeoMapGrid(long handle) {
        this.setHandle(handle, false);
    }

    public GeoMapGridType getGridType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridType(this.getHandle());
        return (GeoMapGridType)Enum.parseUGCValue(GeoMapGridType.class, n);
    }

    public void setGridType(GeoMapGridType gridType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridType(GeoMapGridType gridType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (gridType == null) {
            String string = InternalResource.loadString("gridType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = gridType.value();
        GeoMapGridNative.jni_SetGridType(this.getHandle(), n);
    }

    public double getVerticalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetVerticalGridDistance(this.getHandle());
    }

    public void setVerticalGridDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_VerticalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetVerticalGridDistance(this.getHandle(), value);
    }

    public double getHorizontalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetHorizontalGridDistance(this.getHandle());
    }

    public void setHorizontalGridDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_HorizontalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetHorizontalGridDistance(this.getHandle(), value);
    }

    public GeoStyle getGridLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_gridLineStyle == null && (l = GeoMapGridNative.jni_GetGridLineStyle(this.getHandle())) != 0L) {
            this.m_gridLineStyle = new GeoStyle(l);
        }
        return this.m_gridLineStyle;
    }

    public void setGridLineStyle(GeoStyle lineStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (lineStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (lineStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineStyle(this.getHandle(), lineStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(lineStyle);
    }

    public GeoStyle getBorderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBorderLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_borderLineStyle == null && (l = GeoMapGridNative.jni_GetBorderLineStyle(this.getHandle())) != 0L) {
            this.m_borderLineStyle = new GeoStyle(l);
        }
        return this.m_borderLineStyle;
    }

    public void setBorderLineStyle(GeoStyle lineStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (lineStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (lineStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetBorderLineStyle(this.getHandle(), lineStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(lineStyle);
    }

    public GeoMapGridLineType getGridLineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridLineType(this.getHandle());
        return (GeoMapGridLineType)Enum.parseUGCValue(GeoMapGridLineType.class, n);
    }

    public void setGridLineType(GeoMapGridLineType gridLineType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineType(GeoMapGridLineType gridLineType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (gridLineType == null) {
            String string = InternalResource.loadString("GeoMapGridLineType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = gridLineType.value();
        GeoMapGridNative.jni_SetGridLineType(this.getHandle(), n);
    }

    public boolean isMajorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMajorDivisionTicksVisible(this.getHandle());
    }

    public void setMajorDivisionTicksVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksVisible(this.getHandle(), value);
    }

    public GeoStyle getMajorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMajorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_majorLineStyle == null && (l = GeoMapGridNative.jni_GetMajorDivisionTicksStyle(this.getHandle())) != 0L) {
            this.m_majorLineStyle = new GeoStyle(l);
        }
        return this.m_majorLineStyle;
    }

    public void setMajorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public boolean isMinorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMinorDivisionTicksVisible(this.getHandle());
    }

    public void setMinorDivisionTicksVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksVisible(this.getHandle(), value);
    }

    public GeoStyle getMinorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_minorLineStyle == null && (l = GeoMapGridNative.jni_GetMinorDivisionTicksStyle(this.getHandle())) != 0L) {
            this.m_minorLineStyle = new GeoStyle(l);
        }
        return this.m_minorLineStyle;
    }

    public void setMinorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getMinorDivisionTicksCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetMinorDivisionTicksCount(this.getHandle());
    }

    public void setMinorDivisionTicksCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksCount(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_MinorDivisionTicksCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksCount(this.getHandle(), value);
    }

    public HorizontalTextPositionType getHorizontalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetHorizontalTextPositionType(this.getHandle());
        return (HorizontalTextPositionType)Enum.parseUGCValue(HorizontalTextPositionType.class, n);
    }

    public void setHorizontalTextPosition(HorizontalTextPositionType positionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalTextPositionType(HorizontalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (positionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = positionType.value();
        GeoMapGridNative.jni_SetHorizontalTextPositionType(this.getHandle(), n);
    }

    public VerticalTextPositionType getVerticalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetVerticalTextPositionType(this.getHandle());
        return (VerticalTextPositionType)Enum.parseUGCValue(VerticalTextPositionType.class, n);
    }

    public void setVerticalTextPosition(VerticalTextPositionType positionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalTextPositionType(VerticalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (positionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = positionType.value();
        GeoMapGridNative.jni_SetVerticalTextPositionType(this.getHandle(), n);
    }

    public TextStyle getGridLineTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_gridLineTextStyle == null && (l = GeoMapGridNative.jni_GetGridLineTextStyle(this.getHandle())) != 0L) {
            this.m_gridLineTextStyle = new TextStyle(l);
        }
        return this.m_gridLineTextStyle;
    }

    public void setGridLineTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    @Override
    public GeoMapGrid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapGrid(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapGridNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_gridLineStyle != null) {
            this.m_gridLineStyle.clearHandle();
            this.m_gridLineStyle = null;
        }
        if (this.m_borderLineStyle != null) {
            this.m_borderLineStyle.clearHandle();
            this.m_borderLineStyle = null;
        }
        if (this.m_majorLineStyle != null) {
            this.m_majorLineStyle.clearHandle();
            this.m_majorLineStyle = null;
        }
        if (this.m_minorLineStyle != null) {
            this.m_minorLineStyle.clearHandle();
            this.m_minorLineStyle = null;
        }
        if (this.m_gridLineTextStyle != null) {
            this.m_gridLineTextStyle.clearHandle();
            this.m_gridLineTextStyle = null;
        }
        this.setHandle(0L);
    }
}

