/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Enum {
    private final int m_value;
    private final int m_ugcValue;
    private static boolean m_isCustom;
    protected static HashMap<Class<?>, ArrayList<Enum>> m_hashMap;
    protected static HashMap<Class<?>, Field[]> m_allEnumsFields;

    public static final String[] getNames(Class type) {
        if (type == null) {
            return new String[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, arrayList, null, null);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static int[] getValues(Class type) {
        if (type == null) {
            return new int[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new int[0];
        }
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, arrayList, null);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = Integer.parseInt(arrayList.get(i).toString());
        }
        return nArray;
    }

    public static int[] getPredefineValues(Class type) {
        if (type == null) {
            return new int[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new int[0];
        }
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, arrayList, null, true);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = Integer.parseInt(arrayList.get(i).toString());
        }
        return nArray;
    }

    public static Enum[] getEnums(Class type) {
        if (type == null) {
            return new Enum[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new Enum[0];
        }
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, null, arrayList);
        Enum[] enumArray = new Enum[arrayList.size()];
        arrayList.toArray(enumArray);
        return enumArray;
    }

    public static String getNameByValue(Class type, int value) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, arrayList, arrayList2, null);
        Integer n = value;
        if (!arrayList2.contains(n)) {
            String string = InternalResource.loadString("ugcValue", "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        int n2 = arrayList2.indexOf(n);
        return (String)arrayList.get(n2);
    }

    public static int getValueByName(Class type, String name) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, arrayList, arrayList2, null);
        if (!arrayList.contains(name)) {
            String string = InternalResource.loadString("ugcValue", "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        int n = arrayList.indexOf(name);
        return Integer.parseInt(arrayList2.get(n).toString());
    }

    public static Enum parse(Class type, int value) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, arrayList, arrayList2);
        Integer n = value;
        if (!arrayList.contains(n)) {
            String string = InternalResource.loadString("ugcValue", "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        int n2 = arrayList.indexOf(n);
        return (Enum)arrayList2.get(n2);
    }

    public static Enum parse(Class type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, arrayList, null, arrayList2);
        if (!arrayList.contains(name)) {
            String string = InternalResource.loadString("ugcValue", "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        int n = arrayList.indexOf(name);
        return (Enum)arrayList2.get(n);
    }

    public static boolean isDefined(Class type, int value) {
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, arrayList, null);
        Integer n = value;
        return arrayList.contains(n);
    }

    public static boolean isDefined(Class type, String name) {
        ArrayList arrayList = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, arrayList, null, null);
        return arrayList.contains(name);
    }

    protected Enum(int value, int ugcValue) {
        this.m_value = value;
        this.m_ugcValue = ugcValue;
    }

    protected static final int internalGetUGCValue(Enum e) {
        return e.getUGCValue();
    }

    protected static final Enum internalParseUGCValue(Class type, int ugcValue) {
        return Enum.parseUGCValue(type, ugcValue);
    }

    static final Enum parseUGCValue(Class type, int ugcValue) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, arrayList2, arrayList);
        Integer n = ugcValue;
        if (!arrayList2.contains(n)) {
            String string = InternalResource.loadString("ugcValue:" + ugcValue, "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        int n2 = arrayList2.indexOf(n);
        return (Enum)arrayList.get(n2);
    }

    private static final boolean isValidEnumField(Field field) {
        if (field == null) {
            return false;
        }
        Class<?> clazz = field.getDeclaringClass();
        if (!field.getType().equals(clazz)) {
            return false;
        }
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
    }

    protected static void getEnumNameValueAndEntry(Class type, ArrayList names, ArrayList values, ArrayList entries) {
        Enum.getEnumNameValueAndEntry(type, names, values, entries, false);
    }

    private static void getEnumNameValueAndEntry(Class type, ArrayList names, ArrayList values, ArrayList entries, boolean onlyPredefine) {
        Serializable illegalArgumentException;
        Class<?> clazz;
        if (type == null) {
            return;
        }
        if (names == null && values == null && entries == null) {
            return;
        }
        Field[] fieldArray = null;
        if (m_allEnumsFields.containsKey(type)) {
            fieldArray = m_allEnumsFields.get(type);
        } else {
            fieldArray = type.getFields();
            m_allEnumsFields.put(type, fieldArray);
        }
        if (fieldArray == null || fieldArray.length == 0) {
            return;
        }
        for (Field entry : fieldArray) {
            if (!Enum.isValidEnumField(entry)) continue;
            clazz = null;
            try {
                clazz = (Enum)entry.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                continue;
            }
            if (clazz == null) continue;
            if (names != null) {
                names.add(entry.getName());
            }
            if (values != null) {
                illegalArgumentException = Integer.valueOf(((Enum)((Object)clazz)).value());
                values.add(illegalArgumentException);
            }
            if (entries == null) continue;
            entries.add(clazz);
        }
        if (!onlyPredefine && m_isCustom) {
            for (Map.Entry<Class<?>, ArrayList<Enum>> entry : m_hashMap.entrySet()) {
                clazz = entry.getKey();
                if (!clazz.getName().equals(type.getName())) continue;
                illegalArgumentException = entry.getValue();
                for (int i = 0; i < ((ArrayList)illegalArgumentException).size(); ++i) {
                    Enum enum_ = (Enum)((ArrayList)illegalArgumentException).get(i);
                    if (names != null) {
                        names.add(String.valueOf(enum_.value()));
                    }
                    if (values != null) {
                        values.add(enum_.value());
                    }
                    if (entries == null) continue;
                    entries.add(enum_);
                }
            }
        }
    }

    private static boolean isValidEnumClass(Class type) {
        if (type == null) {
            return false;
        }
        return type.getSuperclass().equals(Enum.class);
    }

    public final String name() {
        return Enum.getNameByValue(this.getClass(), this.value());
    }

    public final int value() {
        return this.m_value;
    }

    public String toString() {
        return String.valueOf(this.name());
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Enum enum_ = (Enum)other;
        return this.value() == enum_.value();
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    final int getUGCValue() {
        return this.m_ugcValue;
    }

    protected void setCustom(boolean value) {
        m_isCustom = value;
    }

    static {
        m_hashMap = new HashMap();
        m_allEnumsFields = new HashMap();
    }
}

