/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetCreatedEvent;
import com.supermap.data.DatasetCreatedListener;
import com.supermap.data.DatasetDeletedAllEvent;
import com.supermap.data.DatasetDeletedAllListener;
import com.supermap.data.DatasetDeletedEvent;
import com.supermap.data.DatasetDeletedListener;
import com.supermap.data.DatasetDeletingAllEvent;
import com.supermap.data.DatasetDeletingAllListener;
import com.supermap.data.DatasetDeletingEvent;
import com.supermap.data.DatasetDeletingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetGridCollectionInfo;
import com.supermap.data.DatasetGridInfo;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageCollectionInfo;
import com.supermap.data.DatasetImageInfo;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetRenamedEvent;
import com.supermap.data.DatasetRenamedListener;
import com.supermap.data.DatasetRenamingEvent;
import com.supermap.data.DatasetRenamingListener;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetTopologyInfo;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.DatasetVolume;
import com.supermap.data.DatasetVolumeInfo;
import com.supermap.data.DatasetsNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class Datasets {
    private transient ArrayList<Dataset> m_datasets = null;
    private transient Map<String, Integer> m_mapNameAndIndex = null;
    private transient ReentrantLock lock = new ReentrantLock();
    private transient Datasource m_datasource = null;
    transient CopyOnWriteArrayList<DatasetRenamingListener> m_datasetRenamingListeners;
    transient CopyOnWriteArrayList<DatasetRenamedListener> m_datasetRenamedListeners;
    transient CopyOnWriteArrayList<DatasetDeletingListener> m_datasetDeletingListeners;
    transient CopyOnWriteArrayList<DatasetDeletedListener> m_datasetDeletedListeners;
    transient CopyOnWriteArrayList<DatasetDeletingAllListener> m_datasetDeletingAllListeners;
    transient CopyOnWriteArrayList<DatasetDeletedAllListener> m_datasetDeletedAllListeners;
    transient CopyOnWriteArrayList<DatasetCreatedListener> m_datasetCreatedListeners;

    protected Datasets() {
    }

    Datasets(Datasource datasource) {
        this.clearHandle();
        this.m_datasets = new ArrayList();
        this.m_mapNameAndIndex = new HashMap<String, Integer>();
        this.m_datasource = datasource;
        this.reset();
    }

    public int getCount() {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("getCount()", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_datasets.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset get(String name) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("get(String name)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = null;
            int n = this.indexOf(name);
            if (n != -1) {
                dataset = this.get(n);
            }
            Dataset dataset2 = dataset;
            return dataset2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Dataset get(int index) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("get(int index)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (index < 0 || index >= this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            Dataset dataset = this.m_datasets.get(index);
            return dataset;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Datasource getDatasource() {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("getDatasource()", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            Datasource datasource = this.m_datasource;
            return datasource;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector createAndAppendWithSmid(String name, Recordset recordset) {
        this.lock.lock();
        try {
            InternalHandle internalHandle;
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (recordset == null) {
                String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (recordset.getHandle() == 0L) {
                String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(name, recordset.getDataset());
            if (!Datasets.isCreatableVectorType(datasetVectorInfo.getType())) {
                String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.isCreatableEnCodeType(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
                String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVector datasetVector = null;
            if (datasetVectorInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetVectorInfo.getName())) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if ((datasetVectorInfo.getType() == DatasetType.PARAMETRICLINE || datasetVectorInfo.getType() == DatasetType.PARAMETRICREGION) && this.m_datasource.getEngineType() != EngineType.SQLPLUS && this.m_datasource.getEngineType() != EngineType.ORACLEPLUS && this.m_datasource.getEngineType() != EngineType.UDB) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_FailToCreateBecauseOfType", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetVector(this.m_datasource.getHandle(), datasetVectorInfo.getHandle());
            if (l != 0L) {
                datasetVector = new DatasetVector(l, this.m_datasource);
                datasetVector.setPrjCoordSys(recordset.getDataset().getPrjCoordSys());
                internalHandle = recordset.getFieldInfos();
                for (int i = 0; i < ((FieldInfos)internalHandle).getCount(); ++i) {
                    if (((FieldInfos)internalHandle).get(i).isSystemField() || ((FieldInfos)internalHandle).get(i).getName().equalsIgnoreCase("SmUserID")) continue;
                    datasetVector.getFieldInfos().add(((FieldInfos)internalHandle).get(i));
                }
                DatasetVectorNative.jni_AppendWithSmID(datasetVector.getHandle(), recordset.getHandle());
                this.add(datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetVectorInfo);
            internalHandle = datasetVector;
            return internalHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector create(DatasetVectorInfo datasetInfo) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (datasetInfo == null) {
                String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (datasetInfo.getHandle() == 0L) {
                String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.isCreatableEnCodeType(datasetInfo.getType(), datasetInfo.getEncodeType())) {
                String string = InternalResource.loadString("value", "DatasetVectorInfo_IllegalEncodeType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.isCreatableVectorType(datasetInfo.getType())) {
                String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.isCreatableEnCodeType(datasetInfo.getType(), datasetInfo.getEncodeType())) {
                String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVector datasetVector = null;
            if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if ((datasetInfo.getType() == DatasetType.PARAMETRICLINE || datasetInfo.getType() == DatasetType.PARAMETRICREGION) && this.m_datasource.getEngineType() != EngineType.SQLPLUS && this.m_datasource.getEngineType() != EngineType.ORACLEPLUS && this.m_datasource.getEngineType() != EngineType.UDB) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_FailToCreateBecauseOfType", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetVector(this.m_datasource.getHandle(), datasetInfo.getHandle());
            if (l != 0L) {
                datasetVector = new DatasetVector(l, this.m_datasource);
                this.add(datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGrid create(DatasetGridInfo datasetInfo) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetGridInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (datasetInfo == null) {
                String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (datasetInfo.getHandle() == 0L) {
                String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetInfo.getWidth() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetGrid_WidthShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (datasetInfo.getHeight() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetGrid_HeightShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.isCreatableEnCodeType(DatasetType.GRID, datasetInfo.getEncodeType())) {
                String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGrid datasetGrid = null;
            if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
                String string = InternalResource.loadString("datasetInfo.name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetRaster(this.m_datasource.getHandle(), datasetInfo.getHandle(), false);
            if (l != 0L) {
                datasetGrid = new DatasetGrid(l, this.m_datasource);
                this.add(datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVolume create(DatasetVolumeInfo datasetInfo) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetGridInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (datasetInfo == null) {
                String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (datasetInfo.getHandle() == 0L) {
                String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetInfo.getWidth() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetGrid_WidthShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (datasetInfo.getHeight() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetGrid_HeightShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVolume datasetVolume = null;
            if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
                String string = InternalResource.loadString("datasetInfo.name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetRaster(this.m_datasource.getHandle(), datasetInfo.getHandle(), true);
            if (l != 0L) {
                datasetVolume = new DatasetVolume(l, this.m_datasource);
                this.add(datasetVolume);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
            DatasetVolume datasetVolume2 = datasetVolume;
            return datasetVolume2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetImage create(DatasetImageInfo datasetInfo) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetImageInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (datasetInfo == null) {
                String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (datasetInfo.getHandle() == 0L) {
                String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetInfo.getWidth() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetImage_WidthShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetInfo.getHeight() <= 0) {
                String string = InternalResource.loadString("datasetInfo", "DatasetImage_HeightShouldBePositive", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImage datasetImage = null;
            if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetRaster(this.m_datasource.getHandle(), datasetInfo.getHandle(), true);
            if (l != 0L) {
                datasetImage = new DatasetImage(l, this.m_datasource);
                this.add(datasetImage);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
            DatasetImage datasetImage2 = datasetImage;
            return datasetImage2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetTopology create(DatasetTopologyInfo datasetInfo) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (datasetInfo == null) {
                String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            DatasetTopology datasetTopology = null;
            if (!this.isAvailableDatasetName(datasetInfo.getName())) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetTopology(this.m_datasource.getHandle(), datasetInfo.getName());
            if (l != 0L) {
                datasetTopology = new DatasetTopology(l, this.m_datasource);
                this.add(datasetTopology);
            }
            DatasetTopology datasetTopology2 = datasetTopology;
            return datasetTopology2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGridCollection createGridCollection(String name, PixelFormat pixFormat) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            DatasetGridCollection datasetGridCollection = null;
            if (name.equals("") || !this.isAvailableDatasetName(name)) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGridCollectionInfo datasetGridCollectionInfo = new DatasetGridCollectionInfo();
            datasetGridCollectionInfo.setName(name);
            datasetGridCollectionInfo.setPixelFormat(pixFormat);
            long l = DatasetsNative.jni_CreateCollection(this.m_datasource.getHandle(), datasetGridCollectionInfo.getHandle());
            if (l != 0L) {
                datasetGridCollection = new DatasetGridCollection(l, this.m_datasource);
                this.add(datasetGridCollection);
            }
            datasetGridCollectionInfo.dispose();
            DatasetGridCollection datasetGridCollection2 = datasetGridCollection;
            return datasetGridCollection2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGridCollection createGridCollection(DatasetGridCollectionInfo info) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            DatasetGridCollection datasetGridCollection = null;
            long l = DatasetsNative.jni_CreateCollection(this.m_datasource.getHandle(), info.getHandle());
            if (l != 0L) {
                datasetGridCollection = new DatasetGridCollection(l, this.m_datasource);
                this.add(datasetGridCollection);
            }
            DatasetGridCollection datasetGridCollection2 = datasetGridCollection;
            return datasetGridCollection2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetImageCollection createImageCollection(String name) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            DatasetImageCollection datasetImageCollection = null;
            if (name.equals("") || !this.isAvailableDatasetName(name)) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageCollectionInfo datasetImageCollectionInfo = new DatasetImageCollectionInfo();
            datasetImageCollectionInfo.setName(name);
            long l = DatasetsNative.jni_CreateCollection(this.m_datasource.getHandle(), datasetImageCollectionInfo.getHandle());
            if (l != 0L) {
                datasetImageCollection = new DatasetImageCollection(l, this.m_datasource);
                this.add(datasetImageCollection);
            }
            datasetImageCollectionInfo.dispose();
            DatasetImageCollection datasetImageCollection2 = datasetImageCollection;
            return datasetImageCollection2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetImageCollection createImageCollection(DatasetImageCollectionInfo info) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            DatasetImageCollection datasetImageCollection = null;
            long l = DatasetsNative.jni_CreateCollection(this.m_datasource.getHandle(), info.getHandle());
            if (l != 0L) {
                datasetImageCollection = new DatasetImageCollection(l, this.m_datasource);
                this.add(datasetImageCollection);
            }
            DatasetImageCollection datasetImageCollection2 = datasetImageCollection;
            return datasetImageCollection2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createFromTemplate(String name, Dataset templateDataset) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("createFromTemplate(String name, Dataset templateDataset)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (name == null || name.trim().length() == 0) {
                String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!this.isAvailableDatasetName(name)) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (templateDataset.getHandle() == 0L) {
                String string = InternalResource.loadString("templateDataset", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = null;
            long l = DatasetsNative.jni_CreateDatasetFromTemplate(this.m_datasource.getHandle(), name, templateDataset.getHandle());
            if (l != 0L) {
                dataset = Dataset.createInstance(l, templateDataset.getType(), this.m_datasource);
                this.add(dataset);
            }
            Dataset dataset2 = dataset;
            return dataset2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name) {
        this.lock.lock();
        try {
            int n;
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("delete(String name)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            int n2 = this.indexOf(name);
            if (-1 == n2) {
                boolean bl = true;
                return bl;
            }
            Dataset dataset = this.get(n2);
            DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, name);
            this.fireDeleting(datasetDeletingEvent);
            if (datasetDeletingEvent.getCancel()) {
                boolean bl = false;
                return bl;
            }
            int n3 = 0;
            n3 = this.m_datasource.getEngineType() == EngineType.ORACLEPLUS ? DatasetsNative.jni_DeleteDatasetEx(this.m_datasource.getHandle(), name) : DatasetsNative.jni_DeleteDataset2(this.m_datasource.getHandle(), name);
            if (n3 != 0) {
                if (this.m_datasource.getEngineType() == EngineType.ORACLEPLUS) {
                    dataset.setIsDisposable(true);
                } else {
                    dataset.clearHandle();
                }
                this.m_datasets.remove(n2);
                this.m_mapNameAndIndex.clear();
                for (n = 0; n < this.m_datasets.size(); ++n) {
                    this.m_mapNameAndIndex.put(this.m_datasets.get(n).getName().toUpperCase(), n);
                }
            }
            if (n3 != 0) {
                DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, name);
                this.fireDeleted(datasetDeletedEvent);
            }
            n = n3;
            return n != 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int index) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("delete(int index)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (index < 0 || index >= this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            Dataset dataset = this.get(index);
            String string = dataset.getName();
            DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, string);
            this.fireDeleting(datasetDeletingEvent);
            if (datasetDeletingEvent.getCancel()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            bl = this.m_datasource.getEngineType() == EngineType.ORACLEPLUS ? DatasetsNative.jni_DeleteDatasetEx(this.m_datasource.getHandle(), dataset.getName()) : DatasetsNative.jni_DeleteDataset(this.m_datasource.getHandle(), index);
            if (bl) {
                if (this.m_datasource.getEngineType() == EngineType.ORACLEPLUS) {
                    dataset.setIsDisposable(true);
                } else {
                    dataset.clearHandle();
                }
                this.m_datasets.remove(index);
                this.m_mapNameAndIndex.clear();
                for (int i = 0; i < this.m_datasets.size(); ++i) {
                    this.m_mapNameAndIndex.put(this.m_datasets.get(i).getName().toUpperCase(), i);
                }
                DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, string);
                this.fireDeleted(datasetDeletedEvent);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("deleteAll()", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            DatasetDeletingAllEvent datasetDeletingAllEvent = new DatasetDeletingAllEvent(this);
            this.fireDeletingAll(datasetDeletingAllEvent);
            if (datasetDeletingAllEvent.getCancel()) {
                return;
            }
            DatasetsNative.jni_DeleteAll(this.m_datasource.getHandle());
            int n = this.getCount();
            Dataset dataset = null;
            for (int i = 0; i < n; ++i) {
                dataset = this.get(i);
                dataset.clearHandle();
            }
            this.m_datasets.clear();
            this.m_mapNameAndIndex.clear();
            DatasetDeletedAllEvent datasetDeletedAllEvent = new DatasetDeletedAllEvent(this, n);
            this.fireDeletedAll(datasetDeletedAllEvent);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableDatasetName(String name) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = false;
            if (name != null && name.trim().length() != 0) {
                bl = DatasetsNative.jni_IsAvailableDatasetName(this.m_datasource.getHandle(), name);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableDatasetName(String name, DatasetType datasetType) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (datasetType == null) {
                String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            boolean bl = false;
            if (name != null && name.trim().length() != 0) {
                bl = DatasetsNative.jni_IsAvailableDatasetName2(this.m_datasource.getHandle(), name, datasetType.getUGCValue());
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getAvailableDatasetName(String name) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (name == null) {
                name = "";
            }
            String string = DatasetsNative.jni_GetUnoccupiedDatasetName(this.m_datasource.getHandle(), name);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableDatasetName(String name, DatasetType datasetType) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (name == null) {
                name = "";
            }
            if (datasetType == null) {
                String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            String string = DatasetsNative.jni_GetUnoccupiedDatasetName2(this.m_datasource.getHandle(), name, datasetType.getUGCValue());
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String oldName, String newName) {
        this.lock.lock();
        try {
            Dataset dataset;
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasource.isReadOnly()) {
                String string = InternalResource.loadString("rename(String oldName, String newName)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (oldName == null || oldName.trim().length() == 0) {
                String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (newName == null || newName.trim().length() == 0) {
                String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (oldName.equalsIgnoreCase(newName)) {
                boolean bl = false;
                return bl;
            }
            Integer n = this.m_mapNameAndIndex.get(oldName.toUpperCase());
            int n2 = -1;
            if (n != null) {
                n2 = n;
            }
            if ((dataset = this.get(n2)) == null) {
                String string = InternalResource.loadString("oldName", "Global_SpecifiedNameNotExist", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_mapNameAndIndex.get(newName.toUpperCase()) != null) {
                String string = InternalResource.loadString("newName", "Global_SpecifiedNameAlreadyExist", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetRenamingEvent datasetRenamingEvent = new DatasetRenamingEvent(this, oldName, newName);
            this.fireRenaming(datasetRenamingEvent);
            boolean bl = false;
            if (datasetRenamingEvent.getCancel()) {
                boolean bl2 = false;
                return bl2;
            }
            bl = dataset.rename(newName);
            if (bl) {
                this.m_mapNameAndIndex.remove(oldName.toUpperCase());
                this.m_mapNameAndIndex.put(newName.toUpperCase(), n2);
            }
            if (bl) {
                DatasetRenamedEvent datasetRenamedEvent = new DatasetRenamedEvent(this, oldName, newName);
                this.fireRenamed(datasetRenamedEvent);
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = false;
            if (this.m_mapNameAndIndex.get(name.toUpperCase()) != null) {
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(String name) {
        this.lock.lock();
        try {
            Integer n;
            int n2 = -1;
            if (name != null && name.trim().length() != 0 && (n = this.m_mapNameAndIndex.get(name.toUpperCase())) != null) {
                n2 = n;
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String name) {
        this.lock.lock();
        try {
            if (name != null && name.trim().length() != 0) {
                int n = this.indexOf(name);
                Dataset dataset = this.m_datasets.get(n);
                if (this.m_datasource.getEngineType() == EngineType.ORACLEPLUS || this.m_datasource.getEngineType() == EngineType.POSTGRESQL) {
                    dataset.setIsDisposable(true);
                }
                this.m_datasets.remove(n);
                this.m_mapNameAndIndex.clear();
                for (int i = 0; i < this.m_datasets.size(); ++i) {
                    this.m_mapNameAndIndex.put(this.m_datasets.get(i).getName().toUpperCase(), i);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(ArrayList<String> listName) {
        this.lock.lock();
        try {
            int n;
            for (n = 0; n < listName.size(); ++n) {
                String string = listName.get(n);
                if (string == null || string.trim().length() == 0) continue;
                int n2 = this.indexOf(string);
                Dataset dataset = this.m_datasets.get(n2);
                if (this.m_datasource.getEngineType() == EngineType.ORACLEPLUS || this.m_datasource.getEngineType() == EngineType.POSTGRESQL) {
                    dataset.setIsDisposable(true);
                }
                this.m_datasets.remove(n2);
            }
            this.m_mapNameAndIndex.clear();
            for (n = 0; n < this.m_datasets.size(); ++n) {
                this.m_mapNameAndIndex.put(this.m_datasets.get(n).getName().toUpperCase(), n);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static boolean isCreatableVectorType(DatasetType type) {
        boolean bl = true;
        if (type.equals(DatasetType.LINKTABLE) || type.equals(DatasetType.NETWORK) || type.equals(DatasetType.GRID) || type.equals(DatasetType.IMAGE) || type.equals(DatasetType.WCS) || type.equals(DatasetType.WMS) || type.equals(DatasetType.TOPOLOGY)) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableEnCodeType(DatasetType type, EncodeType encodeType) {
        boolean bl = true;
        if (type.equals(DatasetType.TABULAR) || type.equals(DatasetType.POINT) || type.equals(DatasetType.PARAMETRICLINE) || type.equals(DatasetType.PARAMETRICREGION)) {
            bl = bl && encodeType.equals(EncodeType.NONE);
        } else if (Datasets.isCreatableVectorType(type)) {
            bl = bl && !encodeType.equals(EncodeType.DCT);
            bl = bl && !encodeType.equals(EncodeType.SGL);
            bl = bl && !encodeType.equals(EncodeType.LZW);
        } else if (type.equals(DatasetType.GRID) || type.equals(DatasetType.WCS) || type.equals(DatasetType.WMS)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW);
        } else if (type.equals(DatasetType.IMAGE)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.COMPOUND);
        }
        return bl;
    }

    void clearHandle() {
        this.lock.lock();
        try {
            if (this.m_datasets != null) {
                int n = this.m_datasets.size();
                for (int i = 0; i < n; ++i) {
                    if (this.m_datasets.get(i) == null) continue;
                    this.m_datasets.get(i).clearHandle();
                }
                this.m_datasets.clear();
                this.m_datasets = null;
                this.m_mapNameAndIndex.clear();
            }
            this.m_datasource = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Dataset dataset) {
        this.lock.lock();
        try {
            String string = dataset.getName();
            if (this.contains(string)) {
                return;
            }
            this.m_datasets.add(dataset);
            this.m_mapNameAndIndex.put(dataset.getName().toUpperCase(), this.m_datasets.size() - 1);
            DatasetCreatedEvent datasetCreatedEvent = new DatasetCreatedEvent(this, dataset.getName());
            this.fireCreated(datasetCreatedEvent);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected static void add(Datasets datasets, Dataset dataset) {
        if (datasets != null) {
            datasets.add(dataset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.lock.lock();
        try {
            this.m_datasets.clear();
            this.m_mapNameAndIndex.clear();
            int n = DatasourceNative.jni_GetDatasetsCount(this.m_datasource.getHandle());
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            DatasourceNative.jni_GetDatasets(this.m_datasource.getHandle(), lArray, nArray);
            for (int i = 0; i < n; ++i) {
                DatasetType datasetType;
                try {
                    datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
                }
                catch (RuntimeException runtimeException) {
                    if (nArray[i] == 88) {
                        datasetType = DatasetType.IMAGE;
                    }
                    if (nArray[i] == 89) {
                        datasetType = DatasetType.GRID;
                    }
                    if (nArray[i] == 90) {
                        datasetType = DatasetType.DEM;
                    }
                    if (nArray[i] != DatasetType.DEM.getUGCValue()) continue;
                    datasetType = DatasetType.DEM;
                }
                try {
                    Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this.m_datasource);
                    if (dataset == null) continue;
                    this.m_datasets.add(dataset);
                    this.m_mapNameAndIndex.put(dataset.getName().toUpperCase(), this.m_datasets.size() - 1);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    ArrayList getList() {
        return this.m_datasets;
    }

    private boolean isValid() {
        boolean bl = true;
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        this.lock.lock();
        try {
            int n;
            int n2 = this.m_datasets.size();
            int n3 = DatasourceNative.jni_GetDatasetsCount(this.m_datasource.getHandle());
            long[] lArray = new long[n3];
            int[] nArray = new int[n3];
            DatasourceNative.jni_GetDatasets(this.m_datasource.getHandle(), lArray, nArray);
            for (n = 0; n < n3; ++n) {
                DatasetType datasetType;
                if (this.m_datasets.size() > n) {
                    if (this.m_datasets.get(n).getHandle() == lArray[n]) continue;
                    this.m_datasets.get(n).clearHandle();
                    this.m_datasets.remove(n);
                }
                try {
                    datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[n]);
                }
                catch (RuntimeException runtimeException) {
                    if (nArray[n] == 88) {
                        datasetType = DatasetType.IMAGE;
                    }
                    if (nArray[n] == 89) {
                        datasetType = DatasetType.GRID;
                    }
                    if (nArray[n] == 90) {
                        datasetType = DatasetType.GRID;
                    }
                    if (nArray[n] != DatasetType.DEM.getUGCValue()) continue;
                    datasetType = DatasetType.GRID;
                }
                try {
                    Dataset dataset = Dataset.createInstance(lArray[n], datasetType, this.m_datasource);
                    if (dataset == null) continue;
                    this.m_datasets.add(dataset);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.m_mapNameAndIndex.clear();
            for (n = 0; n < this.m_datasets.size(); ++n) {
                this.m_mapNameAndIndex.put(this.m_datasets.get(n).getName().toUpperCase(), n);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRenamingListener(DatasetRenamingListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamingListeners == null) {
                this.m_datasetRenamingListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetRenamingListeners.contains(l)) {
                this.m_datasetRenamingListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeRenamingListener(DatasetRenamingListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamingListeners != null && this.m_datasetRenamingListeners.contains(l)) {
                this.m_datasetRenamingListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRenaming(DatasetRenamingEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamingListeners != null) {
                CopyOnWriteArrayList<DatasetRenamingListener> copyOnWriteArrayList = this.m_datasetRenamingListeners;
                int n = copyOnWriteArrayList.size();
                for (int i = 0; i < n; ++i) {
                    copyOnWriteArrayList.get(i).datasetRenaming(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRenamedListener(DatasetRenamedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamedListeners == null) {
                this.m_datasetRenamedListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetRenamedListeners.contains(l)) {
                this.m_datasetRenamedListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeRenamedListener(DatasetRenamedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamedListeners != null && this.m_datasetRenamedListeners.contains(l)) {
                this.m_datasetRenamedListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRenamed(DatasetRenamedEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetRenamedListeners != null) {
                CopyOnWriteArrayList<DatasetRenamedListener> copyOnWriteArrayList = this.m_datasetRenamedListeners;
                for (DatasetRenamedListener datasetRenamedListener : copyOnWriteArrayList) {
                    datasetRenamedListener.datasetRenamed(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeletingListener(DatasetDeletingListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingListeners == null) {
                this.m_datasetDeletingListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetDeletingListeners.contains(l)) {
                this.m_datasetDeletingListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDeletingListener(DatasetDeletingListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingListeners != null && this.m_datasetDeletingListeners.contains(l)) {
                this.m_datasetDeletingListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeleting(DatasetDeletingEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingListeners != null) {
                CopyOnWriteArrayList<DatasetDeletingListener> copyOnWriteArrayList = this.m_datasetDeletingListeners;
                for (DatasetDeletingListener datasetDeletingListener : copyOnWriteArrayList) {
                    datasetDeletingListener.datasetDeleting(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeletedListener(DatasetDeletedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedListeners == null) {
                this.m_datasetDeletedListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetDeletedListeners.contains(l)) {
                this.m_datasetDeletedListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDeletedListener(DatasetDeletedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedListeners != null && this.m_datasetDeletedListeners.contains(l)) {
                this.m_datasetDeletedListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeleted(DatasetDeletedEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedListeners != null) {
                CopyOnWriteArrayList<DatasetDeletedListener> copyOnWriteArrayList = this.m_datasetDeletedListeners;
                for (DatasetDeletedListener datasetDeletedListener : copyOnWriteArrayList) {
                    datasetDeletedListener.DatasetDeleted(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeletingAllListener(DatasetDeletingAllListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingAllListeners == null) {
                this.m_datasetDeletingAllListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetDeletingAllListeners.contains(l)) {
                this.m_datasetDeletingAllListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDeletingAllListener(DatasetDeletingAllListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingAllListeners != null && this.m_datasetDeletingAllListeners.contains(l)) {
                this.m_datasetDeletingAllListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeletingAll(DatasetDeletingAllEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletingAllListeners != null) {
                CopyOnWriteArrayList<DatasetDeletingAllListener> copyOnWriteArrayList = this.m_datasetDeletingAllListeners;
                for (DatasetDeletingAllListener datasetDeletingAllListener : copyOnWriteArrayList) {
                    datasetDeletingAllListener.datasetDeletingAll(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeletedAllListener(DatasetDeletedAllListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedAllListeners == null) {
                this.m_datasetDeletedAllListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetDeletedAllListeners.contains(l)) {
                this.m_datasetDeletedAllListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDeletedAllListener(DatasetDeletedAllListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedAllListeners != null && this.m_datasetDeletedAllListeners.contains(l)) {
                this.m_datasetDeletedAllListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeletedAll(DatasetDeletedAllEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetDeletedAllListeners != null) {
                CopyOnWriteArrayList<DatasetDeletedAllListener> copyOnWriteArrayList = this.m_datasetDeletedAllListeners;
                for (DatasetDeletedAllListener datasetDeletedAllListener : copyOnWriteArrayList) {
                    datasetDeletedAllListener.datasetDeletedAll(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCreatedListener(DatasetCreatedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetCreatedListeners == null) {
                this.m_datasetCreatedListeners = new CopyOnWriteArrayList();
            }
            if (!this.m_datasetCreatedListeners.contains(l)) {
                this.m_datasetCreatedListeners.add(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeCreatedListener(DatasetCreatedListener l) {
        this.lock.lock();
        try {
            if (this.m_datasetCreatedListeners != null && this.m_datasetCreatedListeners.contains(l)) {
                this.m_datasetCreatedListeners.remove(l);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreated(DatasetCreatedEvent event) {
        this.lock.lock();
        try {
            if (this.m_datasetCreatedListeners != null) {
                CopyOnWriteArrayList<DatasetCreatedListener> copyOnWriteArrayList = this.m_datasetCreatedListeners;
                for (DatasetCreatedListener datasetCreatedListener : copyOnWriteArrayList) {
                    datasetCreatedListener.datasetCreated(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRange(String[] addNames) {
        this.lock.lock();
        try {
            long[] lArray = new long[addNames.length];
            int[] nArray = new int[addNames.length];
            DatasourceNative.jni_GetAddDatasets(this.m_datasource.getHandle(), lArray, nArray, addNames);
            for (int i = 0; i < addNames.length; ++i) {
                DatasetType datasetType;
                try {
                    datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
                }
                catch (RuntimeException runtimeException) {
                    if (nArray[i] == 88) {
                        datasetType = DatasetType.IMAGE;
                    }
                    if (nArray[i] == 90) {
                        datasetType = DatasetType.DEM;
                    }
                    if (nArray[i] == DatasetType.DEM.getUGCValue()) {
                        datasetType = DatasetType.DEM;
                    }
                    this.lock.unlock();
                    return;
                }
                try {
                    Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this.m_datasource);
                    if (dataset == null) continue;
                    this.m_datasets.add(dataset);
                    this.m_mapNameAndIndex.put(dataset.getName().toUpperCase(), this.m_datasets.size() - 1);
                    DatasetCreatedEvent datasetCreatedEvent = new DatasetCreatedEvent(this, addNames[i]);
                    this.fireCreated(datasetCreatedEvent);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dataset getDatasetByTableName(String tableName) {
        this.lock.lock();
        try {
            Dataset dataset = null;
            int n = this.getCount();
            for (int i = 0; i < n; ++i) {
                if (!this.m_datasets.get(i).getTableName().equals(tableName)) continue;
                dataset = this.m_datasets.get(i);
                break;
            }
            Dataset dataset2 = dataset;
            return dataset2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DatasetVector SetExpTable(String strName) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVector datasetVector = null;
        long l = DatasetsNative.jni_SetExpTable(this.m_datasource.getHandle(), strName);
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.m_datasource);
            this.add(datasetVector);
        }
        return datasetVector;
    }

    public DatasetMosaic createDatasetMosaic(String name, PrjCoordSys prjCoordSys) {
        long l;
        if (!this.isValid()) {
            String string = InternalResource.loadString("create(DatasetMosaic datasetMosaic)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasource.isReadOnly()) {
            String string = InternalResource.loadString("readOnly", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.contains(name)) {
            String string = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (prjCoordSys != null) {
            l2 = prjCoordSys.getHandle();
        }
        if ((l = DatasetsNative.jni_CreateDatasetMosaic(this.m_datasource.getHandle(), name, l2)) == 0L) {
            return null;
        }
        DatasetMosaic datasetMosaic = new DatasetMosaic(l, this.m_datasource);
        this.add(datasetMosaic);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetMosaic);
        return datasetMosaic;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }
}

