/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AttributeStatisticsType;
import com.supermap.data.Charset;
import com.supermap.data.CollectionDatasetInfo;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.Feature;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldSign;
import com.supermap.data.FieldType;
import com.supermap.data.GeoCoordSys;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalUGCType;
import com.supermap.data.InternalVariant;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.PrjParameter;
import com.supermap.data.Projection;
import com.supermap.data.ProjectionType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResampleInformation;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.SpatialIndexType;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.SpatialRelationType;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.Tolerance;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DatasetVector
extends Dataset {
    private Tolerance m_tolerance = null;
    private FieldInfos m_fieldInfos = null;
    private DatasetVector m_childDataset = null;
    private Dataset m_parentDataset = null;
    private static Integer m_lock = new Integer(0);

    protected DatasetVector() {
    }

    DatasetVector(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    public Charset getCharset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetCharset(this.getHandle());
        return (Charset)Enum.parseUGCValue(Charset.class, n);
    }

    public void setCharset(Charset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorNative.jni_SetCharset(this.getHandle(), value.getUGCValue());
    }

    public DatasetVector getChildDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_childDataset == null && (l = DatasetVectorNative.jni_GetChildDataset(this.getHandle())) != 0L) {
            this.m_childDataset = new DatasetVector(l, this.m_datasource);
        }
        return this.m_childDataset;
    }

    public Dataset getParentDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parentDataset == null && (l = DatasetVectorNative.jni_GetParentDataset(this.getHandle())) != 0L) {
            this.m_parentDataset = new DatasetVector(l, this.m_datasource);
        }
        return this.m_parentDataset;
    }

    public boolean isSimpliFy() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = DatasetNative.jni_GetIsSimpliFy(this.getHandle());
        return bl;
    }

    public void setIsSimpliFy(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_SetIsSimpliFy(this.getHandle(), value);
    }

    public boolean isFileCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetIsFileCache(this.getHandle());
    }

    public void setFileCache(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileCache(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVectorNative.jni_SetFileCache(this.getHandle(), value);
    }

    public int getRecordCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetRecordCount(this.getHandle());
    }

    public boolean setRecordCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_SetRecordCount(this.getHandle(), value);
    }

    public Tolerance getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_tolerance == null) {
            this.m_tolerance = new Tolerance(this, Tolerance.UserType.DATASETVECTOR);
        }
        return this.m_tolerance;
    }

    public void setTolerance(Tolerance tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_tolerance == null) {
            this.m_tolerance = new Tolerance(this, Tolerance.UserType.DATASETVECTOR);
        }
        this.m_tolerance.setDangle(tolerance.getDangle());
        this.m_tolerance.setFuzzy(tolerance.getFuzzy());
        this.m_tolerance.setGrain(tolerance.getGrain());
        this.m_tolerance.setNodeSnap(tolerance.getNodeSnap());
        this.m_tolerance.setSmallPolygon(tolerance.getSmallPolygon());
        this.m_tolerance.setExtend(tolerance.getExtend());
    }

    public int getFieldCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getFieldInfos().getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Integer n = m_lock;
        synchronized (n) {
            if (this.m_fieldInfos == null) {
                long l = DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
                if (l == 0L) {
                    return null;
                }
                this.m_fieldInfos = new FieldInfos(l, this);
                this.m_fieldInfos.setIsDisposable(false);
            } else if (!this.isOpen()) {
                DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
            } else {
                this.m_fieldInfos.refresh();
            }
            return this.m_fieldInfos;
        }
    }

    public Recordset getRecordset(boolean isEmptyRecordset, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        l = isEmptyRecordset ? DatasetVectorNative.jni_GetEmptyRecordset(this.getHandle(), n) : DatasetVectorNative.jni_GetAllRecordsByRecordset(this.getHandle(), n);
        Recordset recordset = null;
        if (l != 0L) {
            recordset = new Recordset(l, this);
            recordset.setIsDisposable(true);
        }
        return recordset;
    }

    public boolean append(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_Append(this.getHandle(), recordset.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean append(Recordset recordset, String tileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_Append1(this.getHandle(), recordset.getHandle(), tileName);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean append(Recordset recordset, String[] sourceFields, String[] targetFields) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_Append2(this.getHandle(), recordset.getHandle(), sourceFields, targetFields);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean deleteRecords(int[] id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (id == null || id.length == 0) {
            return true;
        }
        boolean bl = true;
        if (!this.open()) {
            bl = this.open();
        }
        if (bl) {
            Recordset recordset = this.query(id, CursorType.DYNAMIC);
            bl = recordset.deleteAll();
            recordset.close();
        }
        return bl;
    }

    public boolean isAvailableFieldName(String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (fieldName.startsWith("Sm") || fieldName.startsWith("SM") || fieldName.startsWith("sm")) {
            return bl;
        }
        if (fieldName != null && fieldName.trim().length() != 0) {
            bl = DatasetVectorNative.jni_IsAvailableFieldName(this.getHandle(), fieldName);
        }
        return bl;
    }

    public String getAvailableFieldName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        if (name.toLowerCase().startsWith("sm")) {
            name = "Field_" + name;
        }
        return DatasetVectorNative.jni_GetUnoccupiedFieldName(this.getHandle(), name);
    }

    public Recordset query(String attributeFilter, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query1(this.getHandle(), attributeFilter, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(Geometry geometry, double bufferDistance, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        if (geometry.isEmpty()) {
            return this.getRecordset(true, cursorType);
        }
        if (bufferDistance < 0.0) {
            String string = InternalResource.loadString("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = this.query(geometry, bufferDistance, "", cursorType);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return recordset;
    }

    public Recordset query(Geometry geometry, double bufferDistance, String attributeFilter, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            InternalHandleDisposable.makeSureNativeObjectLive(geometry);
            return this.getRecordset(true, cursorType);
        }
        if (bufferDistance < 0.0) {
            String string = InternalResource.loadString("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query2(this.getHandle(), geometry.getHandle(), bufferDistance, attributeFilter, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return recordset;
    }

    public Recordset query(Rectangle2D bounds, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        Recordset recordset = this.query(bounds, "", cursorType);
        return recordset;
    }

    public Recordset query(Rectangle2D bounds, String attributeFilter, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query3(this.getHandle(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), attributeFilter, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(int[] id, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (id == null) {
            String string = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query4(this.getHandle(), id, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(int[] id, String idFieldName, CursorType cursorType) {
        FieldInfo fieldInfo;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (id == null) {
            String string = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        if ((fieldInfo = this.getFieldInfos().get(idFieldName)) == null || fieldInfo.getType() != FieldType.INT32) {
            return this.getRecordset(true, cursorType);
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query7(this.getHandle(), id, idFieldName, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Recordset query(QueryParameter queryParameter) {
        Object object;
        Object object2;
        Object object3;
        String string;
        long l;
        long l2;
        int n;
        QueryParameter queryParameter2;
        int n2;
        long l3;
        block21: {
            if (this.getHandle() == 0L) {
                String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string2);
            }
            if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
                String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string3);
            }
            if (queryParameter == null) {
                String string4 = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string4);
            }
            if (this.getType().equals(DatasetType.TABULAR) && !queryParameter.getSpatialQueryMode().equals(SpatialQueryMode.NONE)) {
                String string5 = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
                throw new IllegalArgumentException(string5);
            }
            l3 = 0L;
            n2 = -1;
            queryParameter2 = null;
            n = -1;
            l2 = 0L;
            l = 0L;
            string = "";
            queryParameter2 = new QueryParameter(queryParameter);
            Object object4 = queryParameter2.getSpatialQueryObject();
            if (object4 != null) {
                if (object4.getClass().equals(Rectangle2D.class)) {
                    if (!queryParameter2.getSpatialQueryMode().equals(SpatialQueryMode.INTERSECT)) {
                        object3 = (Rectangle2D)object4;
                        if (Toolkit.isZero(((Rectangle2D)object3).getWidth()) || Toolkit.isZero(((Rectangle2D)object3).getHeight())) {
                            return this.getRecordset(true, queryParameter.getCursorType());
                        }
                        object2 = new Point2Ds();
                        ((Point2Ds)object2).add(new Point2D(((Rectangle2D)object3).getLeft(), ((Rectangle2D)object3).getBottom()));
                        ((Point2Ds)object2).add(new Point2D(((Rectangle2D)object3).getLeft(), ((Rectangle2D)object3).getTop()));
                        ((Point2Ds)object2).add(new Point2D(((Rectangle2D)object3).getRight(), ((Rectangle2D)object3).getTop()));
                        ((Point2Ds)object2).add(new Point2D(((Rectangle2D)object3).getRight(), ((Rectangle2D)object3).getBottom()));
                        object = new GeoRegion((Point2Ds)object2);
                        queryParameter2.setSpatialQueryObject(object);
                        break block21;
                    } else {
                        Rectangle2D rectangle2D = (Rectangle2D)object4;
                        l = DatasetVectorNative.jni_Query6(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), queryParameter2.getHandle());
                        Recordset recordset = null;
                        if (l == 0L) {
                            recordset = this.getRecordset(true, queryParameter.getCursorType());
                            recordset.setQueryParameter(queryParameter);
                        } else {
                            recordset = new Recordset(l, this);
                        }
                        queryParameter2.dispose();
                        return recordset;
                    }
                }
                if (object4.getClass().equals(Point2D.class)) {
                    object3 = (Point2D)object4;
                    if (((Point2D)object3).isEmpty()) {
                        return this.getRecordset(true, queryParameter.getCursorType());
                    }
                    object2 = new GeoPoint(((Point2D)object3).getX(), ((Point2D)object3).getY());
                    queryParameter2.setSpatialQueryObject(object2);
                } else if (object4.getClass().getSuperclass().getClass().equals(Geometry.class) && ((Geometry)(object3 = (Geometry)object4)).isEmpty()) {
                    return this.getRecordset(true, queryParameter.getCursorType());
                }
            }
        }
        l3 = queryParameter2.getHandle();
        if (queryParameter2.getSpatialQueryObject() != null) {
            l2 = ((InternalHandle)queryParameter2.getSpatialQueryObject()).getHandle();
        }
        n2 = queryParameter2.getSpatialQueryMode().getUGCValue();
        object3 = null;
        if (queryParameter2.getSpatialQueryObject() != null) {
            object3 = queryParameter2.getSpatialQueryObject().getClass().equals(DatasetVector.class) ? InternalUGCType.UGDatasetVector : (queryParameter2.getSpatialQueryObject().getClass().equals(Recordset.class) ? InternalUGCType.UGRecordset : InternalUGCType.UGGeometry);
        }
        if (object3 != null) {
            n = ((Enum)object3).getUGCValue();
        }
        this.checkSpatialQueryDim(queryParameter2.getSpatialQueryObject(), queryParameter2.getSpatialQueryMode());
        l = DatasetVectorNative.jni_Query5(this.getHandle(), l3, n2, l2, n, string);
        object2 = null;
        if (l == 0L) {
            object2 = this.getRecordset(true, queryParameter.getCursorType());
            if (object2 == null) {
                object = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException((String)object);
            }
            ((Recordset)object2).setQueryParameter(queryParameter);
        } else {
            object2 = new Recordset(l, this);
        }
        queryParameter2.dispose();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildFieldIndex(String[] fieldName, String indexName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldName == null) {
            String string = InternalResource.loadString("fieldName", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (fieldName.length == 0) {
            return false;
        }
        Integer n = m_lock;
        synchronized (n) {
            for (int i = 0; i < fieldName.length; ++i) {
                int n2 = this.getFieldInfos().indexOf(fieldName[i]);
                if (n2 != -1) continue;
                String string = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (indexName == null || indexName.trim().length() == 0) {
                String string = InternalResource.loadString("indexName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            String string = Toolkit.joinString(fieldName, ",");
            return DatasetVectorNative.jni_CreateFieldIndex(this.getHandle(), string, indexName);
        }
    }

    public SpatialIndexType getSpatialIndexType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetSpatialIndexType(this.getHandle());
        return (SpatialIndexType)Enum.parseUGCValue(SpatialIndexType.class, n);
    }

    public boolean isSpatialIndexDirty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetIsSpatialIndexDirty(this.getHandle());
    }

    public boolean isSpatialIndexTypeSupported(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = InternalResource.loadString("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return DatasetVectorNative.jni_IsSpatialIndexTypeSupported(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean buildSpatialIndex(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexType spatialIndexType = spatialIndexInfo.getType();
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = InternalResource.loadString("spatialIndexInfo", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexInfo == null || spatialIndexInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("spatialIndexInfo", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        boolean bl = DatasetVectorNative.jni_BuildSpatialIndex2(this.getHandle(), spatialIndexInfo.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(spatialIndexInfo);
        return bl;
    }

    public boolean buildSpatialIndex(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = InternalResource.loadString("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = InternalResource.loadString("spatialIndexType", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_BuildSpatialIndex1(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean reBuildSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reBuildSpatialIndex()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_ReBuildSpatialIndex(this.getHandle());
    }

    public double statistic(String fieldName, StatisticMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldName == null || fieldName.trim().length() == 0) {
            String string = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getFieldInfos().indexOf(fieldName);
        if (n == -1) {
            String string = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        int n2 = mode.getUGCValue();
        return DatasetVectorNative.jni_Statistic(this.getHandle(), fieldName, n2);
    }

    public double statistic(int fieldIndex, StatisticMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldIndex < 0 || fieldIndex >= this.getFieldCount()) {
            String string = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        String string = this.getFieldInfos().get(fieldIndex).getName();
        return this.statistic(string, mode);
    }

    public boolean updateField(String fieldName, Object value, String attributeFilter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldName == null || fieldName.trim().length() == 0) {
            String string = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getFieldInfos().indexOf(fieldName);
        if (n == -1) {
            String string = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isCanUpdateFiledName(fieldName)) {
            String string = InternalResource.loadString("fieldName", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!InternalVariant.isSupportedInstance(value)) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalVariant internalVariant = new InternalVariant(value);
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        return DatasetVectorNative.jni_UpdateField1(this.getHandle(), fieldName, internalVariant.getHandle(), attributeFilter);
    }

    public boolean updateField(int fieldIndex, Object value, String attributeFilter) {
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.isReadOnly()) {
            String string4 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (fieldIndex < 0 || fieldIndex >= this.getFieldCount()) {
            String string5 = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        if (value == null) {
            String string6 = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string6);
        }
        if (!InternalVariant.isSupportedInstance(value)) {
            String string7 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (!this.isCanUpdateFiledName(string = this.getFieldInfos().get(fieldIndex).getName())) {
            String string8 = InternalResource.loadString("fieldIndex", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        return this.updateField(string, value, attributeFilter);
    }

    public boolean updateField(String fieldName, String expression, String attributeFilter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldName == null || fieldName.trim().length() == 0) {
            String string = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getFieldInfos().indexOf(fieldName);
        if (n == -1) {
            String string = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isCanUpdateFiledName(fieldName)) {
            String string = InternalResource.loadString("fieldName", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (expression == null || expression.trim().length() == 0) {
            String string = InternalResource.loadString("expression", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        return DatasetVectorNative.jni_UpdateField2(this.getHandle(), fieldName, expression, attributeFilter);
    }

    public boolean updateField(int fieldIndex, String expression, String attributeFilter) {
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.isReadOnly()) {
            String string4 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (fieldIndex < 0 || fieldIndex >= this.getFieldCount()) {
            String string5 = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        if (expression == null || expression.trim().length() == 0) {
            String string6 = InternalResource.loadString("expression", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (!this.isCanUpdateFiledName(string = this.getFieldInfos().get(fieldIndex).getName())) {
            String string7 = InternalResource.loadString("fieldIndex", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        return this.updateField(string, expression, attributeFilter);
    }

    public Rectangle2D computeBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetVectorNative.jni_ComputeBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean dropFieldIndex(String indexName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (indexName == null || indexName.trim().length() == 0) {
            String string = InternalResource.loadString("indexName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetVectorNative.jni_DropFieldIndex(this.getHandle(), indexName);
    }

    public boolean dropSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_DropSpatialIndex(this.getHandle());
    }

    protected static DatasetVector createInstance(long handle, Datasource datasource) {
        return new DatasetVector(handle, datasource);
    }

    @Override
    protected final void clearHandle() {
        this.m_tolerance = null;
        if (this.m_fieldInfos != null) {
            this.m_fieldInfos.clearHandle();
            this.m_fieldInfos = null;
        }
        if (this.m_childDataset != null) {
            this.m_childDataset.clearHandle();
            this.m_childDataset = null;
        }
        if (this.m_parentDataset != null) {
            this.m_parentDataset.clearHandle();
            this.m_parentDataset = null;
        }
        this.setHandle(0L);
    }

    private String createValidName(String name) {
        if (name.trim().length() == 0) {
            return name;
        }
        String string = name.charAt(0) >= '0' && name.charAt(0) <= '9' || name.startsWith("_") ? "Field_" + name : name;
        return string;
    }

    private boolean isCanUpdateFiledName(String fieldName) {
        int n = this.getFieldInfos().indexOf(fieldName);
        boolean bl = false;
        if (n != -1) {
            if (this.getFieldInfos().get(n).isSystemField()) {
                if (fieldName.equalsIgnoreCase("SmUserID")) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private double convertDistance(double bufferDistance, Geometry geometry) {
        double d = 0.0;
        PrjCoordSysType prjCoordSysType = this.getPrjCoordSys().getType();
        if (prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            GeoCoordSys geoCoordSys = this.getPrjCoordSys().getGeoCoordSys();
            Projection projection = new Projection(ProjectionType.PRJ_EQUIDISTANT_AZIMUTHAL);
            Rectangle2D rectangle2D = geometry.getBounds();
            PrjParameter prjParameter = new PrjParameter();
            prjParameter.setCentralMeridian(rectangle2D.getCenter().getX() - 1.0E-6);
            prjParameter.setCentralParallel(rectangle2D.getCenter().getY() - 1.0E-6);
            prjParameter.setStandardParallel1(rectangle2D.getBottom() + rectangle2D.getHeight() / 3.0);
            prjParameter.setStandardParallel2(rectangle2D.getTop() - rectangle2D.getHeight() / 3.0);
            PrjCoordSys prjCoordSys = new PrjCoordSys(geoCoordSys, projection, prjParameter, "tempPrjCoordSys");
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(rectangle2D.getCenter());
            CoordSysTranslator.forward(point2Ds, prjCoordSys);
            Point2D point2D = point2Ds.getItem(0).clone();
            point2D.setX(point2Ds.getItem(0).getX() + bufferDistance);
            point2Ds.add(point2D);
            CoordSysTranslator.inverse(point2Ds, prjCoordSys);
            double d2 = Math.pow(point2Ds.getItem(0).getX() - point2Ds.getItem(1).getX(), 2.0);
            double d3 = Math.pow(point2Ds.getItem(0).getY() - point2Ds.getItem(1).getY(), 2.0);
            d = Math.sqrt(d2 + d3);
            InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
            InternalHandleDisposable.makeSureNativeObjectLive(prjParameter);
        } else {
            d = bufferDistance;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return d;
    }

    private void checkSpatialQueryDim(Object queryObject, SpatialQueryMode queryMode) {
        if (!queryMode.equals(SpatialQueryMode.NONE)) {
            InternalHandle internalHandle;
            int n = -1;
            int n2 = -1;
            if (this.getType().equals(DatasetType.CAD)) {
                return;
            }
            if (this.getType().equals(DatasetType.POINT) || this.getType().equals(DatasetType.POINT3D) || this.getType().equals(DatasetType.POINTEPS)) {
                n = 0;
            } else if (this.getType().equals(DatasetType.LINE) || this.getType().equals(DatasetType.NETWORK) || this.getType().equals(DatasetType.NETWORK3D) || this.getType().equals(DatasetType.LINE3D) || this.getType().equals(DatasetType.LINEM) || this.getType().equals(DatasetType.LINEEPS)) {
                n = 1;
            } else if (this.getType().equals(DatasetType.REGION) || this.getType().equals(DatasetType.TEXT) || this.getType().equals(DatasetType.REGION3D) || this.getType().equals(DatasetType.TEXTEPS) || this.getType().equals(DatasetType.REGIONEPS)) {
                n = 2;
            }
            if (queryObject instanceof DatasetVector) {
                internalHandle = (DatasetVector)queryObject;
                if (((Dataset)internalHandle).getType().equals(DatasetType.POINT) || ((Dataset)internalHandle).getType().equals(DatasetType.POINT3D) || ((Dataset)internalHandle).getType().equals(DatasetType.POINTEPS)) {
                    n2 = 0;
                } else if (((Dataset)internalHandle).getType().equals(DatasetType.LINE) || ((Dataset)internalHandle).getType().equals(DatasetType.LINE3D) || ((Dataset)internalHandle).getType().equals(DatasetType.LINEM) || ((Dataset)internalHandle).getType().equals(DatasetType.LINEEPS)) {
                    n2 = 1;
                } else if (((Dataset)internalHandle).getType().equals(DatasetType.REGION) || ((Dataset)internalHandle).getType().equals(DatasetType.REGION3D) || ((Dataset)internalHandle).getType().equals(DatasetType.TEXT) || ((Dataset)internalHandle).getType().equals(DatasetType.TEXTEPS) || ((Dataset)internalHandle).getType().equals(DatasetType.REGIONEPS)) {
                    n2 = 2;
                }
            } else if (queryObject instanceof Recordset) {
                internalHandle = (Recordset)queryObject;
                if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.POINT) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.POINT3D) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.POINTEPS)) {
                    n2 = 0;
                } else if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINE) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINE3D) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINEM) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINEEPS)) {
                    n2 = 1;
                } else if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.REGION) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.REGION3D) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.TEXT) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.TEXTEPS) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.REGIONEPS)) {
                    n2 = 2;
                }
            } else if (queryObject instanceof Geometry) {
                internalHandle = (Geometry)queryObject;
                if (((Geometry)internalHandle).getType().equals(GeometryType.GEOPOINT) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPOINT3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPOINTEPS)) {
                    n2 = 0;
                } else if (((Geometry)internalHandle).getType().equals(GeometryType.GEOLINE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOLINE3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOLINEM) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOLINEEPS)) {
                    n2 = 1;
                } else if (((Geometry)internalHandle).getType().equals(GeometryType.GEOREGION) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOREGION3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOMODEL) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOSPHERE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOHEMISPHERE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOBOX) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCYLINDER) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCONE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPYRAMID) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPIE3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCIRCLE3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPIECYLINDER) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOELLIPSOID) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOTEXT) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOTEXTEPS) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOREGIONEPS)) {
                    n2 = 2;
                }
            }
            boolean bl = false;
            if (n == -1 || n2 == -1) {
                String string = InternalResource.loadString("", "UnsupprotDatasetType", "data_resources");
                throw new IllegalStateException(string);
            }
            if (queryMode.equals(SpatialQueryMode.IDENTITY)) {
                if (n != n2) {
                    bl = true;
                }
            } else if (queryMode.equals(SpatialQueryMode.TOUCH)) {
                if (n == 0 && n2 == 0) {
                    bl = true;
                }
            } else if (queryMode.equals(SpatialQueryMode.OVERLAP)) {
                if (n == 0 || n != n2) {
                    bl = true;
                }
            } else if (queryMode.equals(SpatialQueryMode.CROSS)) {
                if (n == 0 || n2 != 1) {
                    bl = true;
                }
            } else if (queryMode.equals(SpatialQueryMode.WITHIN)) {
                if (n < n2) {
                    bl = true;
                }
            } else if (queryMode.equals(SpatialQueryMode.CONTAIN) && n > n2) {
                bl = true;
            }
            if (bl) {
                String string = InternalResource.loadString("", "QueryParameter_InvalidQueryObject", "data_resources");
                throw new IllegalStateException(string);
            }
        }
    }

    public Map<Integer, Feature> getAllFeatures() {
        Recordset recordset = this.query("", CursorType.STATIC);
        HashMap<Integer, Feature> hashMap = new HashMap<Integer, Feature>(this.getRecordCount());
        recordset.moveFirst();
        while (!recordset.isEOF()) {
            Feature feature = recordset.getFeature();
            hashMap.put(feature.getID(), feature);
            recordset.moveNext();
        }
        recordset.dispose();
        return hashMap;
    }

    public boolean updateFields(DatasetVector sourceDataset, SpatialRelationType spatialRelationType, String[] sourceFields, String[] targetFields, AttributeStatisticsType attributeStatisticsType, boolean isBorderInside, String errorName, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (attributeStatisticsType == AttributeStatisticsType.MAXAREA && this.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("datasetType", "UnsupprotDatasetType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl = DatasetVectorNative.jni_UpdateFields1(this.getHandle(), sourceDataset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), sourceFields, targetFields, isBorderInside, errorName, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean updateFields(Recordset sourceRecordset, SpatialRelationType spatialRelationType, String[] sourceFields, String[] targetFields, AttributeStatisticsType attributeStatisticsType, boolean isBorderInside, String errorName, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.POINT && sourceRecordset.getDataset().getType() != DatasetType.LINE && sourceRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl = DatasetVectorNative.jni_UpdateFields2(this.getHandle(), sourceRecordset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), sourceFields, targetFields, isBorderInside, errorName, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(sourceRecordset);
        return bl;
    }

    public int[] getIDsByGeoRelation(DatasetVector sourceDataset, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation1(this.getHandle(), sourceDataset.getHandle(), spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public int[] getIDsByGeoRelation(Recordset sourceRecordset, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.POINT && sourceRecordset.getDataset().getType() != DatasetType.LINE && sourceRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation2(this.getHandle(), sourceRecordset.getHandle(), spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(sourceRecordset);
        return nArray;
    }

    public int[] getIDsByGeoRelation(Geometry[] sourceGeometries, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries.length == 0) {
            String string = InternalResource.loadString("sourceGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries[0] == null) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = sourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long[] lArray = new long[sourceGeometries.length];
        for (int i = 0; i < sourceGeometries.length; ++i) {
            Geometry geometry = sourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
            hashSet.add(geometry.getID());
        }
        if (hashSet.size() != sourceGeometries.length) {
            String string = InternalResource.loadString("sourceGeometries", "Geometry_Type_Must_Be_Same", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation3(this.getHandle(), lArray, spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public boolean resample(ResampleInformation resampleInfo, boolean isShowProgress, boolean isSaveSmallGeometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.LINE && this.getType() != DatasetType.NETWORK && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInfo == null) {
            String string = InternalResource.loadString("ResampleInformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("ResampleInformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInfo.getTolerance() <= 0.0) {
            String string = InternalResource.loadString("Tolerance", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl = DatasetVectorNative.jni_Resample1(this.getHandle(), resampleInfo.getHandle(), isShowProgress, isSaveSmallGeometry, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(resampleInfo);
        return bl;
    }

    public boolean smooth(int smoothness, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.LINE && this.getType() != DatasetType.NETWORK && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (smoothness < 2) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl = DatasetVectorNative.jni_Smooth(this.getHandle(), smoothness, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl;
    }

    static void steppedCallBack(DatasetVector source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, null, bl);
            source.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public boolean appendFields(DatasetVector sourceDataset, String sourceLinkFieldName, String targetLinkFieldName, String[] sourceFields, String[] targetFields) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (sourceLinkFieldName == null || sourceLinkFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("sourceLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetLinkFieldName == null || targetLinkFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("targetLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_AppendFields1(this.getHandle(), sourceDataset.getHandle(), sourceLinkFieldName, targetLinkFieldName, sourceFields, targetFields);
        return bl;
    }

    public boolean appendFields(DatasetVector sourceDataset, String sourceLinkFieldName, String targetLinkFieldName, String[] sourceFields) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (sourceLinkFieldName == null || sourceLinkFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("sourceLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetLinkFieldName == null || targetLinkFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("targetLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_AppendFields2(this.getHandle(), sourceDataset.getHandle(), sourceLinkFieldName, targetLinkFieldName, sourceFields);
        return bl;
    }

    @Override
    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetVectorNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public Map<String, String> getFieldIndexes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = DatasetVectorNative.jni_GetFieldIndexes(this.getHandle());
        int n = string.indexOf(47);
        while (n != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.indexOf(45);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            hashMap.put(string3, string4);
            string = string2 = string.substring(n + 1);
            n = string.indexOf(47);
        }
        return hashMap;
    }

    public boolean truncate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_Truncate(this.getHandle());
    }

    public String getFieldNameBySign(FieldSign value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetFieldNameBySign(this.getHandle(), value.getUGCValue());
    }

    public DatasetVector[] getChildDatasets() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetChildDatasetsCount(this.getHandle());
        long[] lArray = new long[n];
        DatasetVectorNative.jni_GetChildDatasets(this.getHandle(), lArray);
        DatasetVector[] datasetVectorArray = new DatasetVector[n];
        try {
            for (int i = 0; i < n; ++i) {
                datasetVectorArray[i] = DatasetVector.createInstance(lArray[i], this.m_datasource);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return datasetVectorArray;
    }

    public Boolean DeleteDatasetFromCollection(DatasourceConnectionInfo info, String datasetName) {
        if (!this.isOpen()) {
            this.open();
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.VECTORCOLLECTION) {
            String string = InternalResource.loadString("", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = this.getHandle();
        long l2 = info.getHandle();
        return DatasetVectorNative.jni_DeleteDatasetFromCollection(l, l2, datasetName);
    }

    public Boolean addCollectionDataset(DatasetVector dtv) {
        if (!this.isOpen()) {
            this.open();
        }
        if (dtv.getDatasource().getEngineType() == EngineType.UDB) {
            String string = InternalResource.loadString("", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.VECTORCOLLECTION) {
            String string = InternalResource.loadString("", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = dtv.getHandle();
        return DatasetVectorNative.jni_AddCollectionDataset(this.getHandle(), l);
    }

    public int getCollectionDatasetCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.VECTORCOLLECTION) {
            String string = InternalResource.loadString("", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetCollectionDatasetCount(this.getHandle());
    }

    public ArrayList<CollectionDatasetInfo> getCollectionDatasetInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.VECTORCOLLECTION) {
            String string = InternalResource.loadString("", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<CollectionDatasetInfo> arrayList = new ArrayList<CollectionDatasetInfo>();
        int n = this.getCollectionDatasetCount();
        DatasourceConnectionInfo[] datasourceConnectionInfoArray = new DatasourceConnectionInfo[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            datasourceConnectionInfoArray[i] = new DatasourceConnectionInfo();
            lArray[i] = datasourceConnectionInfoArray[i].getHandle();
        }
        String[] stringArray = new String[n];
        DatasetVectorNative.jni_GetCollectionDTInfos(this.getHandle(), lArray, stringArray);
        for (int i = 0; i < n; ++i) {
            CollectionDatasetInfo collectionDatasetInfo = new CollectionDatasetInfo();
            collectionDatasetInfo.setDatasourceConnectionInfo(datasourceConnectionInfoArray[i]);
            collectionDatasetInfo.setDatasetName(stringArray[i]);
            arrayList.add(collectionDatasetInfo);
        }
        return arrayList;
    }

    public DatasetType GetSubCollectionDatasetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.VECTORCOLLECTION) {
            String string = InternalResource.loadString("", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetSubCollectionDatasetType(this.getHandle());
        return (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
    }

    public double getMaxZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetMaxZ(this.getHandle());
    }

    public double getMinZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetMinZ(this.getHandle());
    }

    public boolean computeAreaLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_ComputeAreaLength(this.getHandle());
    }
}

