/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGridNative;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.StatisticsResult;
import java.awt.Point;
import java.util.HashMap;

public class DatasetImage
extends Dataset {
    private GeoRegion m_clipRegion = null;
    private static Integer m_lock = new Integer(0);

    DatasetImage(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    protected DatasetImage() {
        m_senderMethodName = "buildPyramid";
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHeight(this.getHandle());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null && (l = DatasetImageNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)Geometry.createInstance(l);
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        if (value == null) {
            if (this.m_clipRegion != null) {
                this.m_clipRegion.clearHandle();
                this.m_clipRegion = null;
            }
            DatasetImageNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_SetClipRegion(this.getHandle(), value.getHandle());
            if (this.m_clipRegion != null) {
                this.m_clipRegion.fromXML(value.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public HashMap<Integer, StatisticsResult> getImageStatisticsResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetImageNative.jni_GetRasterStatisticsResult(this.getHandle(), nArray, lArray);
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.isOpen();
        if (!bl) {
            this.open();
        }
        boolean bl2 = DatasetImageNative.jni_GetHasPyramid(this.getHandle());
        if (!bl) {
            this.close();
        }
        return bl2;
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        return DatasetImageNative.jni_GetBandCount(this.getHandle());
    }

    public double getNoData(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetNoData(this.getHandle(), index);
    }

    public void setNoData(double value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        DatasetImageNative.jni_SetNoData(this.getHandle(), value, index);
    }

    public double getMinValue(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetMinValue(this.getHandle(), index);
    }

    public double getMaxValue(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetMaxValue(this.getHandle(), index);
    }

    public PixelFormat getPixelFormat(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        int n = DatasetImageNative.jni_GetPixelFormat(this.getHandle(), index);
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public Colors getPalette(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = DatasetImageNative.jni_GetColorTable(this.getHandle(), index);
        if (l == 0L) {
            return null;
        }
        Colors colors = new Colors(l, false);
        colors.setIsDisposable(false);
        return colors;
    }

    public void setPalette(Colors value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors = this.getPalette(index);
        colors.clear();
        int n = value.getCount();
        for (int i = 0; i < n; ++i) {
            colors.add(value.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public void setGeoReference(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageNative.jni_SetBounds(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public boolean calculateExtremum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_CalculateExtremum(this.getHandle());
    }

    public boolean calculateExtremum(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_CalculateExtremumByIndex(this.getHandle(), index);
    }

    public double getValue(int column, int row, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetValue(this.getHandle(), column, row, index);
    }

    public double setValue(int column, int row, double value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetGrid_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_SetValue(this.getHandle(), column, row, value, index);
    }

    public Point2D imageToXY(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        DatasetImageNative.jni_ImageToXY(this.getHandle(), point.x, point.y, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point xyToImage(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        DatasetImageNative.jni_XYToImage(this.getHandle(), point.getX(), point.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public HashMap<Integer, StatisticsResult> buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetImageNative.jni_BuildStatistics(this.getHandle(), nArray, lArray);
        if (!bl) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = null;
            if (lArray[i] == 0L) continue;
            statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetImageNative.jni_NewSelfEventHandle(this);
            bl = DatasetImageNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean updatePyramid(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridNative.jni_UpdatePyramid(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_RemovePyramid(this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        Integer n2 = m_lock;
        synchronized (n2) {
            n = DatasetImageNative.jni_addBand(this.getHandle(), l);
        }
        if (this.getHasPyramid()) {
            this.removePyramid();
            this.buildPyramid();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage[] datasets) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addBand(DatasetImage[] datasets)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage[] datasets)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasets == null) {
            String string = InternalResource.loadString("datasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < datasets.length; ++n) {
            long l = InternalHandle.getHandle(datasets[n]);
            if (l != 0L) continue;
            String string = InternalResource.loadString("datasets", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        Integer n2 = m_lock;
        synchronized (n2) {
            for (int i = 0; i < datasets.length; ++i) {
                n += this.addBand(datasets[i]);
            }
        }
        if (this.getHasPyramid()) {
            this.removePyramid();
            this.buildPyramid();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage dataset, int[] indexes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddBand(DatasetImage dataset, int[] indexes)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset, int[] indexes)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("indexes", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("dataset", "DatasetImage_TheArgumentMustBeMultibandsData", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        Integer n2 = m_lock;
        synchronized (n2) {
            int n3 = indexes.length;
            int n4 = dataset.getBandCount();
            for (int i = 0; i < n3; ++i) {
                if (0 <= indexes[i] && n4 > indexes[i]) continue;
                String string = InternalResource.loadString("indexes", "Global_IndexOutOfBounds", "data_resources");
                throw new IllegalArgumentException(string);
            }
            n = DatasetImageNative.jni_addBandIndexs(this.getHandle(), l, indexes);
        }
        if (this.getHasPyramid()) {
            this.removePyramid();
            this.buildPyramid();
        }
        return n;
    }

    public String get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_getItem(this.getHandle(), index);
    }

    public void set(int index, String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(int index, String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = DatasetImageNative.jni_isContain(this.getHandle(), value);
        if (bl) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetImageNative.jni_setItem(this.getHandle(), index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBand(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int index)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n = m_lock;
        synchronized (n) {
            if (index < 0 || index >= this.getBandCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetImageNative.jni_deleteBand(this.getHandle(), index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBand(int startIndex, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n = m_lock;
        synchronized (n) {
            if (startIndex < 0 || startIndex >= this.getBandCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            if (startIndex + count < startIndex || startIndex + count > this.getBandCount()) {
                String string = InternalResource.loadString("satrtIndex\uff0ccount", "DatasetImage_InvalidCount", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetImageNative.jni_deleteBands(this.getHandle(), startIndex, count);
        }
    }

    public int indexOf(String bandName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bandName == null || bandName.trim().length() == 0) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_indexOf(this.getHandle(), bandName);
    }

    public boolean update(DatasetImage dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dataset.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_Update(this.getHandle(), dataset.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_clipRegion != null) {
            this.m_clipRegion.clearHandle();
            this.m_clipRegion = null;
        }
        this.setHandle(0L);
    }
}

