/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGridNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.NetCDFVarInfo;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResamplingMethod;
import com.supermap.data.StatisticsResult;
import java.awt.Point;

public class DatasetGrid
extends Dataset {
    private GeoRegion m_clipRegion = null;
    private NetCDFVarInfo m_NetCDFVarInfo = null;
    private static Integer m_lock = new Integer(0);
    private Colors m_colors;
    private DatasetVector m_childDataset = null;

    protected DatasetGrid() {
        m_senderMethodName = "buildPyramid";
    }

    DatasetGrid(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetHeight(this.getHandle());
    }

    public void setGeoReference(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetGridNative.jni_SetBounds(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public int getRowBlockCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetRowBlockCount(this.getHandle());
    }

    public int getColumnBlockCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetColumnBlockCount(this.getHandle());
    }

    public double getNoValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetNoValue(this.getHandle());
    }

    public void setNoValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridNative.jni_SetNoValue(this.getHandle(), value);
    }

    public double getMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetMinValue(this.getHandle());
    }

    public double getMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetMaxValue(this.getHandle());
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_GetHasPyramid(this.getHandle());
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null && (l = DatasetGridNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)Geometry.createInstance(l);
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_clipRegion != null) {
                this.m_clipRegion.clearHandle();
                this.m_clipRegion = null;
            }
            DatasetGridNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGridNative.jni_SetClipRegion(this.getHandle(), value.getHandle());
            if (this.m_clipRegion != null) {
                this.m_clipRegion.fromXML(value.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public boolean calculateExtremum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_CalculateExtremum(this.getHandle());
    }

    public NetCDFVarInfo getNetCDFVarInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_NetCDFVarInfo;
    }

    public void setNetCDFVarInfo(NetCDFVarInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_NetCDFVarInfo = value;
        NetCDFVarInfo netCDFVarInfo = new NetCDFVarInfo(value);
        long l = InternalHandleDisposable.getHandle(netCDFVarInfo);
        DatasetGridNative.jni_SetDatasetNetCDFVarInfo(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(netCDFVarInfo);
    }

    public double getValue(int column, int row) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetGridNative.jni_GetValue(this.getHandle(), column, row);
    }

    public double setValue(int column, int row, double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetGrid_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetGridNative.jni_SetValue(this.getHandle(), column, row, value);
    }

    public Point2D gridToXY(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        DatasetGridNative.jni_GridToXY(this.getHandle(), point.x, point.y, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point xyToGrid(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        DatasetGridNative.jni_XYToGrid(this.getHandle(), point.getX(), point.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public boolean buildPyramid(ResamplingMethod eMethod) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetGridNative.jni_NewSelfEventHandle(this);
            int n = eMethod.getUGCValue();
            bl = DatasetGridNative.jni_BuildPyramidWithMethod(this.getHandle(), this.m_selfEventHandle, n);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetGridNative.jni_NewSelfEventHandle(this);
            bl = DatasetGridNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean updatePyramid(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridNative.jni_UpdatePyramid(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_RemovePyramid(this.getHandle());
    }

    public Colors getColorTable() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_colors == null && (l = DatasetGridNative.jni_GetColorTable(this.getHandle())) != 0L) {
            this.m_colors = Colors.createInstance(l, false);
        }
        return this.m_colors;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l2 = InternalHandleDisposable.getHandle(colors2);
        DatasetGridNative.jni_SetColorTable(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive(colors2);
    }

    public DatasetVector buildValueTable(Datasource targetDatasource, String tableName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildValueTable(Datasource ds,String)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (targetDatasource == null) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridNative.jni_BuildValueTable(this.getHandle(), targetDatasource.getHandle(), tableName);
        DatasetVector datasetVector = null;
        if (l != 0L) {
            datasetVector = new DatasetVector(l, targetDatasource);
        }
        return datasetVector;
    }

    public StatisticsResult getGridStatisticsResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridNative.jni_GetRasterStatisticsResult(this.getHandle());
        StatisticsResult statisticsResult = null;
        if (l != 0L) {
            statisticsResult = new StatisticsResult(l);
        }
        return statisticsResult;
    }

    public StatisticsResult buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridNative.jni_BuildStatistics(this.getHandle());
        StatisticsResult statisticsResult = null;
        if (l != 0L) {
            statisticsResult = new StatisticsResult(l);
        }
        return statisticsResult;
    }

    public boolean update(DatasetGrid dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dataset.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridNative.jni_Update(this.getHandle(), dataset.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_clipRegion != null) {
            this.m_clipRegion.clearHandle();
            this.m_clipRegion = null;
        }
        if (this.m_colors != null) {
            this.m_colors.clearHandle();
            this.m_colors = null;
        }
        this.setHandle(0L);
    }

    protected static DatasetGrid createInstance(long handle, Datasource datasource) {
        return new DatasetGrid(handle, datasource);
    }
}

