/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetClosedEvent;
import com.supermap.data.DatasetClosedListener;
import com.supermap.data.DatasetClosingEvent;
import com.supermap.data.DatasetClosingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.DatasetLockChangedEvent;
import com.supermap.data.DatasetLockChangedListener;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.GeoStoreType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.LockStateType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.data.ToolkitNative;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Dataset
extends InternalHandle {
    private boolean m_disposable = false;
    protected Datasource m_datasource = null;
    protected DatasetType m_datasetType = null;
    protected boolean m_bTypeChanged = false;
    transient CopyOnWriteArrayList<DatasetClosingListener> m_datasetClosingListeners;
    transient CopyOnWriteArrayList<DatasetClosedListener> m_datasetClosedListeners;
    transient CopyOnWriteArrayList<DatasetLockChangedListener> m_datasetLockChangedListeners;
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected long m_selfEventHandle;
    protected static String m_senderMethodName;
    private PrjCoordSys m_prjCoordSys;

    protected Dataset() {
        m_senderMethodName = "PJConvert";
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            DatasetNative.jni_UnSetPrjCoordSys(this.getHandle());
            if (this.m_prjCoordSys != null) {
                this.m_prjCoordSys.clearHandle();
                this.m_prjCoordSys = null;
            }
        } else {
            long l = InternalHandle.getHandle(value);
            if (l == 0L) {
                String string = InternalResource.loadString("value", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetNative.jni_Open(this.getHandle());
            boolean bl = DatasetNative.jni_setPrjCoordSys(this.getHandle(), l);
            if (bl) {
                this.m_prjCoordSys = value.clone();
            }
            InternalHandleDisposable.makeSureNativeObjectLive(value);
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        if ((l = DatasetNative.jni_getPrjCoordSys(this.getHandle())) != 0L) {
            this.m_prjCoordSys = PrjCoordSys.createInstance(l, false);
        }
        return this.m_prjCoordSys;
    }

    public boolean hasVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_hasVersion(this.getHandle());
    }

    public boolean hasPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_HasSetPrjCoordSys(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        DatasetNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.m_datasource.isReadOnly();
        boolean bl2 = DatasetNative.jni_GetIsReadOnly(this.getHandle());
        return bl || bl2;
    }

    public boolean isOpen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsOpen(this.getHandle());
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasetNative.jni_SetDescription(this.getHandle(), value);
    }

    public String getExtInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetExtInfo(this.getHandle());
    }

    public void setExtInfo(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        if (value.length() > 2047) {
            throw new IllegalStateException("The length is outof range");
        }
        DatasetNative.jni_SetExtInfo(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetName(this.getHandle());
    }

    public String getTableName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetTableName(this.getHandle());
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetType == null || this.m_bTypeChanged) {
            int n = DatasetNative.jni_GetType(this.getHandle());
            try {
                this.m_datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
                this.m_bTypeChanged = false;
            }
            catch (RuntimeException runtimeException) {
                if (n == DatasetType.DEM.getUGCValue()) {
                    this.m_datasetType = DatasetType.GRID;
                }
                throw runtimeException;
            }
        }
        return this.m_datasetType;
    }

    public GeoStoreType getGeoStoreType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetGeoStoreType(this.getHandle());
        return (GeoStoreType)Enum.parseUGCValue(GeoStoreType.class, n);
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetClosingEvent datasetClosingEvent = new DatasetClosingEvent(this, this);
        this.fireClosing(datasetClosingEvent);
        if (datasetClosingEvent.getCancel()) {
            return;
        }
        DatasetNative.jni_Close(this.getHandle());
        DatasetClosedEvent datasetClosedEvent = new DatasetClosedEvent(this, this);
        this.fireClosed(datasetClosedEvent);
    }

    public boolean open() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_Open(this.getHandle());
    }

    boolean rename(String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_datasource.getDatasets().isAvailableDatasetName(newName)) {
            String string = InternalResource.loadString("newName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetNative.jni_Rename(this.getHandle(), newName);
        return bl;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_SetReadOnly(this.getHandle(), readOnly);
    }

    @Override
    protected void clearHandle() {
        this.m_datasource = null;
        this.m_prjCoordSys = null;
        this.setHandle(0L);
    }

    static InternalInvalidState isValidDatasetName(String name) {
        int n = ToolkitNative.jni_IsValidDatasetName(name);
        if (n == -1) {
            return null;
        }
        return (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
    }

    protected static Dataset createInstance(long dtHandle, DatasetType javaType, Datasource datasource) {
        if (dtHandle == 0L) {
            String string = InternalResource.loadString("", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        dataset = javaType.equals(DatasetType.IMAGE) || javaType.equals(DatasetType.WCS) || javaType.equals(DatasetType.WMS) ? new DatasetImage(dtHandle, datasource) : (javaType.equals(DatasetType.GRID) || javaType.equals(DatasetType.DEM) ? new DatasetGrid(dtHandle, datasource) : (javaType.equals(DatasetType.VOLUME) ? new DatasetVolume(dtHandle, datasource) : (javaType.equals(DatasetType.CAD) || javaType.equals(DatasetType.LINE) || javaType.equals(DatasetType.POINT) || javaType.equals(DatasetType.REGION) || javaType.equals(DatasetType.TABULAR) || javaType.equals(DatasetType.LINEM) || javaType.equals(DatasetType.NETWORK) || javaType.equals(DatasetType.LINKTABLE) || javaType.equals(DatasetType.TEXT) || javaType.equals(DatasetType.POINT3D) || javaType.equals(DatasetType.LINE3D) || javaType.equals(DatasetType.REGION3D) || javaType.equals(DatasetType.PARAMETRICLINE) || javaType.equals(DatasetType.PARAMETRICREGION) || javaType.equals(DatasetType.MODEL) || javaType.equals(DatasetType.NETWORK3D) || javaType.equals(DatasetType.POINTEPS) || javaType.equals(DatasetType.LINEEPS) || javaType.equals(DatasetType.REGIONEPS) || javaType.equals(DatasetType.TEXTEPS) || javaType.equals(DatasetType.VECTORCOLLECTION) ? new DatasetVector(dtHandle, datasource) : (javaType.equals(DatasetType.TOPOLOGY) ? new DatasetTopology(dtHandle, datasource) : (javaType.equals(DatasetType.GRIDCOLLECTION) ? new DatasetGridCollection(dtHandle, datasource) : (javaType.equals(DatasetType.IMAGECOLLECTION) ? new DatasetImageCollection(dtHandle, datasource) : (javaType.equals(DatasetType.MOSAIC) ? new DatasetMosaic(dtHandle, datasource) : null)))))));
        return dataset;
    }

    protected static boolean isVector(Dataset dataset) {
        boolean bl = true;
        bl = dataset == null || dataset.getHandle() == 0L ? false : dataset.isVector();
        return bl;
    }

    private boolean isVector() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsVector(this.getHandle());
    }

    public synchronized void addClosingListener(DatasetClosingListener l) {
        if (this.m_datasetClosingListeners == null) {
            this.m_datasetClosingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetClosingListeners.contains(l)) {
            this.m_datasetClosingListeners.add(l);
        }
    }

    public void removeClosingListener(DatasetClosingListener l) {
        if (this.m_datasetClosingListeners != null && this.m_datasetClosingListeners.contains(l)) {
            this.m_datasetClosingListeners.remove(l);
        }
    }

    protected void fireClosing(DatasetClosingEvent event) {
        if (this.m_datasetClosingListeners != null) {
            CopyOnWriteArrayList<DatasetClosingListener> copyOnWriteArrayList = this.m_datasetClosingListeners;
            for (DatasetClosingListener datasetClosingListener : copyOnWriteArrayList) {
                datasetClosingListener.datasetClosing(event);
            }
        }
    }

    protected void fireLockChanged(DatasetLockChangedEvent event) {
        if (this.m_datasetLockChangedListeners != null) {
            CopyOnWriteArrayList<DatasetLockChangedListener> copyOnWriteArrayList = this.m_datasetLockChangedListeners;
            for (DatasetLockChangedListener datasetLockChangedListener : copyOnWriteArrayList) {
                datasetLockChangedListener.datasetLockChanged(event);
            }
        }
    }

    public synchronized void addLockChangedListener(DatasetLockChangedListener l) {
        if (this.m_datasetLockChangedListeners == null) {
            this.m_datasetLockChangedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetLockChangedListeners.contains(l)) {
            this.m_datasetLockChangedListeners.add(l);
        }
    }

    public void removeLockChangedListener(DatasetLockChangedListener l) {
        if (this.m_datasetLockChangedListeners != null && this.m_datasetLockChangedListeners.contains(l)) {
            this.m_datasetLockChangedListeners.remove(l);
        }
    }

    public synchronized void addClosedListener(DatasetClosedListener l) {
        if (this.m_datasetClosedListeners == null) {
            this.m_datasetClosedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetClosedListeners.contains(l)) {
            this.m_datasetClosedListeners.add(l);
        }
    }

    public void removeClosedListener(DatasetClosedListener l) {
        if (this.m_datasetClosedListeners != null && this.m_datasetClosedListeners.contains(l)) {
            this.m_datasetClosedListeners.remove(l);
        }
    }

    protected void fireClosed(DatasetClosedEvent event) {
        if (this.m_datasetClosedListeners != null) {
            CopyOnWriteArrayList<DatasetClosedListener> copyOnWriteArrayList = this.m_datasetClosedListeners;
            for (DatasetClosedListener datasetClosedListener : copyOnWriteArrayList) {
                datasetClosedListener.datasetClosed(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public LockStateType getLockState() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetLockState(this.getHandle());
        LockStateType lockStateType = null;
        try {
            lockStateType = (LockStateType)Enum.parseUGCValue(LockStateType.class, n);
        }
        catch (Exception exception) {
            lockStateType = LockStateType.LOCKNONE;
        }
        return lockStateType;
    }

    public synchronized boolean setLockState(LockStateType lockType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = lockType.getUGCValue();
        boolean bl = DatasetNative.jni_SetLockState(this.getHandle(), n);
        if (bl) {
            DatasetLockChangedEvent datasetLockChangedEvent = new DatasetLockChangedEvent(this, this);
            this.fireLockChanged(datasetLockChangedEvent);
        }
        return bl;
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_Refresh(this.getHandle());
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(event);
            }
        }
    }

    static void steppedCallBack(Dataset source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetImageNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public boolean isDisposed() {
        return this.getHandle() == 0L;
    }

    protected boolean getIsDisposable() {
        return this.m_disposable;
    }

    protected void setIsDisposable(boolean disposable) {
        this.m_disposable = disposable;
    }

    protected void finalize() {
        if (this.getIsDisposable() && this.getHandle() != 0L) {
            this.dispose();
        }
    }

    protected void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }
}

