/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.server.impl.model.parameter.multivalued.BaseValueOfExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CollectionValueOfExtractor<V extends Collection>
extends BaseValueOfExtractor
implements MultivaluedParameterExtractor {
    final String parameter;
    final Object defaultValue;

    protected CollectionValueOfExtractor(Method valueOf, String parameter, String defaultValueString) throws IllegalAccessException, InvocationTargetException {
        super(valueOf);
        this.parameter = parameter;
        this.defaultValue = defaultValueString != null ? this.getValue(defaultValueString) : null;
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.parameter);
        if (stringList != null) {
            V valueList = this.getInstance();
            for (String v : stringList) {
                valueList.add((Object)this.getValue(v));
            }
            return valueList;
        }
        if (this.defaultValue != null) {
            V valueList = this.getInstance();
            valueList.add((Object)this.defaultValue);
            return valueList;
        }
        return null;
    }

    protected abstract V getInstance();

    static MultivaluedParameterExtractor getInstance(Class c, Method valueOf, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (List.class == c) {
            return new ListValueOf(valueOf, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetValueOf(valueOf, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetValueOf(valueOf, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortedSetValueOf
    extends CollectionValueOfExtractor<SortedSet> {
        SortedSetValueOf(Method valueOf, String parameter, String defaultValueString) throws IllegalAccessException, InvocationTargetException {
            super(valueOf, parameter, defaultValueString);
        }

        @Override
        protected SortedSet getInstance() {
            return new TreeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetValueOf
    extends CollectionValueOfExtractor<Set> {
        SetValueOf(Method valueOf, String parameter, String defaultValueString) throws IllegalAccessException, InvocationTargetException {
            super(valueOf, parameter, defaultValueString);
        }

        @Override
        protected Set getInstance() {
            return new HashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListValueOf
    extends CollectionValueOfExtractor<List> {
        ListValueOf(Method valueOf, String parameter, String defaultValueString) throws IllegalAccessException, InvocationTargetException {
            super(valueOf, parameter, defaultValueString);
        }

        @Override
        protected List getInstance() {
            return new ArrayList();
        }
    }
}

