/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.ryantenney.metrics.spring.AdviceFactory;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

class AdvisingBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisingBeanPostProcessor.class);
    private final ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Pointcut pointcut;
    private final AdviceFactory adviceFactory;
    private final ProxyConfig proxyConfig;

    public AdvisingBeanPostProcessor(Pointcut pointcut, AdviceFactory adviceFactory, ProxyConfig proxyConfig) {
        this.pointcut = pointcut;
        this.adviceFactory = adviceFactory;
        this.proxyConfig = proxyConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (AopUtils.canApply((Pointcut)this.pointcut, (Class)targetClass)) {
            Advice advice = this.adviceFactory.getAdvice(bean, targetClass);
            DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor(this.pointcut, advice);
            if (bean instanceof Advised) {
                LOG.debug("Bean {} is already proxied, adding Advisor to existing proxy", (Object)beanName);
                ((Advised)bean).addAdvisor(0, (Advisor)advisor);
                return bean;
            }
            LOG.debug("Proxying bean {} of type {}", (Object)beanName, (Object)targetClass.getCanonicalName());
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            if (this.proxyConfig != null) {
                proxyFactory.copyFrom(this.proxyConfig);
            }
            proxyFactory.addAdvisor((Advisor)advisor);
            Object proxy = proxyFactory.getProxy(this.beanClassLoader);
            return proxy;
        }
        return bean;
    }
}

