/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeoutException;

public class RecoveryAwareAMQConnectionFactory {
    private final ConnectionParams params;
    private final FrameHandlerFactory factory;
    private final Address[] addrs;

    public RecoveryAwareAMQConnectionFactory(ConnectionParams params, FrameHandlerFactory factory, Address[] addrs) {
        this.params = params;
        this.factory = factory;
        this.addrs = addrs;
    }

    RecoveryAwareAMQConnection newConnection() throws IOException, TimeoutException {
        IOException lastException = null;
        for (Address addr : this.shuffle(this.addrs)) {
            try {
                FrameHandler frameHandler = this.factory.create(addr);
                RecoveryAwareAMQConnection conn = new RecoveryAwareAMQConnection(this.params, frameHandler);
                conn.start();
                return conn;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        throw lastException != null ? lastException : new IOException("failed to connect");
    }

    private Address[] shuffle(Address[] addrs) {
        ArrayList<Address> list = new ArrayList<Address>(Arrays.asList(addrs));
        Collections.shuffle(list);
        Address[] result = new Address[addrs.length];
        list.toArray(result);
        return result;
    }
}

