/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.method.tools;

import com.publiccms.common.base.BaseMethod;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.FreeMarkerUtils;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class GetTemplateResultMethod
extends BaseMethod {
    private Configuration configuration = new Configuration(Configuration.getVersion());

    public GetTemplateResultMethod() {
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateUpdateDelayMilliseconds(0L);
        this.configuration.setAPIBuiltinEnabled(false);
        this.configuration.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
        this.configuration.setLogTemplateExceptions(false);
    }

    public Object exec(List arguments) throws TemplateModelException {
        String template = GetTemplateResultMethod.getString(0, arguments);
        if (CommonUtils.notEmpty(template)) {
            template = "<#attempt>" + template + "<#recover><pre>${.error!}</pre></#attempt>";
            try {
                return FreeMarkerUtils.generateStringByString(template, this.configuration, null);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    @Override
    public boolean needAppToken() {
        return false;
    }

    @Override
    public int minParamtersNumber() {
        return 1;
    }
}

