/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.method.tools;

import com.publiccms.common.base.BaseMethod;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.TemplateModelUtils;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

@Component
public class GetHtmlMethod
extends BaseMethod {
    public Object exec(List arguments) throws TemplateModelException {
        String url = GetHtmlMethod.getString(0, arguments);
        TemplateHashModelEx paramters = GetHtmlMethod.getMap(1, arguments);
        String body = GetHtmlMethod.getString(1, arguments);
        String html = null;
        if (CommonUtils.notEmpty(url)) {
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpGet request;
                if (null != paramters || CommonUtils.notEmpty(body)) {
                    HttpPost httppost = new HttpPost(url);
                    if (null != paramters) {
                        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                        TemplateModelIterator it = paramters.keys().iterator();
                        while (it.hasNext()) {
                            String key = TemplateModelUtils.converString(it.next());
                            nvps.add(new BasicNameValuePair(key, TemplateModelUtils.converString(paramters.get(key))));
                        }
                        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, DEFAULT_CHARSET));
                    } else {
                        httppost.setEntity((HttpEntity)new StringEntity(body, DEFAULT_CHARSET));
                    }
                    request = httppost;
                } else {
                    request = new HttpGet(url);
                }
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                    HttpEntity entity = response.getEntity();
                    if (null != entity) {
                        html = EntityUtils.toString((HttpEntity)entity, (Charset)DEFAULT_CHARSET);
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
                return null;
            }
            return html;
        }
        return null;
    }

    @Override
    public boolean needAppToken() {
        return true;
    }

    @Override
    public int minParamtersNumber() {
        return 1;
    }
}

