/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.method.tools;

import com.publiccms.common.base.BaseMethod;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.TemplateModelException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class GetDateMethod
extends BaseMethod {
    public Object exec(List arguments) throws TemplateModelException {
        Date date;
        if (arguments.size() >= 2) {
            try {
                date = GetDateMethod.getDate(1, arguments);
            }
            catch (ParseException e) {
                date = CommonUtils.getDate();
            }
        } else {
            date = CommonUtils.getDate();
        }
        if (arguments.size() >= 1) {
            String type;
            switch (type = GetDateMethod.getString(0, arguments)) {
                case "thisSunday": {
                    date = this.getThisSunday(date);
                    break;
                }
                case "thisMonday": {
                    date = this.getThisMonday(date);
                    break;
                }
                case "lastMonday": {
                    date = this.getLastMonday(date);
                    break;
                }
                case "lastSunday": {
                    date = this.getLastSunday(date);
                }
            }
        }
        return date;
    }

    @Override
    public boolean needAppToken() {
        return false;
    }

    @Override
    public int minParamtersNumber() {
        return 0;
    }

    Date getThisMonday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.addDays((Date)date, (int)-1));
        calendar.set(7, 2);
        return calendar.getTime();
    }

    Date getThisSunday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.addDays((Date)date, (int)6));
        calendar.set(7, 1);
        return calendar.getTime();
    }

    Date getLastMonday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.addDays((Date)date, (int)-8));
        calendar.set(7, 2);
        return calendar.getTime();
    }

    Date getLastSunday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.addDays((Date)date, (int)-1));
        calendar.set(7, 1);
        return calendar.getTime();
    }
}

